/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.async;

import java.io.InputStream;
import java.rmi.server.UID;
import java.text.ParseException;
import java.util.Date;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.async.AbstractDispatcher;
import org.jboss.seam.async.Asynchronous;
import org.jboss.seam.async.AsynchronousEvent;
import org.jboss.seam.async.AsynchronousInvocation;
import org.jboss.seam.async.CronSchedule;
import org.jboss.seam.async.QuartzTriggerHandle;
import org.jboss.seam.async.Schedule;
import org.jboss.seam.async.TimerSchedule;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Startup
@Scope(value=ScopeType.APPLICATION)
@Name(value="org.jboss.seam.async.dispatcher")
@Install(value=false, precedence=0)
@BypassInterceptors
public class QuartzDispatcher
extends AbstractDispatcher<QuartzTriggerHandle, Schedule> {
    private static final LogProvider log = Logging.getLogProvider(QuartzDispatcher.class);
    private Scheduler scheduler;

    @Create
    public void initScheduler() throws SchedulerException {
        StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("seam.quartz.properties");
        if (is != null) {
            schedulerFactory.initialize(is);
            log.debug("Found seam.quartz.properties file. Using it for Quartz config.");
        } else {
            schedulerFactory.initialize();
            log.warn("No seam.quartz.properties file. Using in-memory job store.");
        }
        this.scheduler = schedulerFactory.getScheduler();
        this.scheduler.start();
    }

    @Override
    public QuartzTriggerHandle scheduleAsynchronousEvent(String type, Object ... parameters) {
        String jobName = this.nextUniqueName();
        String triggerName = this.nextUniqueName();
        JobDetail jobDetail = new JobDetail(jobName, null, QuartzJob.class);
        jobDetail.getJobDataMap().put((Object)"async", (Object)new AsynchronousEvent(type, parameters));
        SimpleTrigger trigger = new SimpleTrigger(triggerName, null);
        try {
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            return new QuartzTriggerHandle(triggerName);
        }
        catch (Exception se) {
            log.debug("Cannot Schedule a Quartz Job");
            throw new RuntimeException(se);
        }
    }

    @Override
    public QuartzTriggerHandle scheduleTimedEvent(String type, Schedule schedule, Object ... parameters) {
        return this.scheduleWithQuartzServiceAndWrapExceptions(schedule, new AsynchronousEvent(type, parameters));
    }

    @Override
    public QuartzTriggerHandle scheduleInvocation(InvocationContext invocation, Component component) {
        return this.scheduleWithQuartzServiceAndWrapExceptions(this.createSchedule(invocation), new AsynchronousInvocation(invocation, component));
    }

    private static Date calculateDelayedDate(long delay) {
        Date now = new Date();
        now.setTime(now.getTime() + delay);
        return now;
    }

    private QuartzTriggerHandle scheduleWithQuartzServiceAndWrapExceptions(Schedule schedule, Asynchronous async) {
        try {
            return this.scheduleWithQuartzService(schedule, async);
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
        catch (SchedulerException se) {
            throw new RuntimeException(se);
        }
    }

    private QuartzTriggerHandle scheduleWithQuartzService(Schedule schedule, Asynchronous async) throws SchedulerException, ParseException {
        String jobName = this.nextUniqueName();
        String triggerName = this.nextUniqueName();
        JobDetail jobDetail = new JobDetail(jobName, null, QuartzJob.class);
        jobDetail.getJobDataMap().put((Object)"async", (Object)async);
        if (schedule instanceof CronSchedule) {
            CronSchedule cronSchedule = (CronSchedule)schedule;
            CronTrigger trigger = new CronTrigger(triggerName, null);
            trigger.setCronExpression(cronSchedule.getCron());
            trigger.setEndTime(cronSchedule.getFinalExpiration());
            if (cronSchedule.getExpiration() != null) {
                trigger.setStartTime(cronSchedule.getExpiration());
            } else if (cronSchedule.getDuration() != null) {
                trigger.setStartTime(QuartzDispatcher.calculateDelayedDate(cronSchedule.getDuration()));
            }
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        } else if (schedule instanceof TimerSchedule) {
            TimerSchedule timerSchedule = (TimerSchedule)schedule;
            if (timerSchedule.getIntervalDuration() != null) {
                if (timerSchedule.getExpiration() != null) {
                    SimpleTrigger trigger = new SimpleTrigger(triggerName, null, timerSchedule.getExpiration(), timerSchedule.getFinalExpiration(), SimpleTrigger.REPEAT_INDEFINITELY, timerSchedule.getIntervalDuration().longValue());
                    this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
                } else if (timerSchedule.getDuration() != null) {
                    SimpleTrigger trigger = new SimpleTrigger(triggerName, null, QuartzDispatcher.calculateDelayedDate(timerSchedule.getDuration()), timerSchedule.getFinalExpiration(), SimpleTrigger.REPEAT_INDEFINITELY, timerSchedule.getIntervalDuration().longValue());
                    this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
                } else {
                    SimpleTrigger trigger = new SimpleTrigger(triggerName, null, new Date(), timerSchedule.getFinalExpiration(), SimpleTrigger.REPEAT_INDEFINITELY, timerSchedule.getIntervalDuration().longValue());
                    this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
                }
            } else if (schedule.getExpiration() != null) {
                SimpleTrigger trigger = new SimpleTrigger(triggerName, null, schedule.getExpiration());
                this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            } else if (schedule.getDuration() != null) {
                SimpleTrigger trigger = new SimpleTrigger(triggerName, null, QuartzDispatcher.calculateDelayedDate(schedule.getDuration()));
                this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            } else {
                SimpleTrigger trigger = new SimpleTrigger(triggerName, null);
                this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            }
        } else {
            throw new IllegalArgumentException("unrecognized schedule type");
        }
        return new QuartzTriggerHandle(triggerName);
    }

    private String nextUniqueName() {
        return new UID().toString();
    }

    @Destroy
    public void destroy() throws SchedulerException {
        this.scheduler.shutdown();
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public static QuartzDispatcher instance() {
        return (QuartzDispatcher)AbstractDispatcher.instance();
    }

    public static class QuartzJob
    implements Job {
        private Asynchronous async;

        public void execute(JobExecutionContext context) throws JobExecutionException {
            JobDataMap dataMap = context.getJobDetail().getJobDataMap();
            this.async = (Asynchronous)dataMap.get((Object)"async");
            QuartzTriggerHandle handle = new QuartzTriggerHandle(context.getTrigger().getName());
            try {
                this.async.execute(handle);
            }
            catch (Exception e) {
                this.async.handleException(e, handle);
            }
        }
    }
}

