/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.contexts;

import java.util.Map;
import java.util.Set;
import org.jboss.seam.ScopeType;
import org.jboss.seam.contexts.ApplicationContext;
import org.jboss.seam.contexts.BasicContext;
import org.jboss.seam.contexts.BusinessProcessContext;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.SessionContext;
import org.jboss.seam.core.ConversationEntries;
import org.jboss.seam.core.Manager;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lifecycle {
    private static final LogProvider log = Logging.getLogProvider(Lifecycle.class);
    private static ThreadLocal<Boolean> destroying = new ThreadLocal();
    private static Map<String, Object> application;

    public static Map<String, Object> getApplication() {
        if (!Lifecycle.isApplicationInitialized()) {
            throw new IllegalStateException("Attempted to invoke a Seam component outside an initialized application");
        }
        return application;
    }

    public static boolean isApplicationInitialized() {
        return application != null;
    }

    public static void beginApplication(Map<String, Object> app) {
        application = app;
    }

    public static void endApplication() {
        log.debug("Shutting down application and destroying contexts");
        ApplicationContext tempApplicationContext = new ApplicationContext(Lifecycle.getApplication());
        Contexts.applicationContext.set(tempApplicationContext);
        Contexts.destroy(tempApplicationContext);
        Contexts.applicationContext.set(null);
        Contexts.eventContext.set(null);
        Contexts.sessionContext.set(null);
        Contexts.conversationContext.set(null);
        application = null;
    }

    public static void startDestroying() {
        destroying.set(true);
    }

    public static void stopDestroying() {
        destroying.set(false);
    }

    public static boolean isDestroying() {
        Boolean value = destroying.get();
        return value != null && value != false;
    }

    public static void beginCall() {
        log.debug(">>> Begin call");
        Contexts.applicationContext.set(new ApplicationContext(Lifecycle.getApplication()));
        Contexts.eventContext.set(new BasicContext(ScopeType.EVENT));
        Contexts.sessionContext.set(new BasicContext(ScopeType.SESSION));
        Contexts.conversationContext.set(new BasicContext(ScopeType.CONVERSATION));
        Contexts.businessProcessContext.set(new BusinessProcessContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endCall() {
        try {
            Contexts.destroy(Contexts.getSessionContext());
            Contexts.flushAndDestroyContexts();
            if (Manager.instance().isLongRunningConversation()) {
                throw new IllegalStateException("Do not start long-running conversations in direct calls to EJBs");
            }
        }
        finally {
            Lifecycle.clearThreadlocals();
            log.debug("<<< End call");
        }
    }

    @Deprecated
    public static void mockApplication() {
        Lifecycle.setupApplication(null);
    }

    @Deprecated
    public static void unmockApplication() {
        Lifecycle.cleanupApplication();
    }

    public static void setupApplication() {
        Contexts.applicationContext.set(new ApplicationContext(Lifecycle.getApplication()));
    }

    public static void setupApplication(Map<String, Object> appCtx) {
        Contexts.applicationContext.set(new ApplicationContext(appCtx));
    }

    public static void cleanupApplication() {
        Contexts.applicationContext.set(null);
    }

    public static Context beginMethod() {
        Context result = Contexts.methodContext.get();
        Contexts.methodContext.set(new BasicContext(ScopeType.METHOD));
        return result;
    }

    public static void endMethod(Context context) {
        Contexts.methodContext.set(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endRequest() {
        log.debug("After request, destroying contexts");
        try {
            Contexts.flushAndDestroyContexts();
        }
        finally {
            Lifecycle.clearThreadlocals();
            log.debug("<<< End web request");
        }
    }

    static void clearThreadlocals() {
        Contexts.eventContext.set(null);
        Contexts.pageContext.set(null);
        Contexts.sessionContext.set(null);
        Contexts.conversationContext.set(null);
        Contexts.businessProcessContext.set(null);
        Contexts.applicationContext.set(null);
    }

    public static void destroyConversationContext(Map<String, Object> session, String conversationId) {
        Contexts.destroyConversationContext(session, conversationId);
    }

    @Deprecated
    public static void beginSession(Map<String, Object> session) {
        Lifecycle.beginSession(session, null);
    }

    public static void beginSession(Map<String, Object> session, Map<String, Object> appCtx) {
        log.debug("Session started");
        boolean applicationContextActive = Contexts.isApplicationContextActive();
        boolean eventContextActive = Contexts.isEventContextActive();
        boolean conversationContextActive = Contexts.isConversationContextActive();
        if (!applicationContextActive) {
            ApplicationContext tempApplicationContext = null;
            tempApplicationContext = appCtx == null ? new ApplicationContext(Lifecycle.getApplication()) : new ApplicationContext(appCtx);
            Contexts.applicationContext.set(tempApplicationContext);
        }
        Context oldSessionContext = Contexts.sessionContext.get();
        Contexts.sessionContext.set(new SessionContext(session));
        BasicContext tempEventContext = null;
        if (!eventContextActive) {
            tempEventContext = new BasicContext(ScopeType.EVENT);
            Contexts.eventContext.set(tempEventContext);
        }
        BasicContext tempConversationContext = null;
        if (!conversationContextActive) {
            tempConversationContext = new BasicContext(ScopeType.CONVERSATION);
            Contexts.conversationContext.set(tempConversationContext);
        }
        Contexts.startup(ScopeType.SESSION);
        if (!conversationContextActive) {
            Contexts.destroy(tempConversationContext);
            Contexts.conversationContext.set(null);
        }
        if (!eventContextActive) {
            Contexts.destroy(tempEventContext);
            Contexts.eventContext.set(null);
        }
        Contexts.sessionContext.set(oldSessionContext);
        if (!applicationContextActive) {
            Contexts.applicationContext.set(null);
        }
    }

    public static void endSession(Map<String, Object> session) {
        log.debug("End of session, destroying contexts");
        if (Contexts.isEventContextActive() || Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("Please end the HttpSession via org.jboss.seam.web.Session.instance().invalidate()");
        }
        ApplicationContext tempApplicationContext = new ApplicationContext(Lifecycle.getApplication());
        Contexts.applicationContext.set(tempApplicationContext);
        BasicContext tempEventContext = new BasicContext(ScopeType.EVENT);
        Contexts.eventContext.set(tempEventContext);
        SessionContext tempSessionContext = new SessionContext(session);
        Contexts.sessionContext.set(tempSessionContext);
        Set<String> conversationIds = ConversationEntries.instance().getConversationIds();
        log.debug("destroying conversation contexts: " + conversationIds);
        for (String conversationId : conversationIds) {
            Contexts.destroyConversationContext(session, conversationId);
        }
        BasicContext tempConversationContext = new BasicContext(ScopeType.CONVERSATION);
        Contexts.conversationContext.set(tempConversationContext);
        log.debug("destroying session context");
        Contexts.destroy(tempSessionContext);
        Contexts.sessionContext.set(null);
        Contexts.destroy(tempConversationContext);
        Contexts.conversationContext.set(null);
        Contexts.destroy(tempEventContext);
        Contexts.eventContext.set(null);
        Contexts.applicationContext.set(null);
    }
}

