/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.digest;

import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.digest.DigestRequest;
import org.jboss.seam.security.digest.DigestUtils;

public abstract class DigestAuthenticator {
    protected boolean validatePassword(String password) {
        Context ctx = Contexts.getSessionContext();
        DigestRequest digestRequest = (DigestRequest)ctx.get("org.jboss.seam.security.digestRequest");
        if (digestRequest == null) {
            throw new IllegalStateException("No digest request found in session scope");
        }
        ctx.remove("org.jboss.seam.security.digestRequest");
        String serverDigestMd5 = DigestUtils.generateDigest(digestRequest.isPasswordAlreadyEncoded(), Identity.instance().getUsername(), digestRequest.getRealm(), password, digestRequest.getHttpMethod(), digestRequest.getUri(), digestRequest.getQop(), digestRequest.getNonce(), digestRequest.getNonceCount(), digestRequest.getClientNonce());
        return serverDigestMd5.equals(digestRequest.getClientDigest());
    }
}

