/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedBeanProperty<T extends Annotation> {
    private Field propertyField;
    private Method propertyGetter;
    private Method propertySetter;
    private T annotation;
    private String name;
    private Class propertyClass;
    private boolean isFieldProperty;

    private AnnotatedBeanProperty(Field propertyField, T annotation) {
        this.propertyField = propertyField;
        this.isFieldProperty = true;
        this.annotation = annotation;
        this.name = propertyField.getName();
        this.propertyClass = propertyField.getDeclaringClass();
    }

    private AnnotatedBeanProperty(Method propertyMethod, T annotation) {
        if (!propertyMethod.getName().startsWith("get") && !propertyMethod.getName().startsWith("is")) {
            throw new IllegalArgumentException("Bean property method name " + propertyMethod.getClass().getName() + "." + propertyMethod.getName() + "() must start with \"get\" or \"is\".");
        }
        if (propertyMethod.getReturnType().equals(Void.TYPE) || propertyMethod.getParameterTypes().length > 0) {
            throw new IllegalArgumentException("Bean property method " + propertyMethod.getClass().getName() + "." + propertyMethod.getName() + "() must return a value and take no parameters");
        }
        this.propertyGetter = propertyMethod;
        this.propertyClass = propertyMethod.getReturnType();
        String methodName = propertyMethod.getName();
        this.name = methodName.startsWith("get") ? methodName.substring(3, 4).toLowerCase() + methodName.substring(4) : methodName.substring(2, 3).toLowerCase() + methodName.substring(3);
        String setterName = propertyMethod.getName().startsWith("get") ? "set" + methodName.substring(3) : "set" + methodName.substring(2);
        try {
            this.propertySetter = propertyMethod.getDeclaringClass().getMethod(setterName, propertyMethod.getReturnType());
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException("Bean property method " + propertyMethod.getClass().getName() + "." + propertyMethod.getName() + "() must have a corresponding setter method.");
        }
        this.isFieldProperty = false;
        this.annotation = annotation;
    }

    public void setValue(Object bean, Object value) {
        if (this.isFieldProperty) {
            boolean accessible = this.propertyField.isAccessible();
            try {
                this.propertyField.setAccessible(true);
                this.propertyField.set(bean, value);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Exception setting bean property", ex);
            }
            finally {
                this.propertyField.setAccessible(accessible);
            }
        }
        try {
            this.propertySetter.invoke(bean, value);
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception setting bean property", ex);
        }
    }

    public Object getValue(Object bean) {
        if (this.isFieldProperty) {
            boolean accessible = this.propertyField.isAccessible();
            try {
                this.propertyField.setAccessible(true);
                Object object = this.propertyField.get(bean);
                return object;
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Exception getting bean property", ex);
            }
            finally {
                this.propertyField.setAccessible(accessible);
            }
        }
        try {
            return this.propertyGetter.invoke(bean, new Object[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception getting bean property", ex);
        }
    }

    public T getAnnotation() {
        return this.annotation;
    }

    public String getName() {
        return this.name;
    }

    public Class getPropertyClass() {
        return this.propertyClass;
    }

    public static AnnotatedBeanProperty scanForProperty(Class cls, Class<? extends Annotation> annotation) {
        for (Field field : cls.getFields()) {
            if (!field.isAnnotationPresent(annotation)) continue;
            return new AnnotatedBeanProperty<Annotation>(field, field.getAnnotation(annotation));
        }
        for (AccessibleObject accessibleObject : cls.getMethods()) {
            if (!accessibleObject.isAnnotationPresent(annotation)) continue;
            return new AnnotatedBeanProperty<Annotation>((Method)accessibleObject, ((Method)accessibleObject).getAnnotation(annotation));
        }
        return null;
    }
}

