/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.seam.annotations.intercept.AroundInvoke;
import org.jboss.seam.annotations.intercept.Interceptor;
import org.jboss.seam.annotations.intercept.InterceptorType;
import org.jboss.seam.annotations.security.PermissionCheck;
import org.jboss.seam.annotations.security.Restrict;
import org.jboss.seam.annotations.security.RoleCheck;
import org.jboss.seam.async.AsynchronousInterceptor;
import org.jboss.seam.intercept.AbstractInterceptor;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.security.Identity;
import org.jboss.seam.util.Strings;

@Interceptor(type=InterceptorType.CLIENT, around={AsynchronousInterceptor.class})
public class SecurityInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = -6567750187000766925L;
    private Map<Method, Restriction> restrictions = new HashMap<Method, Restriction>();

    @AroundInvoke
    public Object aroundInvoke(InvocationContext invocation) throws Exception {
        Method interfaceMethod = invocation.getMethod();
        Restriction restriction = this.getRestriction(interfaceMethod);
        if (restriction != null) {
            restriction.check(invocation.getParameters());
        }
        return invocation.proceed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Restriction getRestriction(Method interfaceMethod) throws Exception {
        if (!this.restrictions.containsKey(interfaceMethod)) {
            Map<Method, Restriction> map = this.restrictions;
            synchronized (map) {
                if (!this.restrictions.containsKey(interfaceMethod)) {
                    Restriction restriction = null;
                    Method method = this.getComponent().getBeanClass().getMethod(interfaceMethod.getName(), interfaceMethod.getParameterTypes());
                    Restrict restrict = null;
                    if (method.isAnnotationPresent(Restrict.class)) {
                        restrict = method.getAnnotation(Restrict.class);
                    } else if (this.getComponent().getBeanClass().isAnnotationPresent(Restrict.class) && !this.getComponent().isLifecycleMethod(method)) {
                        restrict = this.getComponent().getBeanClass().getAnnotation(Restrict.class);
                    }
                    if (restrict != null) {
                        if (restriction == null) {
                            restriction = new Restriction();
                        }
                        restriction.setExpression(!Strings.isEmpty(restrict.value()) ? restrict.value() : this.createDefaultExpr(method));
                    }
                    for (Annotation annotation : method.getDeclaringClass().getAnnotations()) {
                        if (!annotation.annotationType().isAnnotationPresent(RoleCheck.class)) continue;
                        if (restriction == null) {
                            restriction = new Restriction();
                        }
                        restriction.addRoleRestriction(annotation.annotationType().getSimpleName().toLowerCase());
                    }
                    for (Annotation annotation : method.getAnnotations()) {
                        if (annotation.annotationType().isAnnotationPresent(PermissionCheck.class)) {
                            PermissionCheck permissionCheck = annotation.annotationType().getAnnotation(PermissionCheck.class);
                            Method valueMethod = null;
                            int i$ = 0;
                            Method[] arr$ = annotation.annotationType().getDeclaredMethods();
                            int len$ = arr$.length;
                            if (i$ < len$) {
                                Method m;
                                valueMethod = m = arr$[i$];
                            }
                            if (valueMethod != null) {
                                Object target;
                                if (restriction == null) {
                                    restriction = new Restriction();
                                }
                                if (!(target = valueMethod.invoke((Object)annotation, new Object[0])).equals(Void.TYPE)) {
                                    if (restriction == null) {
                                        restriction = new Restriction();
                                    }
                                    restriction.addMethodRestriction(target, this.getPermissionAction(permissionCheck, annotation));
                                }
                            }
                        }
                        if (!annotation.annotationType().isAnnotationPresent(RoleCheck.class)) continue;
                        if (restriction == null) {
                            restriction = new Restriction();
                        }
                        restriction.addRoleRestriction(annotation.annotationType().getSimpleName().toLowerCase());
                    }
                    for (int i = 0; i < method.getParameterAnnotations().length; ++i) {
                        Annotation[] annotations;
                        for (Annotation annotation : annotations = method.getParameterAnnotations()[i]) {
                            if (!annotation.annotationType().isAnnotationPresent(PermissionCheck.class)) continue;
                            PermissionCheck permissionCheck = annotation.annotationType().getAnnotation(PermissionCheck.class);
                            if (restriction == null) {
                                restriction = new Restriction();
                            }
                            restriction.addParameterRestriction(i, this.getPermissionAction(permissionCheck, annotation));
                        }
                    }
                    this.restrictions.put(interfaceMethod, restriction);
                    return restriction;
                }
            }
        }
        return this.restrictions.get(interfaceMethod);
    }

    private String getPermissionAction(PermissionCheck check, Annotation annotation) {
        if (!"".equals(check.value())) {
            return check.value();
        }
        return annotation.annotationType().getSimpleName().toLowerCase();
    }

    private String createDefaultExpr(Method method) {
        return String.format("#{s:hasPermission('%s','%s')}", this.getComponent().getName(), method.getName());
    }

    public boolean isInterceptorEnabled() {
        return this.getComponent().isSecure() && !this.getComponent().beanClassHasAnnotation("javax.jws.WebService");
    }

    private class Restriction {
        private String expression;
        private Map<String, Object> methodRestrictions;
        private Map<Integer, Set<String>> paramRestrictions;
        private Set<String> roleRestrictions;

        private Restriction() {
        }

        public void setExpression(String expression) {
            this.expression = expression;
        }

        public void addMethodRestriction(Object target, String action) {
            if (this.methodRestrictions == null) {
                this.methodRestrictions = new HashMap<String, Object>();
            }
            this.methodRestrictions.put(action, target);
        }

        public void addRoleRestriction(String role) {
            if (this.roleRestrictions == null) {
                this.roleRestrictions = new HashSet<String>();
            }
            this.roleRestrictions.add(role);
        }

        public void addParameterRestriction(int index, String action) {
            Set<Object> actions = null;
            if (this.paramRestrictions == null) {
                this.paramRestrictions = new HashMap<Integer, Set<String>>();
            }
            if (!this.paramRestrictions.containsKey(index)) {
                actions = new HashSet();
                this.paramRestrictions.put(index, actions);
            } else {
                actions = this.paramRestrictions.get(index);
            }
            actions.add(action);
        }

        public void check(Object[] parameters) {
            if (Identity.isSecurityEnabled()) {
                if (this.expression != null) {
                    Identity.instance().checkRestriction(this.expression);
                }
                if (this.methodRestrictions != null) {
                    for (String action : this.methodRestrictions.keySet()) {
                        Identity.instance().checkPermission(this.methodRestrictions.get(action), action);
                    }
                }
                if (this.paramRestrictions != null) {
                    for (Integer idx : this.paramRestrictions.keySet()) {
                        Set<String> actions = this.paramRestrictions.get(idx);
                        for (String action : actions) {
                            Identity.instance().checkPermission(parameters[idx], action);
                        }
                    }
                }
                if (this.roleRestrictions != null) {
                    for (String role : this.roleRestrictions) {
                        Identity.instance().checkRole(role);
                    }
                }
            }
        }
    }
}

