/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security;

import java.io.Serializable;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.annotations.security.TokenUsername;
import org.jboss.seam.annotations.security.TokenValue;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.security.TokenStore;
import org.jboss.seam.security.management.IdentityManagementException;
import org.jboss.seam.util.AnnotatedBeanProperty;

@Name(value="org.jboss.seam.security.tokenStore")
@Install(precedence=0, value=false)
@Scope(value=ScopeType.APPLICATION)
@BypassInterceptors
public class JpaTokenStore
implements TokenStore,
Serializable {
    private Class tokenClass;
    private Expressions.ValueExpression<EntityManager> entityManager;
    private AnnotatedBeanProperty<TokenUsername> tokenUsernameProperty;
    private AnnotatedBeanProperty<TokenValue> tokenValueProperty;

    @Create
    public void create() {
        if (this.entityManager == null) {
            this.entityManager = Expressions.instance().createValueExpression("#{entityManager}", EntityManager.class);
        }
        this.tokenUsernameProperty = AnnotatedBeanProperty.scanForProperty(this.tokenClass, TokenUsername.class);
        this.tokenValueProperty = AnnotatedBeanProperty.scanForProperty(this.tokenClass, TokenValue.class);
        if (this.tokenUsernameProperty == null) {
            throw new IllegalStateException("Invalid tokenClass " + this.tokenClass.getName() + " - required annotation @TokenUsername not found on any Field or Method.");
        }
        if (this.tokenValueProperty == null) {
            throw new IllegalStateException("Invalid tokenClass " + this.tokenClass.getName() + " - required annotation @TokenValue not found on any Field or Method.");
        }
    }

    public void createToken(String username, String value) {
        if (this.tokenClass == null) {
            throw new IllegalStateException("Could not create token, tokenClass not set");
        }
        try {
            Object token = this.tokenClass.newInstance();
            this.tokenUsernameProperty.setValue(token, username);
            this.tokenValueProperty.setValue(token, value);
            this.lookupEntityManager().persist(token);
        }
        catch (Exception ex) {
            if (ex instanceof IdentityManagementException) {
                throw (IdentityManagementException)ex;
            }
            throw new IdentityManagementException("Could not create account", ex);
        }
    }

    public boolean validateToken(String username, String value) {
        return this.lookupToken(username, value) != null;
    }

    public void invalidateToken(String username, String value) {
        Object token = this.lookupToken(username, value);
        if (token != null) {
            this.lookupEntityManager().remove(token);
        }
    }

    public void invalidateAll(String username) {
        Query query = this.lookupEntityManager().createQuery("select t from " + this.tokenClass.getName() + " t where " + this.tokenUsernameProperty.getName() + " = :username").setParameter("username", (Object)username);
        for (Object token : query.getResultList()) {
            this.lookupEntityManager().remove(token);
        }
    }

    public Object lookupToken(String username, String value) {
        try {
            Object token = this.lookupEntityManager().createQuery("select t from " + this.tokenClass.getName() + " t where " + this.tokenUsernameProperty.getName() + " = :username and " + this.tokenValueProperty.getName() + " = :value").setParameter("username", (Object)username).setParameter("value", (Object)value).getSingleResult();
            return token;
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public Class getTokenClass() {
        return this.tokenClass;
    }

    public void setTokenClass(Class tokenClass) {
        this.tokenClass = tokenClass;
    }

    private EntityManager lookupEntityManager() {
        return this.entityManager.getValue();
    }

    public Expressions.ValueExpression getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(Expressions.ValueExpression expression) {
        this.entityManager = expression;
    }
}

