/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence;

import javax.annotation.PostConstruct;
import javax.ejb.PostActivate;
import org.hibernate.Session;
import org.jboss.seam.Component;
import org.jboss.seam.annotations.intercept.AroundInvoke;
import org.jboss.seam.annotations.intercept.Interceptor;
import org.jboss.seam.intercept.AbstractInterceptor;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.persistence.HibernatePersistenceProvider;
import org.jboss.seam.persistence.HibernateSessionProxy;

@Interceptor(stateless=true)
public class HibernateSessionProxyInterceptor
extends AbstractInterceptor {
    @AroundInvoke
    public Object aroundInvoke(InvocationContext ic) throws Exception {
        return ic.proceed();
    }

    @PostActivate
    public void postActivate(InvocationContext invocation) throws Exception {
        this.proxyPersistenceContexts(invocation.getTarget());
        invocation.proceed();
    }

    @PostConstruct
    public void postConstruct(InvocationContext invocation) throws Exception {
        this.proxyPersistenceContexts(invocation.getTarget());
        invocation.proceed();
    }

    private void proxyPersistenceContexts(Object bean) {
        for (Component.BijectedAttribute ba : this.getComponent().getPersistenceContextAttributes()) {
            Object object = ba.get(bean);
            if (object instanceof HibernateSessionProxy || !(object instanceof Session)) continue;
            ba.set(bean, HibernatePersistenceProvider.proxySession((Session)object));
        }
    }
}

