/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Interpolator;
import org.jboss.seam.core.Locale;
import org.jboss.seam.core.ResourceLoader;
import org.jboss.seam.navigation.Pages;
import org.jboss.seam.util.EnumerationEnumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeamResourceBundle
extends ResourceBundle {
    private Map<java.util.Locale, List<ResourceBundle>> bundleCache = new ConcurrentHashMap<java.util.Locale, List<ResourceBundle>>();

    public static ResourceBundle getBundle() {
        return ResourceBundle.getBundle(SeamResourceBundle.class.getName(), Locale.instance());
    }

    private List<ResourceBundle> getBundlesForCurrentLocale() {
        java.util.Locale instance = Locale.instance();
        List<ResourceBundle> bundles = this.bundleCache.get(instance);
        if (bundles == null) {
            bundles = this.loadBundlesForCurrentLocale();
            this.bundleCache.put(instance, bundles);
        }
        return bundles;
    }

    private List<ResourceBundle> loadBundlesForCurrentLocale() {
        ArrayList<ResourceBundle> bundles = new ArrayList<ResourceBundle>();
        ResourceLoader resourceLoader = ResourceLoader.instance();
        for (String bundleName : resourceLoader.getBundleNames()) {
            ResourceBundle bundle = resourceLoader.loadBundle(bundleName);
            if (bundle == null) continue;
            bundles.add(bundle);
        }
        ResourceBundle bundle = resourceLoader.loadBundle("ValidatorMessages");
        if (bundle != null) {
            bundles.add(bundle);
        }
        if ((bundle = resourceLoader.loadBundle("org/hibernate/validator/resources/DefaultValidatorMessages")) != null) {
            bundles.add(bundle);
        }
        if ((bundle = resourceLoader.loadBundle("javax.faces.Messages")) != null) {
            bundles.add(bundle);
        }
        return Collections.unmodifiableList(bundles);
    }

    @Override
    public Enumeration<String> getKeys() {
        List<ResourceBundle> pageBundles = this.getPageResourceBundles();
        List<ResourceBundle> bundles = this.getBundlesForCurrentLocale();
        Enumeration[] enumerations = new Enumeration[bundles.size() + pageBundles.size()];
        int i = 0;
        for (ResourceBundle bundle : pageBundles) {
            enumerations[i++] = bundle.getKeys();
        }
        for (ResourceBundle bundle : bundles) {
            enumerations[i++] = bundle.getKeys();
        }
        return new EnumerationEnumeration<String>(enumerations);
    }

    @Override
    protected Object handleGetObject(String key) {
        if (!Contexts.isApplicationContextActive()) {
            return null;
        }
        List<ResourceBundle> pageBundles = this.getPageResourceBundles();
        for (ResourceBundle pageBundle : pageBundles) {
            try {
                return this.interpolate(pageBundle.getObject(key));
            }
            catch (MissingResourceException mre) {
            }
        }
        for (ResourceBundle littleBundle : this.getBundlesForCurrentLocale()) {
            try {
                return this.interpolate(littleBundle.getObject(key));
            }
            catch (MissingResourceException mre) {
            }
        }
        return null;
    }

    private Object interpolate(Object message) {
        return message != null && message instanceof String ? Interpolator.instance().interpolate((String)message, new Object[0]) : message;
    }

    private List<ResourceBundle> getPageResourceBundles() {
        String viewId = Pages.getCurrentViewId();
        if (viewId != null) {
            return Pages.instance().getResourceBundles(viewId);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public java.util.Locale getLocale() {
        return Locale.instance();
    }
}

