/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.mock;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.el.ELResolver;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.mail.internet.MimeMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.transaction.UserTransaction;
import org.hibernate.validator.ClassValidator;
import org.hibernate.validator.InvalidValue;
import org.jboss.seam.Component;
import org.jboss.seam.Seam;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.FacesLifecycle;
import org.jboss.seam.contexts.ServletLifecycle;
import org.jboss.seam.contexts.TestLifecycle;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.Manager;
import org.jboss.seam.core.Validators;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.faces.Renderer;
import org.jboss.seam.init.Initialization;
import org.jboss.seam.jsf.SeamApplication;
import org.jboss.seam.jsf.SeamPhaseListener;
import org.jboss.seam.mail.MailSession;
import org.jboss.seam.mock.EmbeddedBootstrap;
import org.jboss.seam.mock.MockApplication;
import org.jboss.seam.mock.MockExternalContext;
import org.jboss.seam.mock.MockFacesContext;
import org.jboss.seam.mock.MockFilterConfig;
import org.jboss.seam.mock.MockHttpServletRequest;
import org.jboss.seam.mock.MockHttpServletResponse;
import org.jboss.seam.mock.MockHttpSession;
import org.jboss.seam.mock.MockLifecycle;
import org.jboss.seam.mock.MockServletContext;
import org.jboss.seam.mock.MockTransport;
import org.jboss.seam.pageflow.Pageflow;
import org.jboss.seam.servlet.SeamFilter;
import org.jboss.seam.servlet.ServletSessionMap;
import org.jboss.seam.transaction.Transaction;
import org.jboss.seam.util.Naming;
import org.jboss.seam.util.Reflections;

public class BaseSeamTest {
    private Application application;
    private MockServletContext servletContext;
    private SeamPhaseListener phases;
    private MockHttpSession session;
    private Map<String, Map> conversationViewRootAttributes;
    private Filter seamFilter;
    private static boolean started;

    protected boolean isSessionInvalid() {
        return this.session.isInvalid();
    }

    protected HttpSession getSession() {
        return this.session;
    }

    protected Object getInstance(Class clazz) {
        return Component.getInstance(clazz);
    }

    protected Object getInstance(String name) {
        return Component.getInstance(name);
    }

    protected boolean isLongRunningConversation() {
        return Manager.instance().isLongRunningConversation();
    }

    public Object lookup(String name) {
        return Contexts.lookupInStatefulContexts(name);
    }

    public void begin() {
        this.session = new MockHttpSession(this.servletContext);
        ServletLifecycle.beginSession(this.session);
    }

    public void end() {
        ServletLifecycle.endSession(this.session);
        this.session = null;
    }

    public void init() throws Exception {
        this.startJbossEmbeddedIfNecessary();
        this.application = new SeamApplication(new MockApplication());
        this.phases = new SeamPhaseListener();
        this.servletContext = new MockServletContext();
        this.initServletContext(this.servletContext.getInitParameters());
        ServletLifecycle.beginApplication(this.servletContext);
        new Initialization(this.servletContext).create().init();
        ((Init)this.servletContext.getAttribute(Seam.getComponentName(Init.class))).setDebug(false);
        this.conversationViewRootAttributes = new HashMap<String, Map>();
        this.seamFilter = this.createSeamFilter();
        for (ELResolver elResolver : this.getELResolvers()) {
            this.application.addELResolver(elResolver);
        }
    }

    public void cleanup() throws Exception {
        this.seamFilter.destroy();
        ServletLifecycle.endApplication();
        this.conversationViewRootAttributes = null;
    }

    protected Filter createSeamFilter() throws ServletException {
        SeamFilter seamFilter = new SeamFilter();
        seamFilter.init(new MockFilterConfig(this.servletContext));
        return seamFilter;
    }

    public void initServletContext(Map initParams) {
    }

    protected InitialContext getInitialContext() throws NamingException {
        return Naming.getInitialContext();
    }

    protected UserTransaction getUserTransaction() throws NamingException {
        return Transaction.instance();
    }

    protected Object getField(Object object, String fieldName) {
        Field field = Reflections.getField(object.getClass(), fieldName);
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        return Reflections.getAndWrap(field, object);
    }

    protected void setField(Object object, String fieldName, Object value) {
        Field field = Reflections.getField(object.getClass(), fieldName);
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        Reflections.setAndWrap(field, object, value);
    }

    protected void startJbossEmbeddedIfNecessary() throws Exception {
        if (!started && this.embeddedJBossAvailable()) {
            new EmbeddedBootstrap().startAndDeployResources();
        }
        started = true;
    }

    private boolean embeddedJBossAvailable() {
        try {
            Class.forName("org.jboss.embedded.Bootstrap");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    protected ELResolver[] getELResolvers() {
        return new ELResolver[0];
    }

    protected void installMockTransport() {
        Contexts.getApplicationContext().set(Seam.getComponentName(MailSession.class), new MailSession("mock").create());
    }

    public class FacesRequest
    extends Request {
        public FacesRequest() {
        }

        public FacesRequest(String viewId) {
            this.setViewId(viewId);
        }

        public FacesRequest(String viewId, String conversationId) {
            super(conversationId);
            this.setViewId(viewId);
        }

        protected final boolean isGetRequest() {
            return false;
        }
    }

    public class NonFacesRequest
    extends Request {
        public NonFacesRequest() {
        }

        public NonFacesRequest(String viewId) {
            this.setViewId(viewId);
        }

        public NonFacesRequest(String viewId, String conversationId) {
            super(conversationId);
            this.setViewId(viewId);
        }

        protected final boolean isGetRequest() {
            return true;
        }

        protected final void applyRequestValues() throws Exception {
            throw new UnsupportedOperationException();
        }

        protected final void processValidations() throws Exception {
            throw new UnsupportedOperationException();
        }

        protected final void updateModelValues() throws Exception {
            throw new UnsupportedOperationException();
        }

        protected final void invokeApplication() throws Exception {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class Request {
        private String conversationId;
        private String outcome;
        private String action;
        private boolean validationFailed;
        private String viewId;
        private boolean renderResponseBegun;
        private boolean renderResponseComplete;
        private boolean invokeApplicationBegun;
        private boolean invokeApplicationComplete;
        private HttpServletRequest request;
        private HttpServletResponse response;
        private MockFacesContext facesContext;
        private MockExternalContext externalContext;
        private Map<String, Object> pageParameters = new HashMap<String, Object>();

        protected void setPageParameter(String name, Object value) {
            this.pageParameters.put(name, value);
        }

        protected void setParameter(String name, String value) {
            this.getParameters().put(name, new String[]{value});
        }

        protected Map<String, String[]> getParameters() {
            return ((MockHttpServletRequest)this.externalContext.getRequest()).getParameters();
        }

        protected Map<String, String[]> getHeaders() {
            return ((MockHttpServletRequest)this.externalContext.getRequest()).getHeaders();
        }

        public String getPrincipalName() {
            return "gavin";
        }

        public Set<String> getPrincipalRoles() {
            return new AbstractSet<String>(){

                @Override
                public boolean contains(Object o) {
                    return true;
                }

                @Override
                public Iterator<String> iterator() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public int size() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public List<Cookie> getCookies() {
            return Collections.EMPTY_LIST;
        }

        protected Request() {
        }

        protected Request(String conversationId) {
            this.conversationId = conversationId;
        }

        protected boolean isGetRequest() {
            return false;
        }

        protected String getViewId() {
            return this.viewId;
        }

        protected void setViewId(String viewId) {
            this.viewId = viewId;
        }

        protected void applyRequestValues() throws Exception {
        }

        protected void processValidations() throws Exception {
        }

        protected void updateModelValues() throws Exception {
        }

        protected void invokeApplication() throws Exception {
        }

        protected void setOutcome(String outcome) {
            this.outcome = outcome;
        }

        protected String getOutcome() {
            return this.outcome;
        }

        protected String getInvokeApplicationOutcome() {
            return this.outcome;
        }

        protected void renderResponse() throws Exception {
        }

        protected void setup() {
        }

        protected void afterRequest() {
        }

        protected void beforeRequest() {
            this.setup();
        }

        protected String getRenderedViewId() {
            if (Init.instance().isJbpmInstalled() && Pageflow.instance().isInProcess()) {
                return Pageflow.instance().getPageViewId();
            }
            return this.getFacesContext().getViewRoot().getViewId();
        }

        protected void validate(Class modelClass, String property, Object value) {
            ClassValidator validator = Validators.instance().getValidator(modelClass);
            InvalidValue[] ivs = validator.getPotentialInvalidValues(property, value);
            if (ivs.length > 0) {
                this.validationFailed = true;
                FacesMessage message = FacesMessages.createFacesMessage(FacesMessage.SEVERITY_WARN, ivs[0].getMessage(), new Object[0]);
                FacesContext.getCurrentInstance().addMessage(property, message);
                FacesContext.getCurrentInstance().renderResponse();
            }
        }

        protected boolean isValidationFailure() {
            return this.validationFailed;
        }

        protected FacesContext getFacesContext() {
            return this.facesContext;
        }

        protected String getConversationId() {
            return this.conversationId;
        }

        protected Object getValue(String valueExpression) {
            return BaseSeamTest.this.application.evaluateExpressionGet((FacesContext)this.facesContext, valueExpression, Object.class);
        }

        protected void setValue(String valueExpression, Object value) {
            BaseSeamTest.this.application.getExpressionFactory().createValueExpression(this.facesContext.getELContext(), valueExpression, Object.class).setValue(this.facesContext.getELContext(), value);
        }

        protected boolean validateValue(String valueExpression, Object value) {
            ValueExpression ve = BaseSeamTest.this.application.getExpressionFactory().createValueExpression(this.facesContext.getELContext(), valueExpression, Object.class);
            InvalidValue[] ivs = Validators.instance().validate(ve, this.facesContext.getELContext(), value);
            if (ivs.length > 0) {
                this.validationFailed = true;
                this.facesContext.addMessage(null, FacesMessages.createFacesMessage(FacesMessage.SEVERITY_ERROR, ivs[0].getMessage(), new Object[0]));
                return false;
            }
            return true;
        }

        protected void onException(Exception e) {
            throw new AssertionError((Object)e);
        }

        protected Object invokeMethod(String methodExpression) {
            return BaseSeamTest.this.application.getExpressionFactory().createMethodExpression(this.facesContext.getELContext(), methodExpression, Object.class, new Class[0]).invoke(this.facesContext.getELContext(), null);
        }

        protected Object invokeAction(String actionMethodExpression) {
            this.action = actionMethodExpression;
            Object result = this.invokeMethod(actionMethodExpression);
            if (result != null) {
                this.setOutcome(result.toString());
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String run() throws Exception {
            try {
                this.init();
                this.beforeRequest();
                this.setStandardJspVariables();
                BaseSeamTest.this.seamFilter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, new FilterChain(){

                    public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
                        try {
                            if (Request.this.emulateJsfLifecycle()) {
                                Request.this.saveConversationViewRoot();
                            }
                        }
                        catch (Exception e) {
                            Request.this.onException(e);
                            throw new ServletException((Throwable)e);
                        }
                    }
                });
                BaseSeamTest.this.seamFilter.destroy();
                this.afterRequest();
                String string = this.conversationId;
                return string;
            }
            finally {
                if (Contexts.isEventContextActive()) {
                    FacesLifecycle.endRequest(this.externalContext);
                }
            }
        }

        private void saveConversationViewRoot() {
            Map renderedViewRootAttributes = this.facesContext.getViewRoot().getAttributes();
            if (renderedViewRootAttributes != null && this.conversationId != null) {
                HashMap conversationState = new HashMap();
                conversationState.putAll(renderedViewRootAttributes);
                BaseSeamTest.this.conversationViewRootAttributes.put(this.conversationId, conversationState);
            }
        }

        protected void init() {
            Cookie[] cookieArray = this.getCookies().toArray(new Cookie[0]);
            this.request = new MockHttpServletRequest(BaseSeamTest.this.session, this.getPrincipalName(), this.getPrincipalRoles(), cookieArray, this.isGetRequest() ? "GET" : "POST");
            this.response = new MockHttpServletResponse();
            this.externalContext = new MockExternalContext(BaseSeamTest.this.servletContext, this.request, this.response);
            this.facesContext = new MockFacesContext(this.externalContext, BaseSeamTest.this.application);
            this.facesContext.setCurrent();
        }

        private void setStandardJspVariables() {
            HashMap params = new HashMap();
            for (Map.Entry e : this.request.getParameterMap().entrySet()) {
                if (((String[])e.getValue()).length != 1) continue;
                params.put(e.getKey(), ((String[])e.getValue())[0]);
            }
            this.request.setAttribute("param", params);
        }

        private boolean emulateJsfLifecycle() throws Exception {
            this.restoreViewPhase();
            if (!this.isGetRequest() && !this.skipToRender()) {
                this.applyRequestValuesPhase();
                if (!this.skipToRender()) {
                    this.processValidationsPhase();
                    if (!this.skipToRender()) {
                        this.updateModelValuesPhase();
                        if (!this.skipToRender()) {
                            this.invokeApplicationPhase();
                        }
                    }
                }
            }
            if (this.skipRender()) {
                return false;
            }
            this.renderResponsePhase();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void renderResponsePhase() throws Exception {
            BaseSeamTest.this.phases.beforePhase(new PhaseEvent((FacesContext)this.facesContext, PhaseId.RENDER_RESPONSE, MockLifecycle.INSTANCE));
            try {
                this.updateConversationId();
                this.renderResponseBegun = true;
                this.renderResponse();
                this.renderResponseComplete = true;
                this.facesContext.getApplication().getStateManager().saveView((FacesContext)this.facesContext);
                this.updateConversationId();
            }
            finally {
                BaseSeamTest.this.phases.afterPhase(new PhaseEvent((FacesContext)this.facesContext, PhaseId.RENDER_RESPONSE, MockLifecycle.INSTANCE));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void invokeApplicationPhase() throws Exception {
            BaseSeamTest.this.phases.beforePhase(new PhaseEvent((FacesContext)this.facesContext, PhaseId.INVOKE_APPLICATION, MockLifecycle.INSTANCE));
            try {
                this.updateConversationId();
                this.invokeApplicationBegun = true;
                this.invokeApplication();
                this.invokeApplicationComplete = true;
                String outcome = this.getInvokeApplicationOutcome();
                this.facesContext.getApplication().getNavigationHandler().handleNavigation((FacesContext)this.facesContext, this.action, outcome);
                this.viewId = this.getRenderedViewId();
                this.updateConversationId();
            }
            finally {
                BaseSeamTest.this.phases.afterPhase(new PhaseEvent((FacesContext)this.facesContext, PhaseId.INVOKE_APPLICATION, MockLifecycle.INSTANCE));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateModelValuesPhase() throws Exception {
            BaseSeamTest.this.phases.beforePhase(new PhaseEvent((FacesContext)this.facesContext, PhaseId.UPDATE_MODEL_VALUES, MockLifecycle.INSTANCE));
            try {
                this.updateConversationId();
                this.updateModelValues();
                this.updateConversationId();
            }
            finally {
                BaseSeamTest.this.phases.afterPhase(new PhaseEvent((FacesContext)this.facesContext, PhaseId.UPDATE_MODEL_VALUES, MockLifecycle.INSTANCE));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processValidationsPhase() throws Exception {
            BaseSeamTest.this.phases.beforePhase(new PhaseEvent((FacesContext)this.facesContext, PhaseId.PROCESS_VALIDATIONS, MockLifecycle.INSTANCE));
            try {
                this.updateConversationId();
                this.processValidations();
                this.updateConversationId();
                if (this.isValidationFailure()) {
                    this.facesContext.renderResponse();
                }
            }
            finally {
                BaseSeamTest.this.phases.afterPhase(new PhaseEvent((FacesContext)this.facesContext, PhaseId.PROCESS_VALIDATIONS, MockLifecycle.INSTANCE));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void applyRequestValuesPhase() throws Exception {
            BaseSeamTest.this.phases.beforePhase(new PhaseEvent((FacesContext)this.facesContext, PhaseId.APPLY_REQUEST_VALUES, MockLifecycle.INSTANCE));
            try {
                this.updateConversationId();
                this.applyRequestValues();
                this.updateConversationId();
            }
            finally {
                BaseSeamTest.this.phases.afterPhase(new PhaseEvent((FacesContext)this.facesContext, PhaseId.APPLY_REQUEST_VALUES, MockLifecycle.INSTANCE));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void restoreViewPhase() {
            BaseSeamTest.this.phases.beforePhase(new PhaseEvent((FacesContext)this.facesContext, PhaseId.RESTORE_VIEW, MockLifecycle.INSTANCE));
            try {
                UIViewRoot viewRoot = this.facesContext.getApplication().getViewHandler().createView((FacesContext)this.facesContext, this.getViewId());
                this.facesContext.setViewRoot(viewRoot);
                Map restoredViewRootAttributes = this.facesContext.getViewRoot().getAttributes();
                if (this.conversationId != null) {
                    if (this.isGetRequest()) {
                        this.setParameter(Manager.instance().getConversationIdParameter(), this.conversationId);
                    } else if (BaseSeamTest.this.conversationViewRootAttributes.containsKey(this.conversationId)) {
                        Map state = (Map)BaseSeamTest.this.conversationViewRootAttributes.get(this.conversationId);
                        restoredViewRootAttributes.putAll(state);
                    }
                }
                if (this.isGetRequest()) {
                    this.facesContext.renderResponse();
                } else {
                    restoredViewRootAttributes.putAll(this.pageParameters);
                }
            }
            finally {
                BaseSeamTest.this.phases.afterPhase(new PhaseEvent((FacesContext)this.facesContext, PhaseId.RESTORE_VIEW, MockLifecycle.INSTANCE));
            }
        }

        private void updateConversationId() {
            Manager manager = Manager.instance();
            this.conversationId = manager.isLongRunningConversation() ? manager.getCurrentConversationId() : manager.getParentConversationId();
        }

        private boolean skipRender() {
            return FacesContext.getCurrentInstance().getResponseComplete();
        }

        private boolean skipToRender() {
            return FacesContext.getCurrentInstance().getRenderResponse() || FacesContext.getCurrentInstance().getResponseComplete();
        }

        protected boolean isInvokeApplicationBegun() {
            return this.invokeApplicationBegun;
        }

        protected boolean isInvokeApplicationComplete() {
            return this.invokeApplicationComplete;
        }

        protected boolean isRenderResponseBegun() {
            return this.renderResponseBegun;
        }

        protected boolean isRenderResponseComplete() {
            return this.renderResponseComplete;
        }

        protected MimeMessage getRenderedMailMessage(String viewId) {
            BaseSeamTest.this.installMockTransport();
            MockTransport.clearMailMessage();
            Renderer.instance().render(viewId);
            return MockTransport.getMailMessage();
        }
    }

    public abstract class ComponentTest {
        protected Object invokeMethod(String methodExpression) {
            return Expressions.instance().createMethodExpression(methodExpression).invoke(new Object[0]);
        }

        protected Object getValue(String valueExpression) {
            return Expressions.instance().createValueExpression(valueExpression).getValue();
        }

        protected void setValue(String valueExpression, Object value) {
            Expressions.instance().createValueExpression(valueExpression).setValue(value);
        }

        protected abstract void testComponents() throws Exception;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws Exception {
            TestLifecycle.beginTest(BaseSeamTest.this.servletContext, new ServletSessionMap(BaseSeamTest.this.session));
            try {
                this.testComponents();
            }
            finally {
                TestLifecycle.endTest();
            }
        }
    }

    public abstract class Script
    extends Request {
        public Script() {
        }

        public Script(String conversationId) {
            super(conversationId);
        }
    }
}

