/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.bpm;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;
import org.dom4j.Element;
import org.hibernate.HibernateException;
import org.hibernate.lob.ReaderInputStream;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.bpm.PageflowParser;
import org.jboss.seam.bpm.SeamExpressionEvaluator;
import org.jboss.seam.bpm.SeamUserCodeInterceptor;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.ResourceLoader;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.util.Naming;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.node.DbSubProcessResolver;
import org.jbpm.graph.node.ProcessState;
import org.jbpm.graph.node.SubProcessResolver;
import org.jbpm.instantiation.UserCodeInterceptor;
import org.jbpm.instantiation.UserCodeInterceptorConfig;
import org.jbpm.jpdl.el.ExpressionEvaluator;
import org.jbpm.jpdl.el.impl.JbpmExpressionEvaluator;
import org.jbpm.persistence.db.DbPersistenceServiceFactory;
import org.xml.sax.InputSource;

@Scope(value=ScopeType.APPLICATION)
@BypassInterceptors
@Startup
@Name(value="org.jboss.seam.bpm.jbpm")
@Install(value=false, precedence=0)
public class Jbpm {
    private static final LogProvider log = Logging.getLogProvider(Jbpm.class);
    private JbpmConfiguration jbpmConfiguration;
    private String jbpmConfigurationJndiName;
    private String[] processDefinitions;
    private String[] pageflowDefinitions;
    private Map<String, ProcessDefinition> pageflowProcessDefinitions = new HashMap<String, ProcessDefinition>();
    public static JbpmConfiguration pageflowConfiguration = JbpmConfiguration.parseResource((String)"org/jboss/seam/bpm/jbpm.pageflow.cfg.xml");
    private static final DbSubProcessResolver DB_SUB_PROCESS_RESOLVER = new DbSubProcessResolver();

    @Create
    public void startup() throws Exception {
        log.trace("Starting jBPM");
        ProcessState.setDefaultSubProcessResolver((SubProcessResolver)new SeamSubProcessResolver());
        this.installProcessDefinitions();
        this.installPageflowDefinitions();
        JbpmExpressionEvaluator.setExpressionEvaluator((ExpressionEvaluator)new SeamExpressionEvaluator());
        UserCodeInterceptorConfig.setUserCodeInterceptor((UserCodeInterceptor)new SeamUserCodeInterceptor());
    }

    @Destroy
    public void shutdown() {
        if (this.jbpmConfiguration != null) {
            this.jbpmConfiguration.close();
        }
    }

    public JbpmConfiguration getJbpmConfiguration() {
        if (this.jbpmConfiguration == null) {
            this.initJbpmConfiguration();
        }
        return this.jbpmConfiguration;
    }

    private void initJbpmConfiguration() {
        if (this.jbpmConfigurationJndiName == null) {
            this.jbpmConfiguration = JbpmConfiguration.getInstance();
        } else {
            try {
                this.jbpmConfiguration = (JbpmConfiguration)Naming.getInitialContext().lookup(this.jbpmConfigurationJndiName);
            }
            catch (NamingException ne) {
                throw new IllegalArgumentException("JbpmConfiguration not found in JNDI", ne);
            }
        }
        DbPersistenceServiceFactory dbpsf = (DbPersistenceServiceFactory)this.jbpmConfiguration.getServiceFactory("persistence");
        if (Naming.getInitialContextProperties() != null) {
            Hashtable hash = Naming.getInitialContextProperties();
            Properties prefixed = new Properties();
            for (Map.Entry entry : hash.entrySet()) {
                prefixed.setProperty("hibernate.jndi." + (String)entry.getKey(), (String)entry.getValue());
            }
            try {
                dbpsf.getConfiguration().getProperties().putAll((Map<?, ?>)prefixed);
            }
            catch (HibernateException he) {
                log.info("could not set JNDI properties for jBPM persistence: " + he.getMessage());
            }
        }
    }

    public ProcessDefinition getPageflowProcessDefinition(String pageflowName) {
        return this.pageflowProcessDefinitions.get(pageflowName);
    }

    public boolean isPageflowProcessDefinition(String pageflowName) {
        return this.pageflowProcessDefinitions.containsKey(pageflowName);
    }

    public ProcessDefinition getPageflowDefinitionFromResource(String resourceName) {
        InputStream resource = ResourceLoader.instance().getResourceAsStream(resourceName);
        if (resource == null) {
            throw new IllegalArgumentException("pageflow resource not found: " + resourceName);
        }
        return Jbpm.parseInputSource(new InputSource(resource));
    }

    public ProcessDefinition getProcessDefinitionFromResource(String resourceName) {
        InputStream resource = ResourceLoader.instance().getResourceAsStream(resourceName);
        if (resource == null) {
            throw new IllegalArgumentException("process definition resource not found: " + resourceName);
        }
        return ProcessDefinition.parseXmlInputStream((InputStream)resource);
    }

    public String[] getPageflowDefinitions() {
        return this.pageflowDefinitions;
    }

    public void setPageflowDefinitions(String[] pageflowDefinitions) {
        this.pageflowDefinitions = pageflowDefinitions;
    }

    public String[] getProcessDefinitions() {
        return this.processDefinitions;
    }

    public void setProcessDefinitions(String[] processDefinitions) {
        this.processDefinitions = processDefinitions;
    }

    public boolean deployPageflowDefinition(ProcessDefinition pageflowDefinition) {
        return this.pageflowProcessDefinitions.put(pageflowDefinition.getName(), pageflowDefinition) != null;
    }

    public ProcessDefinition getPageflowDefinitionFromXml(String pageflowDefinition) {
        return Jbpm.parseInputSource(new InputSource((InputStream)new ReaderInputStream((Reader)new StringReader(pageflowDefinition))));
    }

    public ProcessDefinition getProcessDefinitionFromXml(String processDefinition) {
        return ProcessDefinition.parseXmlInputStream((InputStream)new ReaderInputStream((Reader)new StringReader(processDefinition)));
    }

    public boolean undeployPageflowDefinition(String pageflowName) {
        return this.pageflowProcessDefinitions.remove(pageflowName) != null;
    }

    private void installPageflowDefinitions() {
        if (this.pageflowDefinitions != null) {
            for (String pageflow : this.pageflowDefinitions) {
                ProcessDefinition pd = this.getPageflowDefinitionFromResource(pageflow);
                this.pageflowProcessDefinitions.put(pd.getName(), pd);
            }
        }
    }

    private void installProcessDefinitions() {
        if (this.isProcessDeploymentEnabled()) {
            JbpmContext jbpmContext = this.getJbpmConfiguration().createJbpmContext();
            try {
                if (this.processDefinitions != null) {
                    for (String definitionResource : this.processDefinitions) {
                        this.deployProcess(jbpmContext, definitionResource);
                    }
                }
            }
            catch (RuntimeException e) {
                throw new RuntimeException("could not deploy a process definition", e);
            }
            finally {
                jbpmContext.close();
            }
        }
    }

    private void deployProcess(JbpmContext jbpmContext, String definitionResource) {
        ProcessDefinition processDefinition = ProcessDefinition.parseXmlResource((String)definitionResource);
        if (log.isDebugEnabled()) {
            log.debug("deploying process definition : " + processDefinition.getName());
        }
        jbpmContext.deployProcessDefinition(processDefinition);
    }

    protected boolean isProcessDeploymentEnabled() {
        return this.processDefinitions != null && this.processDefinitions.length > 0;
    }

    public static Jbpm instance() {
        if (!Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("No application context active");
        }
        if (!Init.instance().isJbpmInstalled()) {
            throw new IllegalStateException("jBPM support is not installed (use components.xml to install it)");
        }
        return (Jbpm)Component.getInstance(Jbpm.class, ScopeType.APPLICATION);
    }

    protected String getJbpmConfigurationJndiName() {
        return this.jbpmConfigurationJndiName;
    }

    protected void setJbpmConfigurationJndiName(String jbpmConfigurationJndiName) {
        this.jbpmConfigurationJndiName = jbpmConfigurationJndiName;
    }

    public static JbpmContext createPageflowContext() {
        return pageflowConfiguration.createJbpmContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessDefinition parseInputSource(InputSource inputSource) {
        JbpmContext jbpmContext = Jbpm.createPageflowContext();
        try {
            ProcessDefinition processDefinition = new PageflowParser(inputSource).readProcessDefinition();
            return processDefinition;
        }
        finally {
            jbpmContext.close();
        }
    }

    class SeamSubProcessResolver
    implements SubProcessResolver {
        SeamSubProcessResolver() {
        }

        public ProcessDefinition findSubProcess(Element element) {
            String subProcessName = element.attributeValue("name");
            ProcessDefinition pageflow = (ProcessDefinition)Jbpm.this.pageflowProcessDefinitions.get(subProcessName);
            return pageflow == null ? DB_SUB_PROCESS_RESOLVER.findSubProcess(element) : pageflow;
        }
    }
}

