/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.navigation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.jboss.seam.core.Events;
import org.jboss.seam.core.Interpolator;
import org.jboss.seam.core.ResourceLoader;
import org.jboss.seam.navigation.Action;
import org.jboss.seam.navigation.ConversationControl;
import org.jboss.seam.navigation.ConversationIdParameter;
import org.jboss.seam.navigation.Input;
import org.jboss.seam.navigation.Navigation;
import org.jboss.seam.navigation.Pages;
import org.jboss.seam.navigation.Param;
import org.jboss.seam.navigation.ProcessControl;
import org.jboss.seam.navigation.SyntheticConversationIdParameter;
import org.jboss.seam.navigation.TaskControl;
import org.jboss.seam.security.Identity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Page {
    private final String viewId;
    private String description;
    private Integer timeout;
    private String noConversationViewId;
    private String resourceBundleName;
    private boolean switchEnabled = true;
    private List<Param> parameters = new ArrayList<Param>();
    private List<Input> inputs = new ArrayList<Input>();
    private List<Action> actions = new ArrayList<Action>();
    private Map<String, Navigation> navigations = new HashMap<String, Navigation>();
    private Navigation defaultNavigation;
    private boolean conversationRequired;
    private boolean loginRequired;
    private ConversationControl conversationControl = new ConversationControl();
    private TaskControl taskControl = new TaskControl();
    private ProcessControl processControl = new ProcessControl();
    private ConversationIdParameter conversationIdParameter;
    private String eventType;
    private String scheme;
    private boolean restricted;
    private String restriction;

    public Page(String viewId) {
        int loc;
        this.viewId = viewId;
        if (viewId != null && (loc = viewId.lastIndexOf(46)) > 0 && viewId.startsWith("/")) {
            this.setResourceBundleName(viewId.substring(1, loc));
        }
        this.conversationIdParameter = new SyntheticConversationIdParameter();
    }

    public ResourceBundle getResourceBundle() {
        String resourceBundleName = this.getResourceBundleName();
        if (resourceBundleName == null) {
            return null;
        }
        return ResourceLoader.instance().loadBundle(resourceBundleName);
    }

    public String toString() {
        return "Page(" + this.getViewId() + ")";
    }

    public String getViewId() {
        return this.viewId;
    }

    public String renderDescription() {
        return Interpolator.instance().interpolate(this.getDescription(), new Object[0]);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setNoConversationViewId(String noConversationViewId) {
        this.noConversationViewId = noConversationViewId;
    }

    public String getNoConversationViewId() {
        return this.noConversationViewId;
    }

    public void setResourceBundleName(String resourceBundleName) {
        this.resourceBundleName = resourceBundleName;
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public void setSwitchEnabled(boolean switchEnabled) {
        this.switchEnabled = switchEnabled;
    }

    public boolean isSwitchEnabled() {
        return this.switchEnabled;
    }

    public List<Param> getParameters() {
        return this.parameters;
    }

    public Map<String, Navigation> getNavigations() {
        return this.navigations;
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public boolean isConversationRequired() {
        return this.conversationRequired;
    }

    public void setConversationRequired(boolean conversationRequired) {
        this.conversationRequired = conversationRequired;
    }

    public Navigation getDefaultNavigation() {
        return this.defaultNavigation;
    }

    public void setDefaultNavigation(Navigation defaultActionOutcomeMapping) {
        this.defaultNavigation = defaultActionOutcomeMapping;
    }

    public ConversationControl getConversationControl() {
        return this.conversationControl;
    }

    public TaskControl getTaskControl() {
        return this.taskControl;
    }

    public ProcessControl getProcessControl() {
        return this.processControl;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    private void checkPermission(FacesContext facesContext, String name) {
        if (this.isRestricted() && Identity.isSecurityEnabled()) {
            if (this.restriction == null) {
                Identity.instance().checkPermission(Pages.getViewId(facesContext), name, new Object[0]);
            } else {
                Identity.instance().checkRestriction(this.restriction);
            }
        }
    }

    public void postRestore(FacesContext facesContext) {
        this.checkPermission(facesContext, "restore");
    }

    public boolean preRender(FacesContext facesContext) {
        this.checkPermission(facesContext, "render");
        boolean result = false;
        this.getConversationControl().beginOrEndConversation();
        this.getTaskControl().beginOrEndTask();
        this.getProcessControl().createOrResumeProcess();
        for (Input in : this.getInputs()) {
            in.in();
        }
        if (this.eventType != null) {
            Events.instance().raiseEvent(this.eventType, new Object[0]);
        }
        for (Action action : this.getActions()) {
            UIViewRoot oldViewRoot;
            String outcome;
            if (!action.isExecutable()) continue;
            String fromAction = outcome = action.getOutcome();
            if (outcome == null) {
                fromAction = action.getMethodExpression().getExpressionString();
                result = true;
                outcome = Pages.toString(action.getMethodExpression().invoke(new Object[0]));
                oldViewRoot = facesContext.getViewRoot();
                Pages.handleOutcome(facesContext, outcome, fromAction);
                if (!facesContext.getResponseComplete() && oldViewRoot == facesContext.getViewRoot()) continue;
                break;
            }
            oldViewRoot = facesContext.getViewRoot();
            Pages.handleOutcome(facesContext, outcome, fromAction);
            if (!facesContext.getResponseComplete() && oldViewRoot == facesContext.getViewRoot()) continue;
            break;
        }
        return result;
    }

    public List<Input> getInputs() {
        return this.inputs;
    }

    public boolean isRestricted() {
        return this.restricted;
    }

    public void setRestricted(boolean restricted) {
        this.restricted = restricted;
    }

    public String getRestriction() {
        return this.restriction;
    }

    public void setRestriction(String restriction) {
        this.restriction = restriction;
    }

    public boolean isLoginRequired() {
        return this.loginRequired;
    }

    public void setLoginRequired(boolean loginRequired) {
        this.loginRequired = loginRequired;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public ConversationIdParameter getConversationIdParameter() {
        return this.conversationIdParameter;
    }

    public void setConversationIdParameter(ConversationIdParameter param) {
        this.conversationIdParameter = param;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }
}

