/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.contexts;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.core.Events;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicContext
implements Context {
    private final Map<String, Object> map;
    private final ScopeType scope;

    public BasicContext(ScopeType scope) {
        this.scope = scope;
        this.map = new HashMap<String, Object>();
    }

    protected BasicContext(ScopeType scope, Map<String, Object> map) {
        this.scope = scope;
        this.map = map;
    }

    @Override
    public ScopeType getType() {
        return this.scope;
    }

    @Override
    public Object get(Class clazz) {
        return this.get(Component.getComponentName(clazz));
    }

    @Override
    public Object get(String name) {
        return this.map.get(name);
    }

    @Override
    public String[] getNames() {
        Set<String> keySet = this.map.keySet();
        String[] array = new String[keySet.size()];
        int i = 0;
        for (String key : keySet) {
            array[i++] = key;
        }
        return array;
    }

    @Override
    public boolean isSet(String name) {
        return this.map.containsKey(name);
    }

    @Override
    public void remove(String name) {
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.preRemoveVariable." + name, new Object[0]);
        }
        this.map.remove(name);
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.postRemoveVariable." + name, new Object[0]);
        }
    }

    @Override
    public void set(String name, Object value) {
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.preSetVariable." + name, new Object[0]);
        }
        this.map.put(name, value);
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.postSetVariable." + name, new Object[0]);
        }
    }

    @Override
    public void flush() {
    }

    public String toString() {
        return "BasicContext(" + (Object)((Object)this.scope) + ")";
    }
}

