/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.excel.ui;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.faces.context.FacesContext;
import org.jboss.seam.excel.Command;
import org.jboss.seam.excel.ExcelWorkbook;
import org.jboss.seam.excel.ExcelWorkbookException;
import org.jboss.seam.excel.WorksheetItem;
import org.jboss.seam.excel.ui.ExcelComponent;
import org.jboss.seam.excel.ui.UICell;
import org.jboss.seam.excel.ui.UIWorksheet;

public class UIColumn
extends ExcelComponent {
    public static final String COMPONENT_TYPE = "org.jboss.seam.excel.ui.UIColumn";
    private Boolean autoSize;
    private Boolean hidden;
    private Integer width;

    public UIColumn() {
    }

    public UIColumn(Integer width) {
        this.width = width;
    }

    public Boolean getAutoSize() {
        return (Boolean)this.valueOf("autoSize", this.autoSize);
    }

    public void setAutoSize(Boolean autoSize) {
        this.autoSize = autoSize;
    }

    public Boolean getHidden() {
        return (Boolean)this.valueOf("hidden", this.hidden);
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public Integer getWidth() {
        return (Integer)this.valueOf("width", this.width);
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public String getFamily() {
        return COMPONENT_TYPE;
    }

    public void encodeBegin(FacesContext arg0) throws IOException {
        ExcelWorkbook excelWorkbook = this.getWorkbook(this.getParent());
        if (excelWorkbook == null) {
            throw new ExcelWorkbookException("Could not find excel workbook");
        }
        excelWorkbook.applyColumnSettings(this);
        UIWorksheet sheet = (UIWorksheet)this.getParentByClass(this.getParent(), UIWorksheet.class);
        if (sheet == null) {
            throw new ExcelWorkbookException("Could not find worksheet");
        }
        UICell headerCell = (UICell)this.getFacet("header");
        if (headerCell != null) {
            excelWorkbook.addItem(headerCell);
        }
        List<Command> commands = UIColumn.getCommands(this.getChildren());
        for (Command command : commands) {
            excelWorkbook.executeCommand(command);
        }
        for (WorksheetItem item : UIColumn.getItems(this.getChildren())) {
            if (item == null) continue;
            Object oldValue = FacesContext.getCurrentInstance().getExternalContext().getRequestMap().get(sheet.getVar());
            Iterator iterator = sheet.getDataIterator();
            while (iterator.hasNext()) {
                FacesContext.getCurrentInstance().getExternalContext().getRequestMap().put(sheet.getVar(), iterator.next());
                excelWorkbook.addItem(item);
            }
            if (oldValue == null) {
                FacesContext.getCurrentInstance().getExternalContext().getRequestMap().remove(sheet.getVar());
                continue;
            }
            FacesContext.getCurrentInstance().getExternalContext().getRequestMap().put(sheet.getVar(), oldValue);
        }
        excelWorkbook.nextColumn();
    }
}

