/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.excel.exporter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import org.apache.commons.beanutils.PropertyUtils;
import org.jboss.seam.core.Interpolator;
import org.jboss.seam.excel.ExcelWorkbookException;
import org.jboss.seam.excel.Template;
import org.jboss.seam.excel.ui.UIBackground;
import org.jboss.seam.excel.ui.UIBorder;
import org.jboss.seam.excel.ui.UICellTemplate;
import org.jboss.seam.excel.ui.UIColumn;
import org.jboss.seam.excel.ui.UIFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleParser {
    private static final String EXCEL_STYLE_PREFIX = "xls";
    private static final String STYLE_TEMPLATE_SEPARATOR = "\\.";
    protected static final String STYLE_ATTRIBUTE = "style";
    private static final String STYLE_SEPARATOR = ";";
    private static final String STYLE_VALUE_SEPARATOR = ":";
    private static final String COLUMN_WIDTH_SEPARATOR = ",";
    protected static final String LOCAL_TEMPLATE_STYLE = "xlsTemplates";
    protected static final String TEMPLATE_GLOBAL = "global";
    private static final String FONT_NAME = "xlsFontName";
    private static final String FONT_SIZE = "xlsFontSize";
    private static final String FONT_COLOR = "xlsFontColor";
    private static final String FONT_BOLD = "xlsFontBold";
    private static final String FONT_ITALIC = "xlsFontItalic";
    private static final String FONT_SCRIPT_STYLE = "xlsFontScriptStyle";
    private static final String FONT_STRUCKOUT = "xlsFontStruckOut";
    private static final String FONT_UNDERLINE_STYLE = "xlsFontUnderlineStyle";
    private static final String BACKGROUND_COLOR = "xlsBackgroundColor";
    private static final String BACKGROUND_PATTERN = "xlsBackgroundPattern";
    private static final String BORDER_COLOR = "xlsBorderColor";
    private static final String BORDER_COLOR_LEFT = "xlsBorderColorLeft";
    private static final String BORDER_COLOR_TOP = "xlsBorderColorTop";
    private static final String BORDER_COLOR_RIGHT = "xlsBorderColorRight";
    private static final String BORDER_COLOR_BOTTOM = "xlsBorderColorBottom";
    private static final String BORDER_LINE_STYLE = "xlsBorderLineStyle";
    private static final String BORDER_LINE_STYLE_LEFT = "xlsBorderLineStyleLeft";
    private static final String BORDER_LINE_STYLE_TOP = "xlsBorderLineStyleTop";
    private static final String BORDER_LINE_STYLE_RIGHT = "xlsBorderLineStyleRight";
    private static final String BORDER_LINE_STYLE_BOTTOM = "xlsBorderLineStyleBottom";
    private static final String BORDER_COLOR_PREFIX = "xlsBorderColor";
    private static final String BORDER_LINE_STYLE_PREFIX = "xlsBorderLineStyle";
    private static final String BORDER_LEFT_POSTFIX = "Left";
    private static final String BORDER_TOP_POSTFIX = "Top";
    private static final String BORDER_RIGHT_POSTFIX = "Right";
    private static final String BORDER_BOTTOM_POSTFIX = "Bottom";
    private static final String BORDER_ALL_POSTFIX = null;
    private static final String ALIGNMENT = "xlsAlignment";
    private static final String COLUMN_WIDTH = "xlsColumnWidths";

    public static String getComponentStyle(UIComponent uiComponent) {
        try {
            return (String)PropertyUtils.getSimpleProperty((Object)uiComponent, (String)STYLE_ATTRIBUTE);
        }
        catch (Exception e) {
            throw new ExcelWorkbookException(Interpolator.instance().interpolate("Could not read style attribute #0 from component #1", new Object[]{STYLE_ATTRIBUTE, uiComponent.getId()}));
        }
    }

    public static Map<String, Map<String, String>> getTemplateMap(String styleString) {
        String[] styleStringParts;
        HashMap<String, Map<String, String>> templateMap = new HashMap<String, Map<String, String>>();
        if (styleString == null) {
            return templateMap;
        }
        for (String styleStringPart : styleStringParts = styleString.split(STYLE_SEPARATOR)) {
            String[] styleParts = styleStringPart.split(STYLE_VALUE_SEPARATOR);
            if (styleParts.length != 2) {
                throw new ExcelWorkbookException(Interpolator.instance().interpolate("Unbalanced style parsing #0", new Object[]{styleStringPart}));
            }
            String styleName = styleParts[0].trim();
            if (!styleName.startsWith(EXCEL_STYLE_PREFIX)) continue;
            String[] templateParts = styleName.split(STYLE_TEMPLATE_SEPARATOR);
            if (templateParts.length == 1) {
                StyleParser.addStyleToTemplate(templateMap, TEMPLATE_GLOBAL, templateParts[0], styleParts[1]);
                continue;
            }
            if (templateParts.length == 2) {
                StyleParser.addStyleToTemplate(templateMap, templateParts[1], templateParts[0], styleParts[1]);
                continue;
            }
            throw new ExcelWorkbookException(Interpolator.instance().interpolate("Unbalanced style parsing #0", new Object[]{styleName}));
        }
        return templateMap;
    }

    private static void addStyleToTemplate(Map<String, Map<String, String>> templateMap, String template, String key, String value) {
        Map<String, String> innerMap = templateMap.get(template.trim());
        if (innerMap == null) {
            innerMap = new HashMap<String, String>();
        }
        innerMap.put(key.trim(), value.trim());
        templateMap.put(template.trim(), innerMap);
    }

    public static UIColumn getColumnSettings(String styleString) {
        UIColumn uiColumn = new UIColumn();
        Map<String, String> globalTemplate = StyleParser.getTemplateMap(styleString).get(TEMPLATE_GLOBAL);
        if (globalTemplate == null) {
            return uiColumn;
        }
        if (globalTemplate.get(COLUMN_WIDTH) != null) {
            uiColumn.setWidth(Integer.parseInt(globalTemplate.get(COLUMN_WIDTH)));
        }
        return uiColumn;
    }

    public static List<Template> getTemplates(Map<String, Map<String, String>> templateMap) {
        ArrayList<Template> templates = new ArrayList<Template>();
        if (templateMap == null) {
            return templates;
        }
        for (Map.Entry<String, Map<String, String>> template : templateMap.entrySet()) {
            String templateName = template.getKey();
            Map<String, String> templateData = template.getValue();
            UICellTemplate cellTemplate = new UICellTemplate();
            cellTemplate.setName(templateName);
            cellTemplate.setAlignment(templateData.get(ALIGNMENT));
            if (StyleParser.hasFontStyle(templateData)) {
                cellTemplate.getChildren().add(StyleParser.getFontStyle(templateData));
            }
            if (StyleParser.hasBackgroundStyle(templateData)) {
                cellTemplate.getChildren().add(StyleParser.getBackgroundStyle(templateData));
            }
            if (StyleParser.hasBorders(templateData)) {
                List<UIComponent> borders = StyleParser.getBorders(templateData);
                for (UIComponent border : borders) {
                    cellTemplate.getChildren().add(border);
                }
            }
            templates.add(cellTemplate);
        }
        return templates;
    }

    private static UIComponent getBackgroundStyle(Map<String, String> templateData) {
        UIBackground background = new UIBackground();
        background.setColor(templateData.get(BACKGROUND_COLOR));
        background.setPattern(templateData.get(BACKGROUND_PATTERN));
        return background;
    }

    private static boolean hasBorders(Map<String, String> templateData) {
        return templateData.containsKey("xlsBorderLineStyle") || templateData.containsKey(BORDER_LINE_STYLE_BOTTOM) || templateData.containsKey(BORDER_LINE_STYLE_LEFT) || templateData.containsKey(BORDER_LINE_STYLE_RIGHT) || templateData.containsKey(BORDER_LINE_STYLE_TOP) || templateData.containsKey("xlsBorderColor") || templateData.containsKey(BORDER_COLOR_BOTTOM) || templateData.containsKey(BORDER_COLOR_LEFT) || templateData.containsKey(BORDER_COLOR_RIGHT) || templateData.containsKey(BORDER_COLOR_TOP);
    }

    private static boolean hasBackgroundStyle(Map<String, String> templateData) {
        return templateData.containsKey(BACKGROUND_COLOR) || templateData.containsKey(BACKGROUND_PATTERN);
    }

    private static void parseBorders(Map<String, String> borderMap, String borderType, List<UIComponent> borders) {
        if (borderMap.isEmpty()) {
            return;
        }
        UIBorder border = new UIBorder();
        if (BORDER_ALL_POSTFIX == borderType) {
            border.setBorder("all");
        } else {
            border.setBorder(borderType.toLowerCase());
        }
        if (borderType == null) {
            borderType = "";
        }
        if (borderMap.containsKey("xlsBorderColor" + borderType)) {
            border.setColor(borderMap.get("xlsBorderColor" + borderType));
        }
        if (borderMap.containsKey("xlsBorderLineStyle" + borderType)) {
            border.setLineStyle(borderMap.get("xlsBorderLineStyle" + borderType));
        } else {
            border.setLineStyle("thin");
        }
        borders.add((UIComponent)border);
    }

    private static List<UIComponent> getBorders(Map<String, String> templateData) {
        ArrayList<UIComponent> borders = new ArrayList<UIComponent>();
        HashMap<String, String> all = new HashMap<String, String>();
        HashMap<String, String> top = new HashMap<String, String>();
        HashMap<String, String> left = new HashMap<String, String>();
        HashMap<String, String> right = new HashMap<String, String>();
        HashMap<String, String> bottom = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : templateData.entrySet()) {
            if (!entry.getKey().startsWith("xlsBorderColor") && !entry.getKey().startsWith("xlsBorderLineStyle")) continue;
            if (entry.getKey().endsWith(BORDER_TOP_POSTFIX)) {
                top.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (entry.getKey().endsWith(BORDER_LEFT_POSTFIX)) {
                left.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (entry.getKey().endsWith(BORDER_RIGHT_POSTFIX)) {
                right.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (entry.getKey().endsWith(BORDER_BOTTOM_POSTFIX)) {
                right.put(entry.getKey(), entry.getValue());
                continue;
            }
            all.put(entry.getKey(), entry.getValue());
        }
        StyleParser.parseBorders(all, BORDER_ALL_POSTFIX, borders);
        StyleParser.parseBorders(left, BORDER_LEFT_POSTFIX, borders);
        StyleParser.parseBorders(right, BORDER_RIGHT_POSTFIX, borders);
        StyleParser.parseBorders(bottom, BORDER_BOTTOM_POSTFIX, borders);
        StyleParser.parseBorders(top, BORDER_TOP_POSTFIX, borders);
        return borders;
    }

    private static UIComponent getFontStyle(Map<String, String> templateData) {
        UIFont font = new UIFont();
        font.setName(templateData.get(FONT_NAME));
        if (templateData.containsKey(FONT_SIZE)) {
            font.setPointSize(Integer.parseInt(templateData.get(FONT_SIZE)));
        }
        font.setColor(templateData.get(FONT_COLOR));
        if (templateData.containsKey(FONT_BOLD)) {
            font.setBold(Boolean.parseBoolean(templateData.get(FONT_BOLD)));
        }
        if (templateData.containsKey(FONT_ITALIC)) {
            font.setItalic(Boolean.parseBoolean(templateData.get(FONT_ITALIC)));
        }
        font.setScriptStyle(templateData.get(FONT_SCRIPT_STYLE));
        if (templateData.containsKey(FONT_STRUCKOUT)) {
            font.setStruckOut(Boolean.parseBoolean(templateData.get(FONT_STRUCKOUT)));
        }
        font.setUnderlineStyle(templateData.get(FONT_UNDERLINE_STYLE));
        return font;
    }

    private static boolean hasFontStyle(Map<String, String> templateData) {
        return templateData.containsKey(FONT_NAME) || templateData.containsKey(FONT_SIZE) || templateData.containsKey(FONT_COLOR) || templateData.containsKey(FONT_BOLD) || templateData.containsKey(FONT_ITALIC) || templateData.containsKey(FONT_SCRIPT_STYLE) || templateData.containsKey(FONT_STRUCKOUT) || templateData.containsKey(FONT_UNDERLINE_STYLE);
    }

    protected static List<Integer> parseColumnWidths(Map<String, String> globalTemplate) {
        String[] columnWidthParts;
        ArrayList<Integer> columnWidths = new ArrayList<Integer>();
        if (globalTemplate == null) {
            return columnWidths;
        }
        if (!globalTemplate.containsKey(COLUMN_WIDTH)) {
            return columnWidths;
        }
        String columnWidthString = globalTemplate.get(COLUMN_WIDTH);
        for (String columnWidthPart : columnWidthParts = columnWidthString.split(COLUMN_WIDTH_SEPARATOR)) {
            try {
                columnWidths.add(Integer.parseInt(columnWidthPart));
            }
            catch (NumberFormatException e) {
                columnWidths.add(null);
            }
        }
        return columnWidths;
    }
}

