/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.excel.exporter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.Interpolator;
import org.jboss.seam.core.Manager;
import org.jboss.seam.document.DocumentData;
import org.jboss.seam.document.DocumentStore;
import org.jboss.seam.excel.ExcelFactory;
import org.jboss.seam.excel.ExcelWorkbook;
import org.jboss.seam.excel.ExcelWorkbookException;
import org.jboss.seam.excel.Template;
import org.jboss.seam.excel.exporter.StyleParser;
import org.jboss.seam.excel.ui.ExcelComponent;
import org.jboss.seam.excel.ui.UICell;
import org.jboss.seam.excel.ui.UIWorkbook;
import org.jboss.seam.excel.ui.UIWorksheet;
import org.jboss.seam.navigation.Pages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.jboss.seam.excel.exporter.excelExporter")
@Scope(value=ScopeType.EVENT)
@BypassInterceptors
public class ExcelExporter {
    private ExcelWorkbook excelWorkbook = null;
    private List<Integer> columnWidths = new ArrayList<Integer>();

    public void export(String dataTableId) {
        this.excelWorkbook = ExcelFactory.instance().getExcelWorkbook("");
        UIData dataTable = (UIData)FacesContext.getCurrentInstance().getViewRoot().findComponent(dataTableId);
        if (dataTable == null) {
            throw new ExcelWorkbookException(Interpolator.instance().interpolate("Could not find data table with id #0", new Object[]{dataTableId}));
        }
        this.excelWorkbook.createWorkbook(new UIWorkbook());
        this.excelWorkbook.createOrSelectWorksheet(new UIWorksheet());
        String styleString = StyleParser.getComponentStyle((UIComponent)dataTable);
        Map<String, Map<String, String>> templateMap = StyleParser.getTemplateMap(styleString);
        List<Template> templates = StyleParser.getTemplates(templateMap);
        for (Template template : templates) {
            this.excelWorkbook.addTemplate(template);
        }
        this.columnWidths = StyleParser.parseColumnWidths(templateMap.get("global"));
        String dataTableVar = dataTable.getVar();
        Object oldValue = FacesContext.getCurrentInstance().getExternalContext().getRequestMap().get(dataTableVar);
        List<UIColumn> columns = ExcelComponent.getChildrenOfType(dataTable.getChildren(), UIColumn.class);
        int col = 0;
        for (UIColumn column : columns) {
            Iterator iterator = UIWorksheet.unwrapIterator(dataTable.getValue());
            this.processColumn(column, iterator, dataTableVar, col++);
            this.excelWorkbook.nextColumn();
        }
        if (oldValue == null) {
            FacesContext.getCurrentInstance().getExternalContext().getRequestMap().remove(dataTableVar);
        } else {
            FacesContext.getCurrentInstance().getExternalContext().getRequestMap().put(dataTableVar, oldValue);
        }
        this.redirectExport();
    }

    private void redirectExport() {
        String viewId = Pages.getViewId((FacesContext)FacesContext.getCurrentInstance());
        String baseName = UIWorkbook.baseNameForViewId(viewId);
        DocumentData documentData = new DocumentData(baseName, this.excelWorkbook.getDocumentType(), this.excelWorkbook.getBytes());
        String id = DocumentStore.instance().newId();
        String url = DocumentStore.instance().preferredUrlForContent(baseName, this.excelWorkbook.getDocumentType().getExtension(), id);
        url = Manager.instance().encodeConversationId(url, viewId);
        DocumentStore.instance().saveData(id, documentData);
        try {
            FacesContext.getCurrentInstance().getExternalContext().redirect(url);
        }
        catch (IOException e) {
            throw new ExcelWorkbookException(Interpolator.instance().interpolate("Could not redirect to #0", new Object[]{url}), e);
        }
    }

    private void processColumn(UIColumn column, Iterator iterator, String var, int col) {
        Integer columnWidth;
        UIComponent headerFacet = column.getFacet("header");
        if (headerFacet != null && UIOutput.class.isAssignableFrom(headerFacet.getClass())) {
            ArrayList<UIOutput> headerOutputs = new ArrayList<UIOutput>();
            headerOutputs.add((UIOutput)headerFacet);
            this.processOutputs(headerOutputs, "global,header");
        }
        while (iterator.hasNext()) {
            FacesContext.getCurrentInstance().getExternalContext().getRequestMap().put(var, iterator.next());
            List<UIOutput> dataOutputs = ExcelComponent.getChildrenOfType(column.getChildren(), UIOutput.class);
            this.processOutputs(dataOutputs, "global,data");
        }
        if (this.columnWidths.size() > col && (columnWidth = this.columnWidths.get(col)) != null) {
            org.jboss.seam.excel.ui.UIColumn uiColumn = new org.jboss.seam.excel.ui.UIColumn(columnWidth);
            this.excelWorkbook.applyColumnSettings(uiColumn);
        }
    }

    private void processOutputs(List<UIOutput> outputs, String preTemplates) {
        for (UIOutput output : outputs) {
            if (!output.isRendered()) continue;
            UICell cell = new UICell();
            cell.setId(output.getId());
            cell.setValue(output.getValue());
            String cellTemplates = preTemplates;
            String localTemplates = null;
            String outputStyle = StyleParser.getComponentStyle((UIComponent)output);
            Map<String, String> globalTemplate = StyleParser.getTemplateMap(outputStyle).get("global");
            if (globalTemplate != null) {
                localTemplates = globalTemplate.get("xlsTemplates");
            }
            if (localTemplates != null) {
                cellTemplates = cellTemplates + "," + localTemplates;
            }
            cell.setTemplates(cellTemplates);
            this.excelWorkbook.addItem(cell);
        }
    }
}

