/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.excel.csv;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jboss.seam.document.DocumentData;
import org.jboss.seam.excel.Command;
import org.jboss.seam.excel.ExcelWorkbook;
import org.jboss.seam.excel.ExcelWorkbookException;
import org.jboss.seam.excel.Template;
import org.jboss.seam.excel.WorksheetItem;
import org.jboss.seam.excel.ui.UICell;
import org.jboss.seam.excel.ui.UIColumn;
import org.jboss.seam.excel.ui.UIImage;
import org.jboss.seam.excel.ui.UIWorkbook;
import org.jboss.seam.excel.ui.UIWorksheet;

public class CsvExcelWorkbook
implements ExcelWorkbook {
    int column = 0;
    int row = 0;
    int sheet = -1;
    int maxrow = 0;
    int maxcolumn = 0;
    int maxsheet = 0;
    private Map<Integer, Map<Integer, List<String>>> table = null;
    private List<String> sheets = new ArrayList<String>();

    public void createWorkbook(UIWorkbook uiWorkbook) throws ExcelWorkbookException {
        this.table = new TreeMap<Integer, Map<Integer, List<String>>>();
    }

    public void createOrSelectWorksheet(UIWorksheet uiWorksheet) {
        this.createOrSelectWorksheet(uiWorksheet.getName(), uiWorksheet.getStartRow(), uiWorksheet.getStartColumn());
    }

    public void createOrSelectWorksheet(String worksheetName, Integer startRow, Integer startColumn) {
        this.column = 0;
        this.row = 0;
        if (this.sheets.contains(this.sheets)) {
            this.sheet = this.sheets.indexOf(this.sheets);
            this.column = startColumn;
            this.row = startRow;
        } else {
            ++this.sheet;
            this.sheets.add(worksheetName);
        }
    }

    public byte[] getBytes() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i <= this.maxsheet; ++i) {
            Map<Integer, List<String>> sheet = this.table.get(i);
            if (sheet == null) continue;
            buffer.append(this.sheets.get(i)).append("\n");
            for (int j = 0; j < this.maxrow; ++j) {
                for (List<String> col : sheet.values()) {
                    if (col.get(j) == null) continue;
                    buffer.append("\"").append(String.valueOf(col.get(j))).append("\"").append(",");
                }
                buffer.append("\n");
            }
        }
        return buffer.toString().getBytes();
    }

    public void addCell(int sheet, int column, int row, UICell uiCell) throws ExcelWorkbookException {
        Map<Integer, List<String>> columns;
        if (this.table.get(sheet) == null) {
            this.table.put(sheet, new TreeMap());
        }
        if ((columns = this.table.get(sheet)).get(column) == null) {
            columns.put(column, new ArrayList());
        }
        List<String> rows = columns.get(column);
        rows.add(String.valueOf(uiCell.getValue()));
        this.maxrow = row > this.maxrow ? row : this.maxrow;
        this.maxcolumn = column > this.maxcolumn ? column : this.maxcolumn;
        this.maxsheet = sheet > this.maxsheet ? sheet : this.maxsheet;
    }

    public void nextColumn() {
        ++this.column;
        this.row = 0;
    }

    public DocumentData.DocumentType getDocumentType() {
        return new DocumentData.DocumentType("csv", "text/csv");
    }

    public void addImage(UIImage uiImage) {
    }

    public void addItem(WorksheetItem item) {
        UICell cell = (UICell)item;
        this.addCell(this.sheet, this.column, this.row++, cell);
    }

    public void addTemplate(Template template) {
    }

    public void applyWorksheetSettings(UIWorksheet uiWorksheet) {
    }

    public void applyColumnSettings(UIColumn uiColumn) {
    }

    public void executeCommand(Command command) {
    }
}

