/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.StringBridge;
import org.hibernate.util.StringHelper;

public class String2FieldBridgeAdaptor
implements FieldBridge {
    private final StringBridge stringBridge;

    public String2FieldBridgeAdaptor(StringBridge stringBridge) {
        this.stringBridge = stringBridge;
    }

    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        String indexedString = this.stringBridge.objectToString(value);
        if (StringHelper.isNotEmpty(indexedString)) {
            Field field = new Field(name, indexedString, luceneOptions.getStore(), luceneOptions.getIndex(), luceneOptions.getTermVector());
            field.setBoost(luceneOptions.getBoost().floatValue());
            document.add((Fieldable)field);
        }
    }
}

