/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.jms;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.QueueConnection;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import org.hibernate.HibernateException;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.impl.jms.JMSBackendQueueProcessorFactory;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSBackendQueueProcessor
implements Runnable {
    private static final Logger log = LoggerFactory.make();
    private List<LuceneWork> queue;
    private JMSBackendQueueProcessorFactory factory;

    public JMSBackendQueueProcessor(List<LuceneWork> queue, JMSBackendQueueProcessorFactory jmsBackendQueueProcessorFactory) {
        this.queue = queue;
        this.factory = jmsBackendQueueProcessorFactory;
    }

    @Override
    public void run() {
        ArrayList<LuceneWork> filteredQueue = new ArrayList<LuceneWork>(this.queue);
        for (LuceneWork work : this.queue) {
            if (!(work instanceof OptimizeLuceneWork)) continue;
            filteredQueue.remove(work);
        }
        if (filteredQueue.size() == 0) {
            return;
        }
        this.factory.prepareJMSTools();
        QueueConnection cnn = null;
        try {
            cnn = this.factory.getJMSFactory().createQueueConnection();
            QueueSession session = cnn.createQueueSession(false, 1);
            ObjectMessage message = session.createObjectMessage();
            message.setObject((Serializable)filteredQueue);
            QueueSender sender = session.createSender(this.factory.getJmsQueue());
            sender.send((Message)message);
            session.close();
        }
        catch (JMSException e) {
            throw new HibernateException("Unable to send Search work to JMS queue: " + this.factory.getJmsQueueName(), e);
        }
        finally {
            try {
                if (cnn != null) {
                    cnn.close();
                }
            }
            catch (JMSException e) {
                log.warn("Unable to close JMS connection for " + this.factory.getJmsQueueName(), (Throwable)e);
            }
        }
    }
}

