/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.BytecodeProvider;
import org.hibernate.bytecode.cglib.BytecodeProviderImpl;
import org.hibernate.util.ConfigHelper;
import org.hibernate.util.PropertiesHelper;

public final class Environment {
    public static final String VERSION = "3.2.4.sp1.cp08";
    public static final String CONNECTION_PROVIDER = "hibernate.connection.provider_class";
    public static final String DRIVER = "hibernate.connection.driver_class";
    public static final String ISOLATION = "hibernate.connection.isolation";
    public static final String URL = "hibernate.connection.url";
    public static final String USER = "hibernate.connection.username";
    public static final String PASS = "hibernate.connection.password";
    public static final String AUTOCOMMIT = "hibernate.connection.autocommit";
    public static final String POOL_SIZE = "hibernate.connection.pool_size";
    public static final String DATASOURCE = "hibernate.connection.datasource";
    public static final String CONNECTION_PREFIX = "hibernate.connection";
    public static final String JNDI_CLASS = "hibernate.jndi.class";
    public static final String JNDI_URL = "hibernate.jndi.url";
    public static final String JNDI_PREFIX = "hibernate.jndi";
    public static final String SESSION_FACTORY_NAME = "hibernate.session_factory_name";
    public static final String DIALECT = "hibernate.dialect";
    public static final String DEFAULT_SCHEMA = "hibernate.default_schema";
    public static final String DEFAULT_CATALOG = "hibernate.default_catalog";
    public static final String SHOW_SQL = "hibernate.show_sql";
    public static final String FORMAT_SQL = "hibernate.format_sql";
    public static final String USE_SQL_COMMENTS = "hibernate.use_sql_comments";
    public static final String MAX_FETCH_DEPTH = "hibernate.max_fetch_depth";
    public static final String DEFAULT_BATCH_FETCH_SIZE = "hibernate.default_batch_fetch_size";
    public static final String USE_STREAMS_FOR_BINARY = "hibernate.jdbc.use_streams_for_binary";
    public static final String USE_SCROLLABLE_RESULTSET = "hibernate.jdbc.use_scrollable_resultset";
    public static final String USE_GET_GENERATED_KEYS = "hibernate.jdbc.use_get_generated_keys";
    public static final String STATEMENT_FETCH_SIZE = "hibernate.jdbc.fetch_size";
    public static final String STATEMENT_BATCH_SIZE = "hibernate.jdbc.batch_size";
    public static final String BATCH_STRATEGY = "hibernate.jdbc.factory_class";
    public static final String BATCH_VERSIONED_DATA = "hibernate.jdbc.batch_versioned_data";
    public static final String OUTPUT_STYLESHEET = "hibernate.xml.output_stylesheet";
    public static final String C3P0_MAX_SIZE = "hibernate.c3p0.max_size";
    public static final String C3P0_MIN_SIZE = "hibernate.c3p0.min_size";
    public static final String C3P0_TIMEOUT = "hibernate.c3p0.timeout";
    public static final String C3P0_MAX_STATEMENTS = "hibernate.c3p0.max_statements";
    public static final String C3P0_ACQUIRE_INCREMENT = "hibernate.c3p0.acquire_increment";
    public static final String C3P0_IDLE_TEST_PERIOD = "hibernate.c3p0.idle_test_period";
    public static final String PROXOOL_PREFIX = "hibernate.proxool";
    public static final String PROXOOL_XML = "hibernate.proxool.xml";
    public static final String PROXOOL_PROPERTIES = "hibernate.proxool.properties";
    public static final String PROXOOL_EXISTING_POOL = "hibernate.proxool.existing_pool";
    public static final String PROXOOL_POOL_ALIAS = "hibernate.proxool.pool_alias";
    public static final String AUTO_CLOSE_SESSION = "hibernate.transaction.auto_close_session";
    public static final String FLUSH_BEFORE_COMPLETION = "hibernate.transaction.flush_before_completion";
    public static final String RELEASE_CONNECTIONS = "hibernate.connection.release_mode";
    public static final String CURRENT_SESSION_CONTEXT_CLASS = "hibernate.current_session_context_class";
    public static final String TRANSACTION_STRATEGY = "hibernate.transaction.factory_class";
    public static final String TRANSACTION_MANAGER_STRATEGY = "hibernate.transaction.manager_lookup_class";
    public static final String USER_TRANSACTION = "jta.UserTransaction";
    public static final String CACHE_PROVIDER = "hibernate.cache.provider_class";
    public static final String CACHE_PROVIDER_CONFIG = "hibernate.cache.provider_configuration_file_resource_path";
    public static final String CACHE_NAMESPACE = "hibernate.cache.jndi";
    public static final String USE_QUERY_CACHE = "hibernate.cache.use_query_cache";
    public static final String QUERY_CACHE_FACTORY = "hibernate.cache.query_cache_factory";
    public static final String USE_SECOND_LEVEL_CACHE = "hibernate.cache.use_second_level_cache";
    public static final String USE_MINIMAL_PUTS = "hibernate.cache.use_minimal_puts";
    public static final String CACHE_REGION_PREFIX = "hibernate.cache.region_prefix";
    public static final String USE_STRUCTURED_CACHE = "hibernate.cache.use_structured_entries";
    public static final String GENERATE_STATISTICS = "hibernate.generate_statistics";
    public static final String USE_IDENTIFIER_ROLLBACK = "hibernate.use_identifier_rollback";
    public static final String USE_REFLECTION_OPTIMIZER = "hibernate.bytecode.use_reflection_optimizer";
    public static final String QUERY_TRANSLATOR = "hibernate.query.factory_class";
    public static final String QUERY_SUBSTITUTIONS = "hibernate.query.substitutions";
    public static final String QUERY_STARTUP_CHECKING = "hibernate.query.startup_check";
    public static final String HBM2DDL_AUTO = "hibernate.hbm2ddl.auto";
    public static final String SQL_EXCEPTION_CONVERTER = "hibernate.jdbc.sql_exception_converter";
    public static final String WRAP_RESULT_SETS = "hibernate.jdbc.wrap_result_sets";
    public static final String ORDER_UPDATES = "hibernate.order_updates";
    public static final String ORDER_INSERTS = "hibernate.order_inserts";
    public static final String DEFAULT_ENTITY_MODE = "hibernate.default_entity_mode";
    public static final String JACC_CONTEXTID = "hibernate.jacc_context_id";
    public static final String BYTECODE_PROVIDER = "hibernate.bytecode.provider";
    public static final String JPAQL_STRICT_COMPLIANCE = "hibernate.query.jpaql_strict_compliance";
    private static final BytecodeProvider BYTECODE_PROVIDER_INSTANCE;
    private static final boolean ENABLE_BINARY_STREAMS;
    private static final boolean ENABLE_REFLECTION_OPTIMIZER;
    private static final boolean JVM_SUPPORTS_LINKED_HASH_COLLECTIONS;
    private static final boolean JVM_HAS_TIMESTAMP_BUG;
    private static final boolean JVM_HAS_JDK14_TIMESTAMP;
    private static final boolean JVM_SUPPORTS_GET_GENERATED_KEYS;
    private static final Properties GLOBAL_PROPERTIES;
    private static final HashMap ISOLATION_LEVELS;
    private static final Map OBSOLETE_PROPERTIES;
    private static final Map RENAMED_PROPERTIES;
    private static final Log log;

    public static void verifyProperties(Properties props) {
        Iterator<Object> iter = props.keySet().iterator();
        HashMap propertiesToAdd = new HashMap();
        while (iter.hasNext()) {
            Object propertyName = iter.next();
            Object newPropertyName = OBSOLETE_PROPERTIES.get(propertyName);
            if (newPropertyName != null) {
                log.warn((Object)("Usage of obsolete property: " + propertyName + " no longer supported, use: " + newPropertyName));
            }
            if ((newPropertyName = RENAMED_PROPERTIES.get(propertyName)) == null) continue;
            log.warn((Object)("Property [" + propertyName + "] has been renamed to [" + newPropertyName + "]; update your properties appropriately"));
            if (props.containsKey(newPropertyName)) continue;
            propertiesToAdd.put(newPropertyName, props.get(propertyName));
        }
        props.putAll((Map<?, ?>)propertiesToAdd);
    }

    public static BytecodeProvider getBytecodeProvider() {
        return BYTECODE_PROVIDER_INSTANCE;
    }

    public static boolean jvmHasTimestampBug() {
        return JVM_HAS_TIMESTAMP_BUG;
    }

    public static boolean jvmHasJDK14Timestamp() {
        return JVM_HAS_JDK14_TIMESTAMP;
    }

    public static boolean jvmSupportsLinkedHashCollections() {
        return JVM_SUPPORTS_LINKED_HASH_COLLECTIONS;
    }

    public static boolean jvmSupportsGetGeneratedKeys() {
        return JVM_SUPPORTS_GET_GENERATED_KEYS;
    }

    public static boolean useStreamsForBinary() {
        return ENABLE_BINARY_STREAMS;
    }

    public static boolean useReflectionOptimizer() {
        return ENABLE_REFLECTION_OPTIMIZER;
    }

    private Environment() {
        throw new UnsupportedOperationException();
    }

    public static Properties getProperties() {
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)GLOBAL_PROPERTIES);
        return copy;
    }

    public static String isolationLevelToString(int isolation) {
        return (String)ISOLATION_LEVELS.get(new Integer(isolation));
    }

    public static BytecodeProvider buildBytecodeProvider(Properties properties) {
        String provider = PropertiesHelper.getString(BYTECODE_PROVIDER, properties, "cglib");
        log.info((Object)("Bytecode provider name : " + provider));
        return Environment.buildBytecodeProvider(provider);
    }

    private static BytecodeProvider buildBytecodeProvider(String providerName) {
        if ("javassist".equals(providerName)) {
            return new org.hibernate.bytecode.javassist.BytecodeProviderImpl();
        }
        if ("cglib".equals(providerName)) {
            return new BytecodeProviderImpl();
        }
        log.warn((Object)("unrecognized bytecode provider [" + providerName + "], using cglib by default"));
        return new BytecodeProviderImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        boolean linkedHashSupport;
        boolean getGeneratedKeysSupport;
        ISOLATION_LEVELS = new HashMap();
        OBSOLETE_PROPERTIES = new HashMap();
        RENAMED_PROPERTIES = new HashMap();
        log = LogFactory.getLog(Environment.class);
        log.info((Object)"Hibernate 3.2.4.sp1.cp08");
        RENAMED_PROPERTIES.put("hibernate.cglib.use_reflection_optimizer", USE_REFLECTION_OPTIMIZER);
        ISOLATION_LEVELS.put(new Integer(0), "NONE");
        ISOLATION_LEVELS.put(new Integer(1), "READ_UNCOMMITTED");
        ISOLATION_LEVELS.put(new Integer(2), "READ_COMMITTED");
        ISOLATION_LEVELS.put(new Integer(4), "REPEATABLE_READ");
        ISOLATION_LEVELS.put(new Integer(8), "SERIALIZABLE");
        GLOBAL_PROPERTIES = new Properties();
        GLOBAL_PROPERTIES.setProperty(USE_REFLECTION_OPTIMIZER, Boolean.FALSE.toString());
        try {
            InputStream stream = ConfigHelper.getResourceAsStream("/hibernate.properties");
            try {
                GLOBAL_PROPERTIES.load(stream);
                log.info((Object)("loaded properties from resource hibernate.properties: " + PropertiesHelper.maskOut(GLOBAL_PROPERTIES, PASS)));
            }
            catch (Exception e) {
                log.error((Object)"problem loading properties from hibernate.properties");
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException ioe) {
                    log.error((Object)"could not close stream on hibernate.properties", (Throwable)ioe);
                }
            }
        }
        catch (HibernateException he) {
            log.info((Object)"hibernate.properties not found");
        }
        try {
            GLOBAL_PROPERTIES.putAll((Map<?, ?>)System.getProperties());
        }
        catch (SecurityException se) {
            log.warn((Object)"could not copy system properties, system properties will be ignored");
        }
        Environment.verifyProperties(GLOBAL_PROPERTIES);
        ENABLE_BINARY_STREAMS = PropertiesHelper.getBoolean(USE_STREAMS_FOR_BINARY, GLOBAL_PROPERTIES);
        ENABLE_REFLECTION_OPTIMIZER = PropertiesHelper.getBoolean(USE_REFLECTION_OPTIMIZER, GLOBAL_PROPERTIES);
        if (ENABLE_BINARY_STREAMS) {
            log.info((Object)"using java.io streams to persist binary types");
        }
        if (ENABLE_REFLECTION_OPTIMIZER) {
            log.info((Object)"using bytecode reflection optimizer");
        }
        BYTECODE_PROVIDER_INSTANCE = Environment.buildBytecodeProvider(GLOBAL_PROPERTIES);
        try {
            Statement.class.getMethod("getGeneratedKeys", null);
            getGeneratedKeysSupport = true;
        }
        catch (NoSuchMethodException nsme) {
            getGeneratedKeysSupport = false;
        }
        JVM_SUPPORTS_GET_GENERATED_KEYS = getGeneratedKeysSupport;
        if (!JVM_SUPPORTS_GET_GENERATED_KEYS) {
            log.info((Object)"JVM does not support Statement.getGeneratedKeys()");
        }
        try {
            Class.forName("java.util.LinkedHashSet");
            linkedHashSupport = true;
        }
        catch (ClassNotFoundException cnfe) {
            linkedHashSupport = false;
        }
        JVM_SUPPORTS_LINKED_HASH_COLLECTIONS = linkedHashSupport;
        if (!JVM_SUPPORTS_LINKED_HASH_COLLECTIONS) {
            log.info((Object)"JVM does not support LinkedHasMap, LinkedHashSet - ordered maps and sets disabled");
        }
        boolean bl = JVM_HAS_TIMESTAMP_BUG = new Timestamp(123456789L).getTime() != 123456789L;
        if (JVM_HAS_TIMESTAMP_BUG) {
            log.info((Object)"using workaround for JVM bug in java.sql.Timestamp");
        }
        Timestamp t = new Timestamp(0L);
        t.setNanos(5000000);
        boolean bl2 = JVM_HAS_JDK14_TIMESTAMP = t.getTime() == 5L;
        if (JVM_HAS_JDK14_TIMESTAMP) {
            log.info((Object)"using JDK 1.4 java.sql.Timestamp handling");
        } else {
            log.info((Object)"using pre JDK 1.4 java.sql.Timestamp handling");
        }
    }
}

