/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.hibernate.MappingException;
import org.hibernate.util.StringHelper;

public class TypeNames {
    private HashMap weighted = new HashMap();
    private HashMap defaults = new HashMap();

    public String get(int typecode) throws MappingException {
        String result = (String)this.defaults.get(new Integer(typecode));
        if (result == null) {
            throw new MappingException("No Dialect mapping for JDBC type: " + typecode);
        }
        return result;
    }

    public String get(int typecode, int size, int precision, int scale) throws MappingException {
        Map map = (Map)this.weighted.get(new Integer(typecode));
        if (map != null && map.size() > 0) {
            for (Map.Entry entry : map.entrySet()) {
                if (size > (Integer)entry.getKey()) continue;
                return TypeNames.replace((String)entry.getValue(), size, precision, scale);
            }
        }
        return TypeNames.replace(this.get(typecode), size, precision, scale);
    }

    private static String replace(String type, int size, int precision, int scale) {
        type = StringHelper.replaceOnce(type, "$s", Integer.toString(scale));
        type = StringHelper.replaceOnce(type, "$l", Integer.toString(size));
        return StringHelper.replaceOnce(type, "$p", Integer.toString(precision));
    }

    public void put(int typecode, int capacity, String value) {
        TreeMap<Integer, String> map = (TreeMap<Integer, String>)this.weighted.get(new Integer(typecode));
        if (map == null) {
            map = new TreeMap<Integer, String>();
            this.weighted.put(new Integer(typecode), map);
        }
        map.put(new Integer(capacity), value);
    }

    public void put(int typecode, String value) {
        this.defaults.put(new Integer(typecode), value);
    }
}

