/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine;

import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.hibernate.Hibernate;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.annotations.common.util.ReflectHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.search.SearchException;
import org.hibernate.search.annotations.Boost;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.ClassBridges;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.WorkType;
import org.hibernate.search.bridge.BridgeFactory;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.IndexShardingStrategy;
import org.hibernate.search.util.BinderHelper;
import org.hibernate.search.util.ScopedAnalyzer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentBuilder<T> {
    private static final Log log = LogFactory.getLog(DocumentBuilder.class);
    private final PropertiesMetadata rootPropertiesMetadata;
    private final XClass beanClass;
    private final DirectoryProvider[] directoryProviders;
    private final IndexShardingStrategy shardingStrategy;
    private String idKeywordName;
    private XMember idGetter;
    private Float idBoost;
    public static final String CLASS_FIELDNAME = "_hibernate_class";
    private TwoWayFieldBridge idBridge;
    private Set<Class> mappedSubclasses = new HashSet<Class>();
    private ReflectionManager reflectionManager;
    private int level = 0;
    private int maxLevel = Integer.MAX_VALUE;
    private ScopedAnalyzer analyzer = new ScopedAnalyzer();

    public DocumentBuilder(XClass clazz, Analyzer defaultAnalyzer, DirectoryProvider[] directoryProviders, IndexShardingStrategy shardingStrategy, ReflectionManager reflectionManager) {
        this.beanClass = clazz;
        this.directoryProviders = directoryProviders;
        this.shardingStrategy = shardingStrategy;
        this.reflectionManager = reflectionManager;
        if (clazz == null) {
            throw new AssertionFailure("Unable to build a DocumemntBuilder with a null class");
        }
        this.rootPropertiesMetadata = new PropertiesMetadata();
        this.rootPropertiesMetadata.boost = this.getBoost(clazz);
        this.rootPropertiesMetadata.analyzer = defaultAnalyzer;
        HashSet<XClass> processedClasses = new HashSet<XClass>();
        processedClasses.add(clazz);
        this.initializeMembers(clazz, this.rootPropertiesMetadata, true, "", processedClasses);
        this.analyzer.setGlobalAnalyzer(this.rootPropertiesMetadata.analyzer);
        if (this.idKeywordName == null) {
            throw new SearchException("No document id in: " + clazz.getName());
        }
    }

    private Analyzer getAnalyzer(XAnnotatedElement annotatedElement) {
        org.hibernate.search.annotations.Analyzer analyzerAnn = annotatedElement.getAnnotation(org.hibernate.search.annotations.Analyzer.class);
        return this.getAnalyzer(analyzerAnn);
    }

    private Analyzer getAnalyzer(org.hibernate.search.annotations.Analyzer analyzerAnn) {
        Class analyzerClass;
        Class clazz = analyzerClass = analyzerAnn == null ? Void.TYPE : analyzerAnn.impl();
        if (analyzerClass == Void.TYPE) {
            return null;
        }
        try {
            return (Analyzer)analyzerClass.newInstance();
        }
        catch (ClassCastException e) {
            throw new SearchException("Lucene analyzer does not implement " + Analyzer.class.getName() + ": " + analyzerClass.getName(), e);
        }
        catch (Exception e) {
            throw new SearchException("Failed to instantiate lucene analyzer with type " + analyzerClass.getName(), e);
        }
    }

    private void initializeMembers(XClass clazz, PropertiesMetadata propertiesMetadata, boolean isRoot, String prefix, Set<XClass> processedClasses) {
        ArrayList<XClass> hierarchy = new ArrayList<XClass>();
        for (XClass currClass = clazz; currClass != null; currClass = currClass.getSuperclass()) {
            hierarchy.add(currClass);
        }
        for (int index = hierarchy.size() - 1; index >= 0; --index) {
            ClassBridge classBridgeAnn;
            ClassBridges classBridgesAnn;
            XClass currClass = (XClass)hierarchy.get(index);
            Analyzer analyzer = this.getAnalyzer(currClass);
            if (analyzer != null) {
                propertiesMetadata.analyzer = analyzer;
            }
            if ((classBridgesAnn = currClass.getAnnotation(ClassBridges.class)) != null) {
                ClassBridge[] cbs;
                for (ClassBridge cb : cbs = classBridgesAnn.value()) {
                    this.bindClassAnnotation(prefix, propertiesMetadata, cb);
                }
            }
            if ((classBridgeAnn = currClass.getAnnotation(ClassBridge.class)) != null) {
                this.bindClassAnnotation(prefix, propertiesMetadata, classBridgeAnn);
            }
            List<XProperty> methods = currClass.getDeclaredProperties("property");
            for (XProperty method : methods) {
                this.initializeMember(method, propertiesMetadata, isRoot, prefix, processedClasses);
            }
            List<XProperty> fields = currClass.getDeclaredProperties("field");
            for (XProperty field : fields) {
                this.initializeMember(field, propertiesMetadata, isRoot, prefix, processedClasses);
            }
        }
    }

    public String getIdentifierName() {
        return this.idGetter.getName();
    }

    private void initializeMember(XProperty member, PropertiesMetadata propertiesMetadata, boolean isRoot, String prefix, Set<XClass> processedClasses) {
        ContainedIn containedAnn;
        IndexedEmbedded embeddedAnn;
        Fields fieldsAnn;
        org.hibernate.search.annotations.Field fieldAnn;
        DocumentId documentIdAnn = member.getAnnotation(DocumentId.class);
        if (documentIdAnn != null) {
            if (isRoot) {
                if (this.idKeywordName != null) {
                    throw new AssertionFailure("Two document id assigned: " + this.idKeywordName + " and " + BinderHelper.getAttributeName(member, documentIdAnn.name()));
                }
                this.idKeywordName = prefix + BinderHelper.getAttributeName(member, documentIdAnn.name());
                FieldBridge fieldBridge = BridgeFactory.guessType(null, member, this.reflectionManager);
                if (!(fieldBridge instanceof TwoWayFieldBridge)) {
                    throw new SearchException("Bridge for document id does not implement TwoWayFieldBridge: " + member.getName());
                }
                this.idBridge = (TwoWayFieldBridge)fieldBridge;
                this.idBoost = this.getBoost(member);
                DocumentBuilder.setAccessible(member);
                this.idGetter = member;
            } else {
                DocumentBuilder.setAccessible(member);
                propertiesMetadata.fieldGetters.add(member);
                String fieldName = prefix + BinderHelper.getAttributeName(member, documentIdAnn.name());
                propertiesMetadata.fieldNames.add(fieldName);
                propertiesMetadata.fieldStore.add(this.getStore(Store.YES));
                propertiesMetadata.fieldIndex.add(this.getIndex(Index.UN_TOKENIZED));
                propertiesMetadata.fieldBridges.add(BridgeFactory.guessType(null, member, this.reflectionManager));
                Analyzer analyzer = null;
                if (analyzer == null) {
                    analyzer = this.getAnalyzer(member);
                }
                if (analyzer == null) {
                    analyzer = propertiesMetadata.analyzer;
                }
                if (analyzer == null) {
                    throw new AssertionFailure("Analizer should not be undefined");
                }
                this.analyzer.addScopedAnalyzer(fieldName, analyzer);
            }
        }
        if ((fieldAnn = member.getAnnotation(org.hibernate.search.annotations.Field.class)) != null) {
            this.bindFieldAnnotation(member, propertiesMetadata, prefix, fieldAnn);
        }
        if ((fieldsAnn = member.getAnnotation(Fields.class)) != null) {
            for (org.hibernate.search.annotations.Field fieldAnn2 : fieldsAnn.value()) {
                this.bindFieldAnnotation(member, propertiesMetadata, prefix, fieldAnn2);
            }
        }
        if ((embeddedAnn = member.getAnnotation(IndexedEmbedded.class)) != null) {
            int oldMaxLevel = this.maxLevel;
            int potentialLevel = embeddedAnn.depth() + this.level;
            if (potentialLevel < 0) {
                potentialLevel = Integer.MAX_VALUE;
            }
            this.maxLevel = potentialLevel > this.maxLevel ? this.maxLevel : potentialLevel;
            ++this.level;
            XClass elementClass = Void.TYPE == embeddedAnn.targetElement() ? member.getElementClass() : this.reflectionManager.toXClass(embeddedAnn.targetElement());
            if (this.maxLevel == Integer.MAX_VALUE && processedClasses.contains(elementClass)) {
                throw new SearchException("Circular reference. Duplicate use of " + elementClass.getName() + " in root entity " + this.beanClass.getName() + "#" + this.buildEmbeddedPrefix(prefix, embeddedAnn, member));
            }
            if (this.level <= this.maxLevel) {
                processedClasses.add(elementClass);
                DocumentBuilder.setAccessible(member);
                propertiesMetadata.embeddedGetters.add(member);
                PropertiesMetadata metadata = new PropertiesMetadata();
                propertiesMetadata.embeddedPropertiesMetadata.add(metadata);
                metadata.boost = this.getBoost(member);
                Analyzer analyzer = this.getAnalyzer(member);
                metadata.analyzer = analyzer != null ? analyzer : propertiesMetadata.analyzer;
                String localPrefix = this.buildEmbeddedPrefix(prefix, embeddedAnn, member);
                this.initializeMembers(elementClass, metadata, false, localPrefix, processedClasses);
                if (member.isArray()) {
                    propertiesMetadata.embeddedContainers.add(PropertiesMetadata.Container.ARRAY);
                } else if (member.isCollection()) {
                    if (Map.class.equals(member.getCollectionClass())) {
                        propertiesMetadata.embeddedContainers.add(PropertiesMetadata.Container.MAP);
                    } else {
                        propertiesMetadata.embeddedContainers.add(PropertiesMetadata.Container.COLLECTION);
                    }
                } else {
                    propertiesMetadata.embeddedContainers.add(PropertiesMetadata.Container.OBJECT);
                }
                processedClasses.remove(elementClass);
            } else if (log.isTraceEnabled()) {
                String localPrefix = this.buildEmbeddedPrefix(prefix, embeddedAnn, member);
                log.trace((Object)("depth reached, ignoring " + localPrefix));
            }
            --this.level;
            this.maxLevel = oldMaxLevel;
        }
        if ((containedAnn = member.getAnnotation(ContainedIn.class)) != null) {
            DocumentBuilder.setAccessible(member);
            propertiesMetadata.containedInGetters.add(member);
        }
    }

    private void bindClassAnnotation(String prefix, PropertiesMetadata propertiesMetadata, ClassBridge ann) {
        String fieldName = prefix + ann.name();
        propertiesMetadata.classNames.add(fieldName);
        propertiesMetadata.classStores.add(this.getStore(ann.store()));
        propertiesMetadata.classIndexes.add(this.getIndex(ann.index()));
        propertiesMetadata.classBridges.add(BridgeFactory.extractType(ann));
        propertiesMetadata.classBoosts.add(Float.valueOf(ann.boost().value()));
        Analyzer analyzer = this.getAnalyzer(ann.analyzer());
        if (analyzer == null) {
            analyzer = propertiesMetadata.analyzer;
        }
        if (analyzer == null) {
            throw new AssertionFailure("Analyzer should not be undefined");
        }
        this.analyzer.addScopedAnalyzer(fieldName, analyzer);
    }

    private void bindFieldAnnotation(XProperty member, PropertiesMetadata propertiesMetadata, String prefix, org.hibernate.search.annotations.Field fieldAnn) {
        DocumentBuilder.setAccessible(member);
        propertiesMetadata.fieldGetters.add(member);
        String fieldName = prefix + BinderHelper.getAttributeName(member, fieldAnn.name());
        propertiesMetadata.fieldNames.add(fieldName);
        propertiesMetadata.fieldStore.add(this.getStore(fieldAnn.store()));
        propertiesMetadata.fieldIndex.add(this.getIndex(fieldAnn.index()));
        propertiesMetadata.fieldBridges.add(BridgeFactory.guessType(fieldAnn, member, this.reflectionManager));
        Analyzer analyzer = this.getAnalyzer(fieldAnn.analyzer());
        if (analyzer == null) {
            analyzer = this.getAnalyzer(member);
        }
        if (analyzer == null) {
            analyzer = propertiesMetadata.analyzer;
        }
        if (analyzer == null) {
            throw new AssertionFailure("Analizer should not be undefined");
        }
        this.analyzer.addScopedAnalyzer(fieldName, analyzer);
    }

    private String buildEmbeddedPrefix(String prefix, IndexedEmbedded embeddedAnn, XProperty member) {
        String localPrefix = prefix;
        localPrefix = ".".equals(embeddedAnn.prefix()) ? localPrefix + member.getName() + '.' : localPrefix + embeddedAnn.prefix();
        return localPrefix;
    }

    private Field.Store getStore(Store store) {
        switch (store) {
            case NO: {
                return Field.Store.NO;
            }
            case YES: {
                return Field.Store.YES;
            }
            case COMPRESS: {
                return Field.Store.COMPRESS;
            }
        }
        throw new AssertionFailure("Unexpected Store: " + (Object)((Object)store));
    }

    private Field.Index getIndex(Index index) {
        switch (index) {
            case NO: {
                return Field.Index.NO;
            }
            case NO_NORMS: {
                return Field.Index.NO_NORMS;
            }
            case TOKENIZED: {
                return Field.Index.TOKENIZED;
            }
            case UN_TOKENIZED: {
                return Field.Index.UN_TOKENIZED;
            }
        }
        throw new AssertionFailure("Unexpected Index: " + (Object)((Object)index));
    }

    private Float getBoost(XAnnotatedElement element) {
        if (element == null) {
            return null;
        }
        Boost boost = element.getAnnotation(Boost.class);
        return boost != null ? Float.valueOf(boost.value()) : null;
    }

    private Object getMemberValue(Object bean, XMember getter) {
        Object value;
        try {
            value = getter.invoke(bean, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not get property value", e);
        }
        return value;
    }

    public void addWorkToQueue(Class entityClass, T entity, Serializable id, WorkType workType, List<LuceneWork> queue, SearchFactoryImplementor searchFactoryImplementor) {
        Document doc;
        ArrayList<LuceneWork> toDelete = new ArrayList<LuceneWork>();
        boolean duplicateDelete = false;
        for (LuceneWork luceneWork : queue) {
            Serializable currentId;
            if (luceneWork.getEntityClass() != entityClass || (currentId = luceneWork.getId()) == null || !currentId.equals(id)) continue;
            if (workType == WorkType.DELETE) {
                if (luceneWork instanceof AddLuceneWork) {
                    toDelete.add(luceneWork);
                    continue;
                }
                if (!(luceneWork instanceof DeleteLuceneWork)) continue;
                duplicateDelete = true;
                continue;
            }
            return;
        }
        for (LuceneWork luceneWork : toDelete) {
            queue.remove(luceneWork);
        }
        if (duplicateDelete) {
            return;
        }
        boolean searchForContainers = false;
        String idInString = this.idBridge.objectToString(id);
        if (workType == WorkType.ADD) {
            doc = this.getDocument(entity, id);
            queue.add(new AddLuceneWork(id, idInString, entityClass, doc));
            searchForContainers = true;
        } else if (workType == WorkType.DELETE || workType == WorkType.PURGE) {
            queue.add(new DeleteLuceneWork(id, idInString, entityClass));
        } else if (workType == WorkType.PURGE_ALL) {
            queue.add(new PurgeAllLuceneWork(entityClass));
        } else if (workType == WorkType.UPDATE || workType == WorkType.COLLECTION) {
            doc = this.getDocument(entity, id);
            queue.add(new DeleteLuceneWork(id, idInString, entityClass));
            queue.add(new AddLuceneWork(id, idInString, entityClass, doc));
            searchForContainers = true;
        } else if (workType == WorkType.INDEX) {
            doc = this.getDocument(entity, id);
            queue.add(new DeleteLuceneWork(id, idInString, entityClass));
            AddLuceneWork work = new AddLuceneWork(id, idInString, entityClass, doc);
            work.setBatch(true);
            queue.add(work);
            searchForContainers = true;
        } else {
            throw new AssertionFailure("Unknown WorkType: " + (Object)((Object)workType));
        }
        if (searchForContainers) {
            this.processContainedIn(entity, queue, this.rootPropertiesMetadata, searchFactoryImplementor);
        }
    }

    private void processContainedIn(Object instance, List<LuceneWork> queue, PropertiesMetadata metadata, SearchFactoryImplementor searchFactoryImplementor) {
        for (int i = 0; i < metadata.containedInGetters.size(); ++i) {
            XMember member = metadata.containedInGetters.get(i);
            Object value = this.getMemberValue(instance, member);
            if (value == null) continue;
            if (member.isArray()) {
                for (Object arrayValue : (Object[])value) {
                    Class valueClass = Hibernate.getClass(arrayValue);
                    DocumentBuilder<Object> builder = searchFactoryImplementor.getDocumentBuilders().get(valueClass);
                    if (builder == null) continue;
                    this.processContainedInValue(arrayValue, queue, valueClass, builder, searchFactoryImplementor);
                }
                continue;
            }
            if (member.isCollection()) {
                Collection collection = Map.class.equals(member.getCollectionClass()) ? ((Map)value).values() : (Collection)value;
                for (Object collectionValue : collection) {
                    Class valueClass = Hibernate.getClass(collectionValue);
                    DocumentBuilder<Object> builder = searchFactoryImplementor.getDocumentBuilders().get(valueClass);
                    if (builder == null) continue;
                    this.processContainedInValue(collectionValue, queue, valueClass, builder, searchFactoryImplementor);
                }
                continue;
            }
            Class valueClass = Hibernate.getClass(value);
            DocumentBuilder<Object> builder = searchFactoryImplementor.getDocumentBuilders().get(valueClass);
            if (builder == null) continue;
            this.processContainedInValue(value, queue, valueClass, builder, searchFactoryImplementor);
        }
    }

    private void processContainedInValue(Object value, List<LuceneWork> queue, Class valueClass, DocumentBuilder builder, SearchFactoryImplementor searchFactoryImplementor) {
        Serializable id = (Serializable)builder.getMemberValue(value, builder.idGetter);
        builder.addWorkToQueue(valueClass, value, id, WorkType.UPDATE, queue, searchFactoryImplementor);
    }

    public Document getDocument(T instance, Serializable id) {
        Document doc = new Document();
        XClass instanceClass = this.reflectionManager.toXClass(Hibernate.getClass(instance));
        if (this.rootPropertiesMetadata.boost != null) {
            doc.setBoost(this.rootPropertiesMetadata.boost.floatValue());
        }
        Field classField = new Field(CLASS_FIELDNAME, instanceClass.getName(), Field.Store.YES, Field.Index.UN_TOKENIZED);
        doc.add((Fieldable)classField);
        this.idBridge.set(this.idKeywordName, id, doc, Field.Store.YES, Field.Index.UN_TOKENIZED, this.idBoost);
        this.buildDocumentFields(instance, doc, this.rootPropertiesMetadata);
        return doc;
    }

    private void buildDocumentFields(Object instance, Document doc, PropertiesMetadata propertiesMetadata) {
        Object value;
        XMember member;
        int i;
        if (instance == null) {
            return;
        }
        Object unproxiedInstance = this.unproxy(instance);
        for (i = 0; i < propertiesMetadata.classBridges.size(); ++i) {
            FieldBridge fb = propertiesMetadata.classBridges.get(i);
            fb.set(propertiesMetadata.classNames.get(i), unproxiedInstance, doc, propertiesMetadata.classStores.get(i), propertiesMetadata.classIndexes.get(i), propertiesMetadata.classBoosts.get(i));
        }
        for (i = 0; i < propertiesMetadata.fieldNames.size(); ++i) {
            member = propertiesMetadata.fieldGetters.get(i);
            value = this.getMemberValue(unproxiedInstance, member);
            propertiesMetadata.fieldBridges.get(i).set(propertiesMetadata.fieldNames.get(i), value, doc, propertiesMetadata.fieldStore.get(i), propertiesMetadata.fieldIndex.get(i), this.getBoost(member));
        }
        block8: for (i = 0; i < propertiesMetadata.embeddedGetters.size(); ++i) {
            member = propertiesMetadata.embeddedGetters.get(i);
            value = this.getMemberValue(unproxiedInstance, member);
            if (value == null) continue;
            PropertiesMetadata embeddedMetadata = propertiesMetadata.embeddedPropertiesMetadata.get(i);
            switch (propertiesMetadata.embeddedContainers.get(i)) {
                case ARRAY: {
                    for (Object arrayValue : (Object[])value) {
                        this.buildDocumentFields(arrayValue, doc, embeddedMetadata);
                    }
                    continue block8;
                }
                case COLLECTION: {
                    for (Object collectionValue : (Collection)value) {
                        this.buildDocumentFields(collectionValue, doc, embeddedMetadata);
                    }
                    continue block8;
                }
                case MAP: {
                    for (Object collectionValue : ((Map)value).values()) {
                        this.buildDocumentFields(collectionValue, doc, embeddedMetadata);
                    }
                    continue block8;
                }
                case OBJECT: {
                    this.buildDocumentFields(value, doc, embeddedMetadata);
                    continue block8;
                }
                default: {
                    throw new AssertionFailure("Unknown embedded container: " + (Object)((Object)propertiesMetadata.embeddedContainers.get(i)));
                }
            }
        }
    }

    private Object unproxy(Object value) {
        if (value instanceof HibernateProxy) {
            value = ((HibernateProxy)value).getHibernateLazyInitializer().getImplementation();
        }
        return value;
    }

    public Term getTerm(Serializable id) {
        return new Term(this.idKeywordName, this.idBridge.objectToString(id));
    }

    public DirectoryProvider[] getDirectoryProviders() {
        return this.directoryProviders;
    }

    public IndexShardingStrategy getDirectoryProviderSelectionStrategy() {
        return this.shardingStrategy;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    private static void setAccessible(XMember member) {
        if (!Modifier.isPublic(member.getModifiers())) {
            member.setAccessible(true);
        }
    }

    public TwoWayFieldBridge getIdBridge() {
        return this.idBridge;
    }

    public String getIdKeywordName() {
        return this.idKeywordName;
    }

    public static Class getDocumentClass(Document document) {
        String className = document.get(CLASS_FIELDNAME);
        try {
            return ReflectHelper.classForName(className);
        }
        catch (ClassNotFoundException e) {
            throw new SearchException("Unable to load indexed class: " + className, e);
        }
    }

    public static Serializable getDocumentId(SearchFactoryImplementor searchFactoryImplementor, Class clazz, Document document) {
        DocumentBuilder<Object> builder = searchFactoryImplementor.getDocumentBuilders().get(clazz);
        if (builder == null) {
            throw new SearchException("No Lucene configuration set up for: " + clazz.getName());
        }
        return (Serializable)builder.getIdBridge().get(builder.getIdKeywordName(), document);
    }

    public static Object[] getDocumentFields(SearchFactoryImplementor searchFactoryImplementor, Class clazz, Document document, String[] fields) {
        DocumentBuilder<Object> builder = searchFactoryImplementor.getDocumentBuilders().get(clazz);
        if (builder == null) {
            throw new SearchException("No Lucene configuration set up for: " + clazz.getName());
        }
        int fieldNbr = fields.length;
        Object[] result = new Object[fieldNbr];
        if (builder.idKeywordName != null) {
            DocumentBuilder.populateResult(builder.idKeywordName, builder.idBridge, Field.Store.YES, fields, result, document);
        }
        PropertiesMetadata metadata = builder.rootPropertiesMetadata;
        DocumentBuilder.processFieldsForProjection(metadata, fields, result, document);
        return result;
    }

    private static void processFieldsForProjection(PropertiesMetadata metadata, String[] fields, Object[] result, Document document) {
        int nbrFoEntityFields = metadata.fieldNames.size();
        for (int index = 0; index < nbrFoEntityFields; ++index) {
            DocumentBuilder.populateResult(metadata.fieldNames.get(index), metadata.fieldBridges.get(index), metadata.fieldStore.get(index), fields, result, document);
        }
        int nbrOfEmbeddedObjects = metadata.embeddedPropertiesMetadata.size();
        for (int index = 0; index < nbrOfEmbeddedObjects; ++index) {
            if (metadata.embeddedContainers.get(index) != PropertiesMetadata.Container.OBJECT) continue;
            DocumentBuilder.processFieldsForProjection(metadata.embeddedPropertiesMetadata.get(index), fields, result, document);
        }
    }

    private static void populateResult(String fieldName, FieldBridge fieldBridge, Field.Store store, String[] fields, Object[] result, Document document) {
        int matchingPosition = DocumentBuilder.getFieldPosition(fields, fieldName);
        if (matchingPosition != -1) {
            if (store != Field.Store.NO && TwoWayFieldBridge.class.isAssignableFrom(fieldBridge.getClass())) {
                result[matchingPosition] = ((TwoWayFieldBridge)fieldBridge).get(fieldName, document);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Field " + fieldName + " projected as " + result[matchingPosition]));
                }
            } else {
                if (store == Field.Store.NO) {
                    throw new SearchException("Projecting an unstored field: " + fieldName);
                }
                throw new SearchException("FieldBridge is not a TwoWayFieldBridge: " + fieldBridge.getClass());
            }
        }
    }

    private static int getFieldPosition(String[] fields, String fieldName) {
        int fieldNbr = fields.length;
        for (int index = 0; index < fieldNbr; ++index) {
            if (!fieldName.equals(fields[index])) continue;
            return index;
        }
        return -1;
    }

    public void postInitialize(Set<Class> indexedClasses) {
        Class plainClass = this.reflectionManager.toClass(this.beanClass);
        HashSet<Class> tempMappedSubclasses = new HashSet<Class>();
        for (Class currentClass : indexedClasses) {
            if (!plainClass.isAssignableFrom(currentClass)) continue;
            tempMappedSubclasses.add(currentClass);
        }
        this.mappedSubclasses = Collections.unmodifiableSet(tempMappedSubclasses);
    }

    public Set<Class> getMappedSubclasses() {
        return this.mappedSubclasses;
    }

    private static class PropertiesMetadata {
        public Float boost;
        public Analyzer analyzer;
        public final List<String> fieldNames = new ArrayList<String>();
        public final List<XMember> fieldGetters = new ArrayList<XMember>();
        public final List<FieldBridge> fieldBridges = new ArrayList<FieldBridge>();
        public final List<Field.Store> fieldStore = new ArrayList<Field.Store>();
        public final List<Field.Index> fieldIndex = new ArrayList<Field.Index>();
        public final List<XMember> embeddedGetters = new ArrayList<XMember>();
        public final List<PropertiesMetadata> embeddedPropertiesMetadata = new ArrayList<PropertiesMetadata>();
        public final List<Container> embeddedContainers = new ArrayList<Container>();
        public final List<XMember> containedInGetters = new ArrayList<XMember>();
        public final List<String> classNames = new ArrayList<String>();
        public final List<Field.Store> classStores = new ArrayList<Field.Store>();
        public final List<Field.Index> classIndexes = new ArrayList<Field.Index>();
        public final List<FieldBridge> classBridges = new ArrayList<FieldBridge>();
        public final List<Float> classBoosts = new ArrayList<Float>();

        private PropertiesMetadata() {
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Container {
            OBJECT,
            COLLECTION,
            MAP,
            ARRAY;

        }
    }
}

