/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util;

import java.lang.reflect.Modifier;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.util.StringHelper;

public abstract class ReflectionHelper {
    private ReflectionHelper() {
    }

    public static String getAttributeName(XMember member, String name) {
        return StringHelper.isNotEmpty(name) ? name : member.getName();
    }

    public static void setAccessible(XMember member) {
        if (!Modifier.isPublic(member.getModifiers())) {
            member.setAccessible(true);
        }
    }

    public static Object getMemberValue(Object bean, XMember getter) {
        Object value;
        try {
            value = getter.invoke(bean, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not get property value", e);
        }
        return value;
    }
}

