/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.reader;

import java.io.IOException;
import java.util.Properties;
import org.apache.lucene.index.IndexReader;
import org.hibernate.search.SearchException;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.reader.ReaderProvider;
import org.hibernate.search.reader.ReaderProviderHelper;
import org.hibernate.search.store.DirectoryProvider;

public class NotSharedReaderProvider
implements ReaderProvider {
    public IndexReader openReader(DirectoryProvider ... directoryProviders) {
        int length = directoryProviders.length;
        IndexReader[] readers = new IndexReader[length];
        try {
            for (int index = 0; index < length; ++index) {
                readers[index] = IndexReader.open(directoryProviders[index].getDirectory(), (boolean)true);
            }
        }
        catch (IOException e) {
            ReaderProviderHelper.clean(new SearchException("Unable to open one of the Lucene indexes", e), readers);
        }
        return ReaderProviderHelper.buildMultiReader(length, readers);
    }

    public void closeReader(IndexReader reader) {
        try {
            reader.close();
        }
        catch (IOException e) {
            ReaderProviderHelper.clean(new SearchException("Unable to close multiReader"), reader);
        }
    }

    public void initialize(Properties props, SearchFactoryImplementor searchFactoryImplementor) {
    }

    public void destroy() {
    }
}

