/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.hibernate.HibernateException;
import org.hibernate.ScrollableResults;
import org.hibernate.search.SearchException;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.engine.DocumentExtractor;
import org.hibernate.search.engine.EntityInfo;
import org.hibernate.search.engine.Loader;
import org.hibernate.type.Type;

public class ScrollableResultsImpl
implements ScrollableResults {
    private static Log log = LogFactory.getLog(ScrollableResultsImpl.class);
    private final IndexSearcher searcher;
    private final SearchFactory searchFactory;
    private final Hits hits;
    private final int first;
    private final int max;
    private final int fetchSize;
    private int current;
    private EntityInfo[] entityInfos;
    private Loader loader;
    private DocumentExtractor documentExtractor;
    private Map<EntityInfo, Object[]> resultContext;

    public ScrollableResultsImpl(IndexSearcher searcher, Hits hits, int first, int max, int fetchSize, DocumentExtractor extractor, Loader loader, SearchFactory searchFactory) {
        this.searcher = searcher;
        this.searchFactory = searchFactory;
        this.hits = hits;
        this.first = first;
        this.max = max;
        this.current = first;
        this.loader = loader;
        this.documentExtractor = extractor;
        int size = max - first + 1 > 0 ? max - first + 1 : 0;
        this.entityInfos = new EntityInfo[size];
        this.resultContext = new HashMap<EntityInfo, Object[]>(size);
        this.fetchSize = fetchSize;
    }

    private EntityInfo loadCache(int windowStart) {
        EntityInfo info = this.entityInfos[windowStart - this.first];
        if (info != null) {
            return info;
        }
        int windowStop = windowStart + this.fetchSize > this.max ? this.max : windowStart + this.fetchSize - 1;
        ArrayList<EntityInfo> entityInfosLoaded = new ArrayList<EntityInfo>(windowStop - windowStart + 1);
        for (int x = windowStart; x <= windowStop; ++x) {
            try {
                if (this.entityInfos[x - this.first] != null) continue;
                this.entityInfos[x - this.first] = this.documentExtractor.extract(this.hits, x);
                entityInfosLoaded.add(this.entityInfos[x - this.first]);
                continue;
            }
            catch (IOException e) {
                throw new HibernateException("Unable to read Lucene hits[" + x + "]", e);
            }
        }
        this.loader.load(entityInfosLoaded.toArray(new EntityInfo[entityInfosLoaded.size()]));
        for (EntityInfo slidingInfo : entityInfosLoaded) {
            if (this.resultContext.containsKey(slidingInfo)) continue;
            Object[] loaded = this.loader.load(slidingInfo);
            if (!loaded.getClass().isArray()) {
                loaded = new Object[]{loaded};
            }
            this.resultContext.put(slidingInfo, loaded);
        }
        return this.entityInfos[windowStart - this.first];
    }

    public boolean next() throws HibernateException {
        if (++this.current > this.max) {
            this.afterLast();
            return false;
        }
        return true;
    }

    public boolean previous() throws HibernateException {
        if (--this.current < this.first) {
            this.beforeFirst();
            return false;
        }
        return true;
    }

    public boolean scroll(int i) throws HibernateException {
        this.current += i;
        if (this.current > this.max) {
            this.afterLast();
            return false;
        }
        if (this.current < this.first) {
            this.beforeFirst();
            return false;
        }
        return true;
    }

    public boolean last() throws HibernateException {
        this.current = this.max;
        if (this.current < this.first) {
            this.beforeFirst();
            return false;
        }
        return this.max >= this.first;
    }

    public boolean first() throws HibernateException {
        this.current = this.first;
        if (this.current > this.max) {
            this.afterLast();
            return false;
        }
        return this.max >= this.first;
    }

    public void beforeFirst() throws HibernateException {
        this.current = this.first - 1;
    }

    public void afterLast() throws HibernateException {
        this.current = this.max + 1;
    }

    public boolean isFirst() throws HibernateException {
        return this.current == this.first;
    }

    public boolean isLast() throws HibernateException {
        return this.current == this.max;
    }

    public void close() throws HibernateException {
        try {
            this.searchFactory.getReaderProvider().closeReader(this.searcher.getIndexReader());
        }
        catch (SearchException e) {
            log.warn((Object)"Unable to properly close searcher in ScrollableResults", (Throwable)e);
        }
    }

    public Object[] get() throws HibernateException {
        if (this.current < this.first || this.current > this.max) {
            return null;
        }
        this.loadCache(this.current);
        return this.resultContext.get(this.entityInfos[this.current - this.first]);
    }

    public Object get(int i) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Type getType(int i) {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Integer getInteger(int col) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Long getLong(int col) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Float getFloat(int col) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Boolean getBoolean(int col) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Double getDouble(int col) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Short getShort(int col) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Byte getByte(int col) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Character getCharacter(int col) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public byte[] getBinary(int col) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public String getText(int col) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Blob getBlob(int col) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Clob getClob(int col) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public String getString(int col) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public BigDecimal getBigDecimal(int col) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public BigInteger getBigInteger(int col) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Date getDate(int col) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Locale getLocale(int col) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Calendar getCalendar(int col) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public TimeZone getTimeZone(int col) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public int getRowNumber() throws HibernateException {
        if (this.max < this.first) {
            return -1;
        }
        return this.current - this.first;
    }

    public boolean setRowNumber(int rowNumber) throws HibernateException {
        this.current = rowNumber >= 0 ? this.first + rowNumber : this.max + rowNumber + 1;
        return this.current >= this.first && this.current <= this.max;
    }
}

