/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.conversation.spi;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.servlet.http.HttpServletRequest;
import org.jboss.seam.conversation.spi.SeamConversationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeamConversationContextFactory {
    private static Logger log = Logger.getLogger(SeamConversationContextFactory.class.getName());
    private static boolean disableNoopInstance;
    private static SeamConversationContext NOOP_INSTANCE;
    private static Map<String, SeamConversationContext> contexts;

    @Produces
    public static SeamConversationContext produce(InjectionPoint ip) {
        Type baseType;
        Annotated annotated = ip.getAnnotated();
        Class storeType = null;
        if (annotated != null && (baseType = annotated.getBaseType()) instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)baseType;
            storeType = (Class)pt.getActualTypeArguments()[0];
        }
        return SeamConversationContextFactory.getContext(storeType);
    }

    public static synchronized <T> SeamConversationContext<T> getContext(Class<T> storeType) {
        String type;
        SeamConversationContext<T> scc;
        if (contexts == null) {
            contexts = new HashMap<String, SeamConversationContext>();
        }
        if (storeType == null) {
            storeType = HttpServletRequest.class;
        }
        if ((scc = contexts.get(type = storeType.getName())) == null) {
            scc = SeamConversationContextFactory.create(storeType);
            contexts.put(type, scc);
        }
        return scc;
    }

    private static <T> SeamConversationContext<T> create(Class<T> storeType) {
        ServiceLoader<SeamConversationContext> loader = ServiceLoader.load(SeamConversationContext.class);
        for (SeamConversationContext scc : loader) {
            if (!SeamConversationContextFactory.match(scc, storeType)) continue;
            return scc;
        }
        if (!disableNoopInstance) {
            log.warning("No matching SeamConversationContext for store type " + storeType + ", using NOOP instance!");
            return NOOP_INSTANCE;
        }
        throw new IllegalArgumentException("No matching CDI environment available: " + storeType);
    }

    private static boolean match(SeamConversationContext scc, final Class<?> storeType) {
        try {
            for (Class<?> current = scc.getClass(); current != Object.class; current = current.getSuperclass()) {
                final Class<?> clazz = current;
                Method doAssociate = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                    @Override
                    public Method run() throws Exception {
                        try {
                            return clazz.getDeclaredMethod("doAssociate", storeType);
                        }
                        catch (NoSuchMethodException nsme) {
                            return null;
                        }
                    }
                });
                if (doAssociate == null) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static void setDisableNoopInstance(boolean disableNoopInstance) {
        SeamConversationContextFactory.disableNoopInstance = disableNoopInstance;
    }

    static {
        NOOP_INSTANCE = new NoopSeamConversationContext();
        disableNoopInstance = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.getBoolean("seam.conversation.disable.noop");
            }
        });
    }

    @Alternative
    private static class NoopSeamConversationContext
    implements SeamConversationContext {
        private NoopSeamConversationContext() {
        }

        public SeamConversationContext associate(Object storage) {
            return this;
        }

        public SeamConversationContext activate(String conversationId) {
            return this;
        }

        public SeamConversationContext invalidate() {
            return this;
        }

        public SeamConversationContext deactivate() {
            return this;
        }

        public SeamConversationContext dissociate(Object storage) {
            return this;
        }
    }
}

