/*
 * Decompiled with CFR 0.152.
 */
package Acme.Serve;

import Acme.Serve.ThrottleItem;
import Acme.Utils;
import Acme.WildcardDictionary;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ThrottledOutputStream
extends FilterOutputStream {
    private long maxBps;
    private long bytes;
    private long start;
    private byte[] oneByte = new byte[1];

    public static WildcardDictionary parseThrottleFile(String filename) throws IOException {
        String line;
        WildcardDictionary wcd = new WildcardDictionary();
        File thFile = new File(filename);
        if (!thFile.isAbsolute()) {
            thFile = new File(System.getProperty("user.dir", "."), thFile.getName());
        }
        BufferedReader br = new BufferedReader(new FileReader(thFile));
        while ((line = br.readLine()) != null) {
            int i = line.indexOf(35);
            if (i != -1) {
                line = line.substring(0, i);
            }
            if ((line = line.trim()).length() == 0) continue;
            String[] words = Utils.splitStr(line);
            if (words.length != 2) {
                throw new IOException("malformed throttle line: " + line);
            }
            try {
                wcd.put(words[0], new ThrottleItem(Long.parseLong(words[1])));
            }
            catch (NumberFormatException e) {
                throw new IOException("malformed number in throttle line: " + line);
            }
        }
        br.close();
        return wcd;
    }

    public ThrottledOutputStream(OutputStream out, long maxBps) {
        super(out);
        this.maxBps = maxBps;
        this.bytes = 0L;
        this.start = System.currentTimeMillis();
    }

    @Override
    public void write(int b) throws IOException {
        this.oneByte[0] = (byte)b;
        this.write(this.oneByte, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.bytes += (long)len;
        long elapsed = Math.max(System.currentTimeMillis() - this.start, 1L);
        long bps = this.bytes * 1000L / elapsed;
        if (bps > this.maxBps) {
            long wakeElapsed = this.bytes * 1000L / this.maxBps;
            try {
                Thread.sleep(wakeElapsed - elapsed);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.out.write(b, off, len);
    }
}

