/*
 * Decompiled with CFR 0.152.
 */
package Acme.Serve;

import Acme.Serve.CgiServlet;
import Acme.Serve.FileServlet;
import Acme.Serve.WarDeployer;
import Acme.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.nio.channels.AsynchronousCloseException;
import java.security.Principal;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class Serve
implements ServletContext,
Serializable {
    public static final String ARG_PORT = "port";
    public static final String ARG_THROTTLES = "throttles";
    public static final String ARG_SERVLETS = "servlets";
    public static final String ARG_REALMS = "realms";
    public static final String ARG_ALIASES = "aliases";
    public static final String ARG_BINDADDRESS = "bind-address";
    public static final String ARG_BACKLOG = "backlog";
    public static final String ARG_CGI_PATH = "cgi-path";
    public static final String ARG_ERR = "error-stream";
    public static final String ARG_OUT = "out-stream";
    public static final String ARG_SESSION_TIMEOUT = "session-timeout";
    public static final String ARG_LOG_DIR = "log-dir";
    public static final String ARG_LOG_OPTIONS = "log-options";
    public static final String ARG_NOHUP = "nohup";
    public static final String ARG_JSP = "JSP";
    public static final String ARG_WAR = "war-deployer";
    public static final String ARG_KEEPALIVE = "keep-alive";
    public static final String DEF_LOGENCODING = "tjws.serve.log.encoding";
    public static final String ARG_KEEPALIVE_TIMEOUT = "timeout-keep-alive";
    public static final String ARG_MAX_CONN_USE = "max-alive-conn-use";
    public static final String ARG_SESSION_PERSIST = "sssn-persistance";
    public static final String ARG_MAX_ACTIVE_SESSIONS = "max-active-sessions";
    public static final String ARG_ACCESS_LOG_FMT = "access-log-format";
    public static final String ARG_ACCEPTOR_CLASS = "acceptorImpl";
    public static final String ARG_WORK_DIRECTORY = "workdirectory";
    public static final String ARG_SESSION_SEED = "SessionSeed";
    public static final String ARG_THREAD_POOL_SIZE = "Acme.Utils.ThreadPool.maxpooledthreads";
    protected static final int DEF_SESSION_TIMEOUT = 30;
    protected static final int DEF_MIN_ACT_SESS = 10;
    protected static final int DESTROY_TIME_SEC = 15;
    protected static final int HTTP_MAX_HDR_LEN = 0xA00000;
    public static final int DEF_PORT = 8080;
    public static final String BGCOLOR = "BGCOLOR=\"#D1E9FE\"";
    protected static final int DEF_MAX_CONN_USE = 100;
    public static final String UTF8 = "UTF-8";
    protected String hostName;
    private transient PrintStream logStream;
    private boolean useAccLog;
    private boolean keepAlive;
    private int timeoutKeepAlive;
    private int maxAliveConnUse;
    private boolean showUserAgent;
    private boolean showReferer;
    protected String keepAliveHdrParams;
    protected transient PathTreeDictionary registry;
    protected transient PathTreeDictionary realms;
    protected transient PathTreeDictionary mappingtable;
    private Hashtable attributes;
    protected transient KeepAliveCleaner keepAliveCleaner;
    protected transient ThreadGroup serverThreads;
    protected transient Utils.ThreadPool threadPool;
    protected transient Constructor gzipInStreamConstr;
    private byte[] uniqer = new byte[20];
    private SecureRandom srandom;
    protected HttpSessionContextImpl sessions;
    protected int expiredIn;
    public Map arguments;
    public Properties mime;
    protected List<ServeConnection> connections = new ArrayList<ServeConnection>();
    transient boolean running = true;
    protected transient Acceptor acceptor;
    protected transient Thread ssclThread;
    protected transient boolean initialized;
    protected CountDownLatch shutdownLatch;
    protected Thread backgroundThread;

    public Serve(Map arguments, PrintStream logStream) {
        int timeoutKeepAliveSec;
        this.arguments = arguments;
        this.logStream = logStream;
        this.registry = new PathTreeDictionary();
        this.realms = new PathTreeDictionary();
        this.attributes = new Hashtable();
        this.serverThreads = new ThreadGroup("TJWS threads");
        Properties props = new Properties();
        props.putAll((Map<?, ?>)arguments);
        this.threadPool = new Utils.ThreadPool(props, new Utils.ThreadFactory(){

            @Override
            public Thread create(Runnable runnable) {
                Thread result = new Thread(Serve.this.serverThreads, runnable);
                result.setDaemon(true);
                return result;
            }
        });
        this.setAccessLogged();
        this.keepAlive = arguments.get(ARG_KEEPALIVE) == null || (Boolean)arguments.get(ARG_KEEPALIVE) != false;
        System.out.println("KEEPALIVE!: " + this.keepAlive);
        try {
            timeoutKeepAliveSec = Integer.parseInt((String)arguments.get(ARG_KEEPALIVE_TIMEOUT));
        }
        catch (Exception ex) {
            timeoutKeepAliveSec = 30;
        }
        this.timeoutKeepAlive = timeoutKeepAliveSec * 1000;
        try {
            this.maxAliveConnUse = Integer.parseInt((String)arguments.get(ARG_MAX_CONN_USE));
        }
        catch (Exception ex) {
            this.maxAliveConnUse = 100;
        }
        this.keepAliveHdrParams = "timeout=" + timeoutKeepAliveSec + ", max=" + this.maxAliveConnUse;
        this.expiredIn = arguments.get(ARG_SESSION_TIMEOUT) != null ? (Integer)arguments.get(ARG_SESSION_TIMEOUT) : 30;
        this.srandom = new SecureRandom((arguments.get(ARG_SESSION_SEED) == null ? "TJWS" + new Date() : (String)arguments.get(ARG_SESSION_SEED)).getBytes());
        try {
            this.gzipInStreamConstr = Class.forName("java.util.zip.GZIPInputStream").getConstructor(InputStream.class);
        }
        catch (ClassNotFoundException cne) {
        }
        catch (NoSuchMethodException nsm) {
            // empty catch block
        }
        this.initMime();
    }

    public Serve() {
        this(new HashMap(), System.err);
    }

    protected void setAccessLogged() {
        String logflags = (String)this.arguments.get(ARG_LOG_OPTIONS);
        if (logflags != null) {
            this.useAccLog = true;
            this.showUserAgent = logflags.indexOf(65) >= 0;
            this.showReferer = logflags.indexOf(82) >= 0;
        }
    }

    protected boolean isAccessLogged() {
        return this.useAccLog;
    }

    protected boolean isShowReferer() {
        return this.showReferer;
    }

    protected boolean isShowUserAgent() {
        return this.showUserAgent;
    }

    protected boolean isKeepAlive() {
        return this.keepAlive;
    }

    protected int getKeepAliveDuration() {
        return this.timeoutKeepAlive;
    }

    protected String getKeepAliveParamStr() {
        return this.keepAliveHdrParams;
    }

    protected int getMaxTimesConnectionUse() {
        return this.maxAliveConnUse;
    }

    protected void initMime() {
        this.mime = new Properties();
        try {
            this.mime.load(this.getClass().getClassLoader().getResourceAsStream("Acme/Resource/mime.properties"));
        }
        catch (Exception ex) {
            this.log("MIME map can't be loaded:" + ex);
        }
    }

    public void addServlet(String urlPat, String className) {
        this.addServlet(urlPat, className, (Hashtable)null);
    }

    public void addServlet(String urlPat, String className, Hashtable initParams) {
        int i;
        SecurityManager security = System.getSecurityManager();
        if (security != null && (i = className.lastIndexOf(46)) > 0) {
            security.checkPackageAccess(className.substring(0, i));
            security.checkPackageDefinition(className.substring(0, i));
        }
        try {
            this.addServlet(urlPat, (Servlet)Class.forName(className).newInstance(), initParams);
        }
        catch (ClassNotFoundException e) {
            this.log("Class not found: " + className);
            ClassLoader cl = this.getClass().getClassLoader();
            this.log("Class loader: " + cl);
            if (cl instanceof URLClassLoader) {
                this.log("CP: " + Arrays.asList(((URLClassLoader)cl).getURLs()));
            }
        }
        catch (ClassCastException e) {
            this.log("Servlet class doesn't implement javax.servlet.Servlet: " + e.getMessage());
        }
        catch (InstantiationException e) {
            this.log("Can't instantiate servlet: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.log("Illegal class access: " + e.getMessage());
        }
        catch (Exception e) {
            this.log("Unexpected problem of servlet creation: " + e, e);
        }
    }

    public void addServlet(String urlPat, Servlet servlet) {
        this.addServlet(urlPat, servlet, (Hashtable)null);
    }

    public synchronized void addServlet(String urlPat, Servlet servlet, Hashtable initParams) {
        try {
            if (this.getServlet(urlPat) != null) {
                this.log("Servlet overriden by " + servlet + ", for path:" + urlPat);
            }
            servlet.init((ServletConfig)new ServeConfig(this, initParams, urlPat));
            this.registry.put(urlPat, servlet);
        }
        catch (ServletException e) {
            this.log("Problem initializing servlet, it won't be used: " + (Object)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Servlet unloadServlet(Servlet servlet) {
        Servlet result = null;
        PathTreeDictionary pathTreeDictionary = this.registry;
        synchronized (pathTreeDictionary) {
            result = (Servlet)this.registry.remove(servlet)[0];
        }
        return result;
    }

    public synchronized void unloadServlet(String urlPat) {
        Servlet servlet = (Servlet)this.registry.remove(urlPat)[0];
        if (servlet != null) {
            servlet.destroy();
        }
    }

    public void addDefaultServlets(String cgi) {
        try {
            this.addDefaultServlets(cgi, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void addDefaultServlets(String cgi, String throttles) throws IOException {
        if (cgi != null) {
            if (this.getServlet("/" + cgi) == null) {
                this.addServlet("/" + cgi, (Servlet)new CgiServlet());
            } else {
                this.log("Servlet for path '/" + cgi + "' already defined and no default will be used.");
            }
        }
        if (this.getServlet("/") == null) {
            if (throttles != null) {
                this.addServlet("/", (Servlet)new FileServlet(throttles, null));
            } else {
                this.addServlet("/", (Servlet)new FileServlet());
            }
        } else {
            this.log("Servlet for path '/' already defined and no default will be used.");
        }
    }

    protected void addWarDeployer(String deployerFactory, String throttles) {
        if (deployerFactory == null) {
            deployerFactory = "rogatkin.web.WarRoller";
        }
        try {
            WarDeployer wd = (WarDeployer)Class.forName(deployerFactory).newInstance();
            wd.deploy(this);
        }
        catch (ClassNotFoundException cnf) {
            this.log("Problem initializing war deployer: " + cnf);
        }
        catch (Exception e) {
            this.log("Problem war(s) deployment", e);
        }
    }

    protected File getPersistentFile() {
        if (this.arguments.get(ARG_SESSION_PERSIST) == null || (Boolean)this.arguments.get(ARG_SESSION_PERSIST) == Boolean.FALSE) {
            return null;
        }
        String workPath = (String)this.arguments.get(ARG_WORK_DIRECTORY);
        if (workPath == null) {
            workPath = ".";
        }
        return new File(workPath, this.hostName + '-' + (this.arguments.get(ARG_PORT) == null ? String.valueOf(8080) : this.arguments.get(ARG_PORT)) + "-session.obj");
    }

    public void runInBackground() {
        this.shutdownLatch = new CountDownLatch(1);
        try {
            this.init();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.backgroundThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Serve.this.serve();
                }
                finally {
                    Serve.this.shutdownLatch.countDown();
                }
            }
        };
        this.backgroundThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopBackground() {
        try {
            this.notifyStop();
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        try {
            if (!this.shutdownLatch.await(100L, TimeUnit.MILLISECONDS)) {
                try {
                    this.backgroundThread.interrupt();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            this.shutdownLatch.await(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        List<ServeConnection> list = this.connections;
        synchronized (list) {
            for (ServeConnection conn : this.connections) {
                conn.closeSocket();
            }
            this.connections.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int serve() {
        try {
            while (this.running) {
                try {
                    Socket socket = this.acceptor.accept();
                    if (this.keepAliveCleaner != null) {
                        this.keepAliveCleaner.addConnection(new ServeConnection(socket, this));
                        continue;
                    }
                    new ServeConnection(socket, this);
                }
                catch (IOException e) {
                    this.log("Accept: " + e);
                }
                catch (SecurityException se) {
                    this.log("Illegal access: " + se);
                }
                catch (IllegalStateException is) {
                    this.log("Illegal state: " + is);
                }
            }
        }
        catch (Throwable t) {
            try {
                this.log("Unhandled exception: " + t + ", server is terminating.", t);
                if (t instanceof ThreadDeath) {
                    throw (Error)t;
                }
                int n = -1;
                return n;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    if (this.acceptor != null) {
                        this.acceptor.destroy();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        try {
            if (this.acceptor == null) return 0;
            this.acceptor.destroy();
            return 0;
        }
        catch (IOException e) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws IOException {
        File fsessions;
        this.shutdownLatch = new CountDownLatch(1);
        this.acceptor = this.createAcceptor();
        if (this.expiredIn > 0) {
            this.ssclThread = new Thread(this.serverThreads, new Runnable(){

                @Override
                public void run() {
                    while (Serve.this.running) {
                        try {
                            Thread.sleep(Serve.this.expiredIn * 60 * 1000);
                        }
                        catch (InterruptedException ie) {
                            if (!Serve.this.running) break;
                        }
                        Enumeration e = Serve.this.sessions.keys();
                        while (e.hasMoreElements()) {
                            AcmeSession as;
                            Object sid = e.nextElement();
                            if (sid == null || (as = (AcmeSession)Serve.this.sessions.get(sid)) == null || !as.checkExpired() && as.isValid() || (as = (AcmeSession)Serve.this.sessions.remove(sid)) == null || !as.isValid()) continue;
                            try {
                                as.invalidate();
                            }
                            catch (IllegalStateException ise) {}
                        }
                    }
                }
            }, "Session cleaner");
            this.ssclThread.setPriority(1);
            this.ssclThread.start();
        }
        if (this.isKeepAlive()) {
            this.keepAliveCleaner = new KeepAliveCleaner();
            this.keepAliveCleaner.start();
        }
        if ((fsessions = this.getPersistentFile()) != null && fsessions.exists()) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(fsessions));
                this.sessions = HttpSessionContextImpl.restore(br, Math.abs(this.expiredIn) * 60, this);
            }
            catch (IOException ioe) {
                this.log("Problem in restoring sessions.", ioe);
            }
            catch (Exception e) {
                this.log("Unexpected problem in restoring sessions.", e);
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        if (this.sessions == null) {
            this.sessions = new HttpSessionContextImpl();
        }
        System.out.println("[" + new Date() + "] TJWS httpd " + this.hostName + " - " + this.acceptor + " is listening.");
    }

    public void notifyStop() throws IOException {
        this.running = false;
        this.acceptor.destroy();
        this.acceptor = null;
        if (this.ssclThread != null) {
            this.ssclThread.interrupt();
        }
    }

    protected Acceptor createAcceptor() throws IOException {
        String acceptorClass = (String)this.arguments.get(ARG_ACCEPTOR_CLASS);
        if (acceptorClass == null) {
            acceptorClass = "Acme.Serve.SimpleAcceptor";
        }
        try {
            this.acceptor = (Acceptor)Class.forName(acceptorClass).newInstance();
        }
        catch (InstantiationException e) {
            this.log("Couldn't instantiate Acceptor, the Server is inoperable", e);
        }
        catch (IllegalAccessException e) {
            try {
                Constructor<?> c = Class.forName(acceptorClass).getDeclaredConstructor(Utils.EMPTY_CLASSES);
                c.setAccessible(true);
                this.acceptor = (Acceptor)c.newInstance(Utils.EMPTY_OBJECTS);
            }
            catch (Exception e1) {
                this.log("Acceptor is not accessable or can't be instantiated, the Server is inoperable", e);
            }
        }
        catch (ClassNotFoundException e) {
            this.log("Acceptor class not found, the Server is inoperable", e);
        }
        Properties acceptorProperties = new Properties();
        this.acceptor.init(this.arguments, acceptorProperties);
        this.hostName = (String)acceptorProperties.get(ARG_BINDADDRESS);
        return this.acceptor;
    }

    public Servlet getServlet(String name) {
        try {
            return (Servlet)this.registry.get(name)[0];
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    public Enumeration getServlets() {
        return this.registry.elements();
    }

    public Enumeration getServletNames() {
        return this.registry.keys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroyAllServlets() {
        File sf = this.getPersistentFile();
        if (sf != null && this.sessions != null) {
            FileWriter w = null;
            try {
                w = new FileWriter(sf);
                this.sessions.save(w);
                this.log("Sessions stored.");
            }
            catch (IOException ioe) {
                this.log("IO problem in storing sessions " + ioe);
            }
            catch (Throwable t) {
                this.log("Problem in storing sessions " + t);
            }
            finally {
                try {
                    ((Writer)w).close();
                }
                catch (Exception e) {}
            }
            Enumeration e = this.sessions.keys();
            while (e.hasMoreElements()) {
                AcmeSession as;
                Object sid = e.nextElement();
                if (sid == null || (as = (AcmeSession)this.sessions.get(sid)) == null || (as = (AcmeSession)this.sessions.remove(sid)) == null || !as.isValid()) continue;
                try {
                    as.invalidate();
                }
                catch (IllegalStateException ise) {}
            }
        }
        final Enumeration en = this.registry.elements();
        Runnable servletDestroyer = new Runnable(){

            @Override
            public void run() {
                ((Servlet)en.nextElement()).destroy();
            }
        };
        int dhc = 0;
        while (en.hasMoreElements()) {
            Thread destroyThread = new Thread(servletDestroyer, "Destroy");
            destroyThread.setDaemon(true);
            destroyThread.start();
            try {
                destroyThread.join(15000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (!destroyThread.isAlive()) continue;
            this.log("Destroy thread didn't terminate in 15");
            destroyThread.setName("Destroy too long " + dhc++);
        }
        this.registry = new PathTreeDictionary();
    }

    protected void setMappingTable(PathTreeDictionary mappingtable) {
        this.mappingtable = mappingtable;
    }

    protected void setRealms(PathTreeDictionary realms) {
        this.realms = realms;
    }

    AcmeSession getSession(String id) {
        return (AcmeSession)this.sessions.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HttpSession createSession() {
        Integer ms = (Integer)this.arguments.get(ARG_MAX_ACTIVE_SESSIONS);
        if (ms != null && ms < this.sessions.size()) {
            return null;
        }
        AcmeSession result = new AcmeSession(this.generateSessionId(), Math.abs(this.expiredIn) * 60, this, this.sessions);
        HttpSessionContextImpl httpSessionContextImpl = this.sessions;
        synchronized (httpSessionContextImpl) {
            this.sessions.put(result.getId(), result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSession(String id) {
        HttpSessionContextImpl httpSessionContextImpl = this.sessions;
        synchronized (httpSessionContextImpl) {
            this.sessions.remove(id);
        }
    }

    public void log(String message) {
        Date date = new Date(System.currentTimeMillis());
        this.logStream.println("[" + date.toString() + "] " + message);
    }

    public void log(String message, Throwable throwable) {
        if (throwable != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            message = message + '\n' + sw;
        }
        this.log(message);
    }

    public void log(Exception exception, String message) {
        this.log(message, exception);
    }

    public String getRealPath(String path) {
        if (this.mappingtable != null) {
            Object[] os = this.mappingtable.get(path);
            if (os[0] == null) {
                return null;
            }
            int slpos = (Integer)os[1];
            int pl = path.length();
            if (slpos > 0) {
                path = path.length() > slpos ? path.substring(slpos + 1) : "";
            } else if (pl > 0) {
                for (int i = 0; i < pl; ++i) {
                    char s = path.charAt(i);
                    if (s == '/' || s == '\\') continue;
                    if (i <= 0) break;
                    path = path.substring(i);
                    break;
                }
            }
            return new File((File)os[0], path).getPath();
        }
        return path;
    }

    public String getContextPath() {
        return "";
    }

    public String getMimeType(String file) {
        int dp = file.lastIndexOf(46);
        if (dp > 0) {
            return this.mime.getProperty(file.substring(dp + 1).toUpperCase());
        }
        return null;
    }

    public String getServerInfo() {
        return "D. Rogatkin's TJWS based on Acme.Serve Version 1.70, $Revision: 1.194 $ (http://tjws.sourceforge.net)";
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object object) {
        if (object != null) {
            this.attributes.put(name, object);
        } else {
            this.attributes.remove(name);
        }
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public ServletContext getContext(String uripath) {
        return this;
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 5;
    }

    public Set getResourcePaths(String path) {
        String[] dir;
        String realPath = this.getRealPath(path);
        if (realPath != null && (dir = new File(realPath).list()).length > 0) {
            HashSet<String> set = new HashSet<String>(dir.length);
            for (int i = 0; i < dir.length; ++i) {
                set.add(dir[i]);
            }
            return set;
        }
        return null;
    }

    public String getServletContextName() {
        return null;
    }

    public URL getResource(String path) throws MalformedURLException {
        if (path == null || path.length() == 0 || path.charAt(0) != '/') {
            throw new MalformedURLException("Path " + path + " is not in acceptable form.");
        }
        File resFile = new File(this.getRealPath(path));
        if (resFile.exists()) {
            return new URL("file", "localhost", resFile.getPath());
        }
        return null;
    }

    public InputStream getResourceAsStream(String path) {
        try {
            return this.getResource(path).openStream();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public RequestDispatcher getRequestDispatcher(String urlpath) {
        if (urlpath == null || urlpath.length() == 0 || urlpath.charAt(0) != '/') {
            return null;
        }
        try {
            return new SimpleRequestDispatcher(urlpath);
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    public String getInitParameter(String param) {
        return null;
    }

    public Enumeration getInitParameterNames() {
        return Utils.EMPTY_ENUMERATION;
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return null;
    }

    synchronized String generateSessionId() {
        this.srandom.nextBytes(this.uniqer);
        return Utils.base64Encode(this.uniqer);
    }

    protected static class HttpSessionContextImpl
    extends Hashtable
    implements HttpSessionContext {
        protected HttpSessionContextImpl() {
        }

        public Enumeration getIds() {
            return this.keys();
        }

        public HttpSession getSession(String sessionId) {
            return (HttpSession)this.get(sessionId);
        }

        void save(Writer w) throws IOException {
            Enumeration e = this.elements();
            while (e.hasMoreElements()) {
                ((AcmeSession)e.nextElement()).save(w);
            }
        }

        static HttpSessionContextImpl restore(BufferedReader br, int inactiveInterval, ServletContext servletContext) throws IOException {
            AcmeSession session;
            HttpSessionContextImpl result = new HttpSessionContextImpl();
            while ((session = AcmeSession.restore(br, inactiveInterval, servletContext, result)) != null) {
                if (session.checkExpired()) continue;
                result.put(session.getId(), session);
            }
            return result;
        }
    }

    protected static class AcceptLocaleEnumeration
    implements Enumeration {
        Iterator i;

        public AcceptLocaleEnumeration(TreeSet ts) {
            this.i = ts.iterator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.i.hasNext();
        }

        public Object nextElement() {
            return ((LocaleWithWeight)this.i.next()).getLocale();
        }
    }

    protected static class LocaleWithWeight
    implements Comparable {
        protected float weight;
        protected Locale locale;

        LocaleWithWeight(Locale l, float w) {
            this.locale = l;
            this.weight = w;
        }

        public int compareTo(Object o) {
            if (o instanceof LocaleWithWeight) {
                return (int)(((LocaleWithWeight)o).weight - this.weight) * 100;
            }
            throw new IllegalArgumentException();
        }

        public Locale getLocale() {
            return this.locale;
        }
    }

    public static class AcmeSession
    extends Hashtable
    implements HttpSession {
        private long createTime = System.currentTimeMillis();
        private long lastAccessTime;
        private String id;
        private int inactiveInterval;
        private boolean expired;
        private transient ServletContext servletContext;
        private transient HttpSessionContext sessionContext;
        private transient List listeners;

        AcmeSession(String id, ServletContext servletContext, HttpSessionContext sessionContext) {
            this(id, 0, servletContext, sessionContext);
        }

        AcmeSession(String id, int inactiveInterval, ServletContext servletContext, HttpSessionContext sessionContext) {
            this.id = id;
            this.inactiveInterval = inactiveInterval;
            this.servletContext = servletContext;
            this.sessionContext = sessionContext;
        }

        public long getCreationTime() {
            return this.createTime;
        }

        public String getId() {
            return this.id;
        }

        public long getLastAccessedTime() {
            return this.lastAccessTime;
        }

        public void setMaxInactiveInterval(int interval) {
            this.inactiveInterval = interval;
        }

        public int getMaxInactiveInterval() {
            return this.inactiveInterval;
        }

        public HttpSessionContext getSessionContext() {
            return this.sessionContext;
        }

        public ServletContext getServletContext() {
            return this.servletContext;
        }

        public Object getAttribute(String name) throws IllegalStateException {
            if (this.expired) {
                throw new IllegalStateException();
            }
            return this.get(name);
        }

        public Object getValue(String name) throws IllegalStateException {
            return this.getAttribute(name);
        }

        public Enumeration getAttributeNames() throws IllegalStateException {
            if (this.expired) {
                throw new IllegalStateException();
            }
            return this.keys();
        }

        public String[] getValueNames() throws IllegalStateException {
            Enumeration e = this.getAttributeNames();
            Vector names = new Vector();
            while (e.hasMoreElements()) {
                names.addElement(e.nextElement());
            }
            Object[] result = new String[names.size()];
            names.copyInto(result);
            return result;
        }

        public void setAttribute(String name, Object value) throws IllegalStateException {
            Object oldValue;
            if (this.expired) {
                throw new IllegalStateException();
            }
            Object object = oldValue = value != null ? this.put(name, value) : this.remove(name);
            if (oldValue != null) {
                if (oldValue instanceof HttpSessionBindingListener) {
                    ((HttpSessionBindingListener)oldValue).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name));
                } else if (oldValue instanceof HttpSessionAttributeListener) {
                    ((HttpSessionAttributeListener)oldValue).attributeReplaced(new HttpSessionBindingEvent((HttpSession)this, name, value));
                }
            }
            if (value instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)value).valueBound(new HttpSessionBindingEvent((HttpSession)this, name));
            } else if (value instanceof HttpSessionAttributeListener) {
                ((HttpSessionAttributeListener)value).attributeAdded(new HttpSessionBindingEvent((HttpSession)this, name));
            }
        }

        public void putValue(String name, Object value) throws IllegalStateException {
            this.setAttribute(name, value);
        }

        public void removeAttribute(String name) throws IllegalStateException {
            if (this.expired) {
                throw new IllegalStateException();
            }
            Object value = this.remove(name);
            if (value != null) {
                if (value instanceof HttpSessionBindingListener) {
                    ((HttpSessionBindingListener)value).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name));
                } else if (value instanceof HttpSessionAttributeListener) {
                    ((HttpSessionAttributeListener)value).attributeRemoved(new HttpSessionBindingEvent((HttpSession)this, name));
                }
            }
        }

        public void removeValue(String name) throws IllegalStateException {
            this.removeAttribute(name);
        }

        public synchronized void invalidate() throws IllegalStateException {
            if (this.expired) {
                throw new IllegalStateException();
            }
            this.notifyListeners();
            Enumeration e = this.getAttributeNames();
            while (e.hasMoreElements()) {
                this.removeAttribute((String)e.nextElement());
            }
            this.setExpired(true);
        }

        public boolean isNew() throws IllegalStateException {
            if (this.expired) {
                throw new IllegalStateException();
            }
            return this.lastAccessTime == 0L;
        }

        public synchronized void setListeners(List l) {
            if (this.listeners == null) {
                this.listeners = l;
                if (this.listeners != null) {
                    HttpSessionEvent event = new HttpSessionEvent((HttpSession)this);
                    for (int i = 0; i < this.listeners.size(); ++i) {
                        try {
                            ((HttpSessionListener)this.listeners.get(0)).sessionCreated(event);
                            continue;
                        }
                        catch (ClassCastException cce) {
                            continue;
                        }
                        catch (NullPointerException npe) {
                            // empty catch block
                        }
                    }
                }
            }
        }

        public synchronized void setServletContext(ServletContext sc) {
            this.servletContext = sc;
        }

        private void notifyListeners() {
            if (this.listeners != null) {
                HttpSessionEvent event = new HttpSessionEvent((HttpSession)this);
                for (int i = 0; i < this.listeners.size(); ++i) {
                    try {
                        ((HttpSessionListener)this.listeners.get(i)).sessionDestroyed(event);
                        continue;
                    }
                    catch (ClassCastException cce) {
                        continue;
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
        }

        private void setExpired(boolean expired) {
            this.expired = expired;
        }

        boolean isValid() {
            return !this.expired;
        }

        boolean checkExpired() {
            return this.inactiveInterval > 0 && (long)(this.inactiveInterval * 1000) < System.currentTimeMillis() - this.lastAccessTime;
        }

        void userTouch() {
            if (!this.isValid()) {
                throw new IllegalStateException();
            }
            this.lastAccessTime = System.currentTimeMillis();
        }

        void save(Writer w) throws IOException {
            if (this.expired) {
                return;
            }
            w.write(this.id);
            w.write(58);
            w.write(Integer.toString(this.inactiveInterval));
            w.write(58);
            w.write(this.servletContext == null || this.servletContext.getServletContextName() == null ? "" : this.servletContext.getServletContextName());
            w.write(58);
            w.write(Long.toString(this.lastAccessTime));
            w.write("\r\n");
            Enumeration e = this.getAttributeNames();
            ByteArrayOutputStream os = new ByteArrayOutputStream(16384);
            while (e.hasMoreElements()) {
                String aname = (String)e.nextElement();
                Object so = this.get(aname);
                if (so instanceof Serializable) {
                    os.reset();
                    ObjectOutputStream oos = new ObjectOutputStream(os);
                    try {
                        oos.writeObject(so);
                        w.write(aname);
                        w.write(":");
                        w.write(Utils.base64Encode(os.toByteArray()));
                        w.write("\r\n");
                    }
                    catch (IOException ioe) {
                        this.servletContext.log("Problem storing a session value of " + aname, (Throwable)ioe);
                    }
                } else {
                    this.servletContext.log("Non serializable object " + so.getClass().getName() + " skiped in storing of " + aname, null);
                }
                if (!(so instanceof HttpSessionActivationListener)) continue;
                ((HttpSessionActivationListener)so).sessionWillPassivate(new HttpSessionEvent((HttpSession)this));
            }
            w.write("$$\r\n");
        }

        static AcmeSession restore(BufferedReader r, int inactiveInterval, ServletContext servletContext, HttpSessionContext sessionContext) throws IOException {
            String s = r.readLine();
            if (s == null) {
                return null;
            }
            int cp = s.indexOf(58);
            if (cp < 0) {
                throw new IOException("Invalid format for a session header, no session id: " + s);
            }
            String id = s.substring(0, cp);
            int cp2 = s.indexOf(58, cp + 1);
            if (cp2 < 0) {
                throw new IOException("Invalid format for a session header, no latency: " + s);
            }
            try {
                inactiveInterval = Integer.parseInt(s.substring(cp + 1, cp2));
            }
            catch (NumberFormatException nfe) {
                servletContext.log("Session latency is invalid:" + s.substring(cp + 1, cp2) + " " + nfe);
            }
            cp = s.indexOf(58, cp2 + 1);
            if (cp < 0) {
                throw new IOException("Invalid format for a session header, context name: " + s);
            }
            String contextName = s.substring(cp2 + 1, cp);
            AcmeSession result = new AcmeSession(id, inactiveInterval, (ServletContext)(contextName.length() == 0 ? servletContext : null), sessionContext);
            try {
                result.lastAccessTime = Long.parseLong(s.substring(cp + 1));
            }
            catch (NumberFormatException nfe) {
                servletContext.log("Last access time is invalid:" + s.substring(cp + 1) + " " + nfe);
            }
            while (true) {
                Throwable restoreError;
                if ((s = r.readLine()) == null) {
                    throw new IOException("Unexpected end of a stream.");
                }
                if ("$$".equals(s)) {
                    return result;
                }
                cp = s.indexOf(58);
                if (cp < 0) {
                    throw new IOException("Invalid format for a session entry: " + s);
                }
                String aname = s.substring(0, cp);
                ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(Utils.decode64(s.substring(cp + 1))));
                try {
                    Object so = ois.readObject();
                    result.put(aname, so);
                    restoreError = null;
                    if (so instanceof HttpSessionActivationListener) {
                        ((HttpSessionActivationListener)so).sessionDidActivate(new HttpSessionEvent((HttpSession)result));
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    restoreError = cnfe;
                }
                catch (NoClassDefFoundError ncdfe) {
                    restoreError = ncdfe;
                }
                catch (IOException ioe) {
                    restoreError = ioe;
                }
                if (restoreError == null) continue;
                servletContext.log("Can't restore :" + aname + ", " + restoreError);
            }
        }
    }

    public static class PathTreeDictionary {
        Node root_node = new Node();

        public synchronized void put(String path, Object value) {
            StringTokenizer st = new StringTokenizer(path, "\\/");
            Node cur_node = this.root_node;
            while (st.hasMoreTokens()) {
                String nodename = st.nextToken();
                Node node = (Node)cur_node.get(nodename);
                if (node == null) {
                    node = new Node();
                    cur_node.put(nodename, node);
                }
                cur_node = node;
            }
            cur_node.object = value;
        }

        public synchronized Object[] remove(Object value) {
            return this.remove(this.root_node, value);
        }

        public synchronized Object[] remove(String path) {
            Object[] result = this.get(path);
            if (result[1] != null) {
                return this.remove(result[1]);
            }
            return result;
        }

        public Object[] remove(Node node, Object value) {
            Enumeration e = node.keys();
            while (e.hasMoreElements()) {
                String path = (String)e.nextElement();
                Node childNode = (Node)node.get(path);
                if (childNode.object == value) {
                    childNode.object = null;
                    return new Object[]{value, new Integer(0)};
                }
                Object[] result = this.remove(childNode, value);
                if (result[0] == null) continue;
                return result;
            }
            return new Object[]{null, null};
        }

        public Object[] get(String path) {
            Object[] result = new Object[2];
            if (path == null) {
                return result;
            }
            char[] ps = path.toCharArray();
            Node cur_node = this.root_node;
            int p0 = 0;
            int lm = 0;
            result[0] = cur_node.object;
            boolean div_state = true;
            for (int i = 0; i < ps.length; ++i) {
                if (ps[i] == '/' || ps[i] == '\\') {
                    if (div_state) continue;
                    Node node = (Node)cur_node.get(new String(ps, p0, i - p0));
                    if (node == null) {
                        result[1] = new Integer(lm);
                        return result;
                    }
                    if (node.object != null) {
                        result[0] = node.object;
                        lm = i;
                    }
                    cur_node = node;
                    div_state = true;
                    continue;
                }
                if (!div_state) continue;
                p0 = i;
                div_state = false;
            }
            if ((cur_node = (Node)cur_node.get(new String(ps, p0, ps.length - p0))) != null && cur_node.object != null) {
                result[0] = cur_node.object;
                lm = ps.length;
            }
            result[1] = new Integer(lm);
            return result;
        }

        public Enumeration keys() {
            Vector result = new Vector();
            this.addSiblingNames(this.root_node, result, "");
            return result.elements();
        }

        public void addSiblingNames(Node node, Vector result, String path) {
            Enumeration e = node.keys();
            while (e.hasMoreElements()) {
                String pc = (String)e.nextElement();
                Node childNode = (Node)node.get(pc);
                pc = path + '/' + pc;
                if (childNode.object != null) {
                    result.addElement(pc);
                }
                this.addSiblingNames(childNode, result, pc);
            }
        }

        public Enumeration elements() {
            Vector result = new Vector();
            this.addSiblingObjects(this.root_node, result);
            return result.elements();
        }

        public void addSiblingObjects(Node node, Vector result) {
            Enumeration e = node.keys();
            while (e.hasMoreElements()) {
                Node childNode = (Node)node.get(e.nextElement());
                if (childNode.object != null) {
                    result.addElement(childNode.object);
                }
                this.addSiblingObjects(childNode, result);
            }
        }

        class Node
        extends Hashtable {
            Object object;

            Node() {
            }
        }
    }

    public static class ServeOutputStream
    extends ServletOutputStream {
        private static final boolean STREAM_DEBUG = false;
        private boolean chunked;
        private boolean closed;
        private OutputStream out;
        private ServeConnection conn;
        private int inInclude;
        private String encoding;
        private long lbytes;
        private Utils.SimpleBuffer buffer;

        public ServeOutputStream(OutputStream out, ServeConnection conn) {
            this.out = out;
            this.conn = conn;
            this.buffer = new Utils.SimpleBuffer();
            this.encoding = conn.getCharacterEncoding();
            if (this.encoding == null) {
                this.encoding = "ISO-8859-1";
            }
        }

        void refresh() {
            this.chunked = false;
            this.closed = false;
            this.inInclude = 0;
            this.lbytes = 0L;
            this.buffer.reset();
            this.encoding = this.conn.getCharacterEncoding();
            if (this.encoding == null) {
                this.encoding = "ISO-8859-1";
            }
        }

        protected void reset() {
            if (this.lbytes != 0L) {
                throw new IllegalStateException("Result was already committed");
            }
            this.buffer.reset();
        }

        protected int getBufferSize() {
            return this.buffer.getSize();
        }

        protected void setBufferSize(int size) {
            if (this.lbytes > 0L) {
                throw new IllegalStateException("Bytes already written in response");
            }
            this.buffer.setSize(size);
        }

        protected void setChunked(boolean set) {
            this.chunked = set;
        }

        public void print(String s) throws IOException {
            this.write(s.getBytes(this.encoding));
        }

        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b}, 0, 1);
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (this.closed) {
                throw new IOException("An attempt of writing " + len + " bytes to a closed out.");
            }
            if (len == 0) {
                return;
            }
            this.conn.writeHeaders();
            b = this.buffer.put(b, off, len);
            len = b.length;
            if (len == 0) {
                return;
            }
            off = 0;
            if (this.chunked) {
                String hexl = Integer.toHexString(len);
                this.out.write((hexl + "\r\n").getBytes());
                this.lbytes += (long)(2 + hexl.length());
                this.out.write(b, off, len);
                this.lbytes += (long)len;
                this.out.write("\r\n".getBytes());
                this.lbytes += 2L;
            } else {
                this.out.write(b, off, len);
                this.lbytes += (long)len;
            }
        }

        public void flush() throws IOException {
            if (this.closed) {
                return;
            }
            this.conn.writeHeaders();
            byte[] b = this.buffer.get();
            if (b.length > 0) {
                if (this.chunked) {
                    String hexl = Integer.toHexString(b.length);
                    this.out.write((hexl + "\r\n").getBytes());
                    this.lbytes += (long)(2 + hexl.length());
                    this.out.write(b);
                    this.lbytes += (long)b.length;
                    this.out.write("\r\n".getBytes());
                    this.lbytes += 2L;
                } else {
                    this.out.write(b);
                    this.lbytes += (long)b.length;
                }
            }
            this.out.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            try {
                this.flush();
                if (this.inInclude == 0) {
                    if (this.chunked) {
                        this.out.write("0\r\n\r\n".getBytes());
                        this.lbytes += 5L;
                        this.out.flush();
                    }
                    if (!this.conn.keepAlive) {
                        this.out.close();
                    }
                }
            }
            finally {
                this.closed = true;
            }
        }

        private long lengthWritten() {
            return this.lbytes;
        }

        boolean isInInclude() {
            return this.inInclude == 0;
        }

        void setInInclude(boolean _set) {
            this.inInclude = _set ? 1 : 0;
        }
    }

    public static class ServeInputStream
    extends ServletInputStream {
        private static final boolean STREAM_DEBUG = false;
        private InputStream in;
        private InputStream origIn;
        private ServeConnection conn;
        private int chunksize = 0;
        private boolean chunking = false;
        private boolean compressed;
        private boolean returnedAsReader;
        private boolean returnedAsStream;
        private long contentLength = -1L;
        private long readCount;
        private byte[] oneReadBuf = new byte[1];
        private boolean closed;

        public ServeInputStream(InputStream in, ServeConnection conn) {
            this.conn = conn;
            this.in = new BufferedInputStream(in);
        }

        void refresh() {
            this.returnedAsReader = false;
            this.returnedAsStream = false;
            this.contentLength = -1L;
            this.readCount = 0L;
            this.chunksize = 0;
            this.closed = false;
            this.compressed(false);
        }

        public void chunking(boolean chunking) {
            if (this.contentLength == -1L) {
                this.chunking = chunking;
            }
        }

        boolean compressed(boolean on) {
            block8: {
                if (on) {
                    if (!this.compressed) {
                        this.origIn = this.in;
                        try {
                            ServeInputStream sis = new ServeInputStream(this.in, this.conn);
                            if (this.chunking) {
                                sis.chunking(true);
                                this.chunking(false);
                            }
                            this.in = (InputStream)((ServeConnection)this.conn).serve.gzipInStreamConstr.newInstance(new Object[]{sis});
                            this.compressed = true;
                        }
                        catch (Exception ex) {
                            if (ex instanceof InvocationTargetException) {
                                this.conn.serve.log("Problem in compressed stream creation", ((InvocationTargetException)ex).getTargetException());
                                break block8;
                            }
                            this.conn.serve.log("Problem in compressed stream obtaining", ex);
                        }
                    }
                } else if (this.compressed) {
                    this.compressed = false;
                    this.in = this.origIn;
                }
            }
            return this.compressed;
        }

        void setContentLength(long contentLength) {
            if (this.contentLength == -1L && contentLength >= 0L && !this.chunking) {
                this.contentLength = contentLength;
                this.readCount = 0L;
            }
        }

        protected String readLine(int maxLen) throws IOException {
            int c;
            if (maxLen <= 0) {
                throw new IllegalArgumentException("Max len:" + maxLen);
            }
            StringBuffer buf = new StringBuffer(Math.min(1024, maxLen));
            boolean cr = false;
            int i = 0;
            while ((c = this.in.read()) != -1) {
                if (c == 10) {
                    if (!cr) break;
                    break;
                }
                if (c == 13) {
                    cr = true;
                    continue;
                }
                cr = false;
                if (i >= maxLen) {
                    throw new IOException("Line lenght exceeds " + maxLen);
                }
                buf.append((char)c);
                ++i;
            }
            if (c == -1 && buf.length() == 0) {
                return null;
            }
            return buf.toString();
        }

        public int read() throws IOException {
            int result = this.read(this.oneReadBuf, 0, 1);
            if (result == 1) {
                return 0xFF & this.oneReadBuf[0];
            }
            return -1;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public synchronized int read(byte[] b, int off, int len) throws IOException {
            if (this.closed) {
                throw new IOException("The stream is already closed");
            }
            if (this.chunking) {
                if (this.chunksize <= 0 && this.getChunkSize() <= 0) {
                    return -1;
                }
                if (len > this.chunksize) {
                    len = this.chunksize;
                }
                this.chunksize = (len = this.in.read(b, off, len)) < 0 ? -1 : this.chunksize - len;
            } else if (this.contentLength >= 0L) {
                if (this.contentLength - this.readCount < Integer.MAX_VALUE) {
                    len = Math.min(len, (int)(this.contentLength - this.readCount));
                }
                if (len <= 0) {
                    return -1;
                }
                if ((len = this.in.read(b, off, len)) > 0) {
                    this.readCount += (long)len;
                }
            } else {
                len = this.in.read(b, off, len);
            }
            return len;
        }

        public long skip(long len) throws IOException {
            if (this.closed) {
                throw new IOException("The stream is already closed");
            }
            if (this.chunking) {
                if (this.chunksize <= 0 && this.getChunkSize() <= 0) {
                    return -1L;
                }
                if (len > (long)this.chunksize) {
                    len = this.chunksize;
                }
                this.chunksize = (len = this.in.skip(len)) < 0L ? -1 : this.chunksize - (int)len;
            } else if (this.contentLength >= 0L) {
                if ((len = Math.min(len, this.contentLength - this.readCount)) <= 0L) {
                    return -1L;
                }
                len = this.in.skip(len);
                this.readCount += len;
            } else {
                len = this.in.skip(len);
            }
            return len;
        }

        public int available() throws IOException {
            if (this.closed) {
                throw new IOException("The stream is already closed");
            }
            if (this.chunking) {
                int len = this.in.available();
                if (len <= this.chunksize) {
                    return len;
                }
                return this.chunksize;
            }
            if (this.contentLength >= 0L) {
                int len = this.in.available();
                if (this.contentLength - this.readCount < Integer.MAX_VALUE) {
                    return Math.min(len, (int)(this.contentLength - this.readCount));
                }
                return len;
            }
            return this.in.available();
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            if (this.chunking) {
                while (this.read() >= 0) {
                }
            } else if (this.contentLength >= 0L) {
                long skipped;
                for (long skipCount = this.contentLength - this.readCount; skipCount > 0L && (skipped = this.skip(skipCount)) > 0L; skipCount -= skipped) {
                }
            }
            if (!this.conn.keepAlive) {
                this.in.close();
            }
            this.closed = true;
        }

        public boolean markSupported() {
            return false;
        }

        public void reset() throws IOException {
            if (this.closed) {
                throw new IOException("The stream is already closed");
            }
            this.in.reset();
        }

        public void mark(int readlimit) {
        }

        private int getChunkSize() throws IOException {
            if (this.chunksize < 0) {
                return -1;
            }
            this.chunksize = -1;
            this.chunking = false;
            String line = this.readLine(60);
            while (line != null && line.length() == 0) {
                line = this.readLine(60);
            }
            this.chunking = true;
            if (line == null) {
                return -1;
            }
            int i = line.indexOf(59);
            if (i > 0) {
                line = line.substring(0, i).trim();
            }
            try {
                this.chunksize = Integer.parseInt(line, 16);
            }
            catch (NumberFormatException nfe) {
                throw new IOException("Chunked stream is broken, " + line);
            }
            if (this.chunksize == 0) {
                this.chunksize = -1;
                this.readLine(60);
                this.chunking = false;
            }
            return this.chunksize;
        }

        boolean isReturnedAsStream() {
            return this.returnedAsStream;
        }

        void setReturnedAsStream(boolean _on) {
            this.returnedAsStream = _on;
        }

        boolean isReturnedAsReader() {
            return this.returnedAsReader;
        }

        void setReturnedAsReader(boolean _on) {
            this.returnedAsReader = _on;
        }
    }

    protected static class BasicAuthRealm
    extends Hashtable {
        String name;

        BasicAuthRealm(String name) {
            this.name = name;
        }

        String name() {
            return this.name;
        }
    }

    public static class ServeConnection
    implements Runnable,
    HttpServletRequest,
    HttpServletResponse {
        private Socket socket;
        private Hashtable sslAttributes;
        private Serve serve;
        private ServletInputStream in;
        private ServletOutputStream out;
        private String scheme;
        public static final String WWWFORMURLENCODE = "application/x-www-form-urlencoded";
        public static final String TRANSFERENCODING = "transfer-encoding".toLowerCase();
        public static final String KEEPALIVE = "Keep-Alive".toLowerCase();
        public static final String CONTENT_ENCODING = "Content-Encoding".toLowerCase();
        public static final String CONNECTION = "Connection".toLowerCase();
        public static final String CHUNKED = "chunked";
        public static final String CONTENTLENGTH = "Content-Length".toLowerCase();
        public static final String CONTENTTYPE = "Content-Type".toLowerCase();
        public static final String SETCOOKIE = "Set-Cookie".toLowerCase();
        public static final String HOST = "Host".toLowerCase();
        public static final String COOKIE = "Cookie".toLowerCase();
        public static final String ACCEPT_LANGUAGE = "Accept-Language".toLowerCase();
        public static final String SESSION_COOKIE_NAME = "JSESSIONID";
        public static final String SESSION_URL_NAME = ";$sessionid$";
        private static final Map EMPTYHASHTABLE = new Hashtable();
        private String reqMethod;
        private String reqUriPath;
        private String reqUriPathUn;
        private String reqProtocol;
        private String charEncoding;
        private String remoteUser;
        private String authType;
        private boolean oneOne;
        private boolean reqMime;
        private Vector reqHeaderNames = new Vector();
        private Vector reqHeaderValues = new Vector();
        private Locale locale;
        private int uriLen;
        protected boolean keepAlive = true;
        protected int timesRequested;
        protected long lastRun;
        protected long lastWait;
        private Vector outCookies;
        private Vector inCookies;
        private String sessionCookieValue;
        private String sessionUrlValue;
        private String sessionValue;
        protected String reqQuery;
        private PrintWriter pw;
        private ServletOutputStream rout;
        private Map formParameters;
        private Hashtable attributes = new Hashtable();
        private int resCode = -1;
        private String resMessage;
        private Hashtable resHeaderNames = new Hashtable();
        private String[] postCache;
        private boolean headersWritten;
        private MessageFormat accessFmt;
        private Object[] logPlaceholders;
        private final SimpleDateFormat expdatefmt = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss 'GMT'", Locale.US);
        private final SimpleDateFormat rfc850DateFmt = new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss 'GMT'", Locale.US);
        private final SimpleDateFormat headerdateformat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        private final SimpleDateFormat asciiDateFmt = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy", Locale.US);
        private static final TimeZone tz = TimeZone.getTimeZone("GMT");
        private static final int MAYBEVERSION = 1;
        private static final int INVERSION = 2;
        private static final int OLD_INNAME = 3;
        private static final int OLD_INVAL = 4;
        private static final int INVERSIONNUM = 5;
        private static final int RECOVER = 6;
        private static final int NEW_INNAME = 7;
        private static final int NEW_INVAL = 8;
        private static final int INPATH = 9;
        private static final int MAYBEINPATH = 10;
        private static final int INPATHVALUE = 11;
        private static final int MAYBEPORT = 12;
        private static final int INDOMAIN = 13;
        private static final int MAYBEDOMAIN = 14;
        private static final int INPORT = 15;
        private static final int INDOMAINVALUE = 16;
        private static final int INPORTVALUE = 17;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ServeConnection(Socket socket, Serve serve) {
            this.socket = socket;
            this.serve = serve;
            this.expdatefmt.setTimeZone(tz);
            this.headerdateformat.setTimeZone(tz);
            this.rfc850DateFmt.setTimeZone(tz);
            this.asciiDateFmt.setTimeZone(tz);
            if (serve.isAccessLogged()) {
                this.accessFmt = new MessageFormat((String)serve.arguments.get(Serve.ARG_ACCESS_LOG_FMT));
                this.logPlaceholders = new Object[12];
            }
            serve.threadPool.executeThread(this);
            List<ServeConnection> list = serve.connections;
            synchronized (list) {
                serve.connections.add(this);
            }
        }

        private void initSSLAttrs() {
            if (this.socket.getClass().getName().indexOf("SSLSocket") > 0) {
                try {
                    this.sslAttributes = new Hashtable();
                    Object sslSession = this.socket.getClass().getMethod("getSession", Utils.EMPTY_CLASSES).invoke((Object)this.socket, Utils.EMPTY_OBJECTS);
                    if (sslSession != null) {
                        this.sslAttributes.put("javax.net.ssl.session", sslSession);
                        Method m = sslSession.getClass().getMethod("getCipherSuite", Utils.EMPTY_CLASSES);
                        m.setAccessible(true);
                        this.sslAttributes.put("javax.net.ssl.cipher_suite", m.invoke(sslSession, Utils.EMPTY_OBJECTS));
                        m = sslSession.getClass().getMethod("getPeerCertificates", Utils.EMPTY_CLASSES);
                        m.setAccessible(true);
                        this.sslAttributes.put("javax.net.ssl.peer_certificates", m.invoke(sslSession, Utils.EMPTY_OBJECTS));
                    }
                }
                catch (IllegalAccessException iae) {
                    this.sslAttributes = null;
                }
                catch (NoSuchMethodException nsme) {
                    this.sslAttributes = null;
                }
                catch (InvocationTargetException ite) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }

        public void closeStreams() throws IOException {
            IOException ioe = null;
            try {
                if (this.pw != null) {
                    this.pw.flush();
                } else {
                    this.out.flush();
                }
            }
            catch (IOException io1) {
                ioe = io1;
            }
            try {
                this.out.close();
            }
            catch (IOException io1) {
                ioe = ioe != null ? (IOException)ioe.initCause(io1) : io1;
            }
            try {
                this.in.close();
            }
            catch (IOException io1) {
                ioe = ioe != null ? (IOException)ioe.initCause(io1) : io1;
            }
            if (ioe != null) {
                throw ioe;
            }
        }

        public void closeSocket() {
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private void restart() {
            this.reqMethod = null;
            this.reqUriPathUn = null;
            this.reqUriPath = null;
            this.reqProtocol = null;
            this.charEncoding = null;
            this.remoteUser = null;
            this.authType = null;
            this.oneOne = false;
            this.reqMime = false;
            if (this.reqHeaderNames == null) {
                this.reqHeaderNames = new Vector();
            } else {
                this.reqHeaderNames.clear();
            }
            if (this.reqHeaderValues == null) {
                this.reqHeaderValues = new Vector();
            } else {
                this.reqHeaderValues.clear();
            }
            this.locale = null;
            this.uriLen = 0;
            this.outCookies = null;
            this.inCookies = null;
            this.sessionCookieValue = null;
            this.sessionUrlValue = null;
            this.sessionValue = null;
            this.reqQuery = null;
            this.pw = null;
            this.rout = null;
            this.formParameters = null;
            if (this.attributes == null) {
                this.attributes = new Hashtable();
            } else {
                this.attributes.clear();
            }
            if (this.sslAttributes != null) {
                this.attributes.putAll(this.sslAttributes);
            }
            this.resCode = -1;
            this.resMessage = null;
            this.resHeaderNames.clear();
            this.headersWritten = false;
            this.postCache = null;
            ((ServeInputStream)this.in).refresh();
            ((ServeOutputStream)this.out).refresh();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block36: {
                Object errMsg;
                try {
                    this.initSSLAttrs();
                    this.in = new ServeInputStream(this.socket.getInputStream(), this);
                    this.out = new ServeOutputStream(this.socket.getOutputStream(), this);
                    do {
                        this.restart();
                        this.parseRequest();
                        if (this.reqMethod != null && this.serve.isAccessLogged()) {
                            this.logPlaceholders[0] = this.socket.getInetAddress();
                            this.logPlaceholders[1] = "-";
                            this.logPlaceholders[2] = this.remoteUser == null ? "-" : this.remoteUser;
                            this.logPlaceholders[3] = new Date(this.lastRun);
                            this.logPlaceholders[4] = this.reqMethod;
                            this.logPlaceholders[5] = this.reqUriPathUn;
                            this.logPlaceholders[6] = this.reqProtocol;
                            this.logPlaceholders[7] = new Integer(this.resCode);
                            this.logPlaceholders[8] = new Long(((ServeOutputStream)this.out).lengthWritten());
                            this.logPlaceholders[9] = new Integer(this.socket.getLocalPort());
                            this.logPlaceholders[10] = this.serve.isShowReferer() ? this.getHeader("Referer") : "-";
                            this.logPlaceholders[11] = this.serve.isShowUserAgent() ? this.getHeader("User-Agent") : "-";
                            this.serve.logStream.println(this.accessFmt.format(this.logPlaceholders));
                        }
                        this.lastRun = 0L;
                        ++this.timesRequested;
                    } while (this.keepAlive && this.serve.isKeepAlive() && this.timesRequested < this.serve.getMaxTimesConnectionUse());
                }
                catch (IOException ioe) {
                    errMsg = ioe.getMessage();
                    if (!(errMsg != null && ((String)errMsg).indexOf("ocket closed") >= 0 || ioe instanceof AsynchronousCloseException)) {
                        this.serve.log("IO error: " + ioe + " in processing a request from " + this.socket.getInetAddress() + ":" + this.socket.getLocalPort() + " / " + this.socket.getClass().getName());
                        break block36;
                    }
                    ServeConnection serveConnection = this;
                    synchronized (serveConnection) {
                        this.socket = null;
                    }
                }
                finally {
                    ServeConnection serveConnection = this;
                    synchronized (serveConnection) {
                        errMsg = this.serve.connections;
                        synchronized (errMsg) {
                            this.serve.connections.remove(this);
                        }
                        if (this.socket != null) {
                            try {
                                this.socket.close();
                            }
                            catch (IOException iOException) {}
                        }
                        this.socket = null;
                    }
                }
            }
        }

        private void parseRequest() throws IOException {
            Object[] os;
            String contentEncoding;
            String host;
            byte[] lineBytes = new byte[4096];
            this.lastWait = System.currentTimeMillis();
            int len = this.in.readLine(lineBytes, 0, lineBytes.length);
            if (len == -1 || len == 0) {
                if (this.keepAlive) {
                    this.keepAlive = false;
                } else {
                    this.problem("Status-Code 400: Bad Request(empty)", 400);
                }
                return;
            }
            if (len >= lineBytes.length) {
                this.problem("Status-Code 414: Request-URI Too Long", 414);
                return;
            }
            String line = new String(lineBytes, 0, len, Serve.UTF8);
            StringTokenizer ust = new StringTokenizer(line);
            if (ust.hasMoreTokens()) {
                this.reqMethod = ust.nextToken();
                if (ust.hasMoreTokens()) {
                    this.reqUriPathUn = ust.nextToken();
                    int uop = this.reqUriPathUn.indexOf(SESSION_URL_NAME);
                    if (uop > 0) {
                        this.sessionUrlValue = this.reqUriPathUn.substring(uop + SESSION_URL_NAME.length());
                        this.reqUriPathUn = this.reqUriPathUn.substring(0, uop);
                        try {
                            this.serve.getSession(this.sessionUrlValue).userTouch();
                        }
                        catch (NullPointerException npe) {
                            this.sessionUrlValue = null;
                        }
                        catch (IllegalStateException ise) {
                            this.sessionUrlValue = null;
                        }
                    }
                    if (ust.hasMoreTokens()) {
                        String s;
                        this.reqProtocol = ust.nextToken();
                        this.oneOne = !this.reqProtocol.toUpperCase().equals("HTTP/1.0");
                        this.reqMime = true;
                        while ((s = ((ServeInputStream)this.in).readLine(0xA00000)) != null && s.length() != 0) {
                            int c = s.indexOf(58, 0);
                            if (c > 0) {
                                String key = s.substring(0, c).trim().toLowerCase();
                                String value = s.substring(c + 1).trim();
                                this.reqHeaderNames.addElement(key);
                                this.reqHeaderValues.addElement(value);
                                if (CONNECTION.equalsIgnoreCase(key)) {
                                    if (this.oneOne) {
                                        this.keepAlive = !"close".equalsIgnoreCase(value);
                                        continue;
                                    }
                                    this.keepAlive = KEEPALIVE.equalsIgnoreCase(value);
                                    continue;
                                }
                                if (!KEEPALIVE.equalsIgnoreCase(key)) continue;
                            }
                            this.serve.log("header field '" + s + "' without ':'");
                        }
                    } else {
                        this.reqProtocol = "HTTP/0.9";
                        this.oneOne = false;
                        this.reqMime = false;
                    }
                }
            }
            if (this.reqProtocol == null) {
                this.problem("Status-Code 400: Malformed request line:" + line, 400);
                return;
            }
            if (this.oneOne && (host = this.getHeader(HOST)) == null) {
                this.problem("'Host' header missing in HTTP/1.1 request", 400);
                return;
            }
            int qmark = this.reqUriPathUn.indexOf(63);
            if (qmark > -1) {
                if (qmark < this.reqUriPathUn.length() - 1) {
                    this.reqQuery = this.reqUriPathUn.substring(qmark + 1);
                }
                this.reqUriPathUn = this.reqUriPathUn.substring(0, qmark);
            }
            this.reqUriPath = Utils.decode(this.reqUriPathUn, Serve.UTF8);
            if (CHUNKED.equals(this.getHeader(TRANSFERENCODING))) {
                this.setHeader(CONTENTLENGTH, null);
                ((ServeInputStream)this.in).chunking(true);
            }
            this.setCharacterEncoding((contentEncoding = this.extractEncodingFromContentType(this.getHeader(CONTENTTYPE))) != null ? contentEncoding : Serve.UTF8);
            String contentLength = this.getHeader(CONTENTLENGTH);
            if (contentLength != null) {
                try {
                    ((ServeInputStream)this.in).setContentLength(Long.parseLong(contentLength));
                }
                catch (NumberFormatException nfe) {
                    this.serve.log("Invalid value of input content-length: " + contentLength);
                }
            }
            String encoding = this.getHeader(CONTENT_ENCODING);
            if (this.assureHeaders() && !this.socket.getKeepAlive()) {
                this.socket.setKeepAlive(true);
            }
            if ((os = this.serve.registry.get(this.reqUriPath))[0] != null) {
                this.lastRun = System.currentTimeMillis();
                this.uriLen = (Integer)os[1];
                this.runServlet((HttpServlet)os[0]);
            } else {
                this.problem("No any servlet found for serving " + this.reqUriPath, 400);
            }
        }

        private boolean assureHeaders() {
            if (this.reqMime) {
                this.setHeader("MIME-Version", "1.0");
            }
            this.setDateHeader("Date", System.currentTimeMillis());
            this.setHeader("Server", "D. Rogatkin's TJWS based on Acme.Serve/Version 1.70, $Revision: 1.194 $");
            if (this.keepAlive && this.serve.isKeepAlive()) {
                if (this.reqMime) {
                    this.setHeader(CONNECTION, KEEPALIVE);
                    if (this.oneOne) {
                        this.setHeader(KEEPALIVE, this.serve.getKeepAliveParamStr());
                    }
                }
                return true;
            }
            this.setHeader(CONNECTION, "close");
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runServlet(HttpServlet servlete) throws IOException {
            block20: {
                this.setStatus(200);
                try {
                    this.parseCookies();
                    if (this.sessionValue == null) {
                        this.sessionValue = this.sessionUrlValue;
                    }
                    if (!this.authenificate()) break block20;
                    if (servlete instanceof SingleThreadModel) {
                        HttpServlet httpServlet = servlete;
                        synchronized (httpServlet) {
                            servlete.service((ServletRequest)this, (ServletResponse)this);
                            break block20;
                        }
                    }
                    servlete.service((ServletRequest)this, (ServletResponse)this);
                }
                catch (UnavailableException e) {
                    if (e.isPermanent()) {
                        this.serve.registry.remove(servlete);
                        servlete.destroy();
                    } else if (e.getUnavailableSeconds() > 0) {
                        this.serve.log("Temporary unavailability feature is not supported " + servlete);
                    }
                    this.problem(e.getMessage(), 503);
                }
                catch (ServletException e) {
                    this.serve.log("Servlet exception", e);
                    Throwable rootCause = e.getRootCause();
                    while (rootCause != null) {
                        this.serve.log("Caused by", rootCause);
                        if (rootCause instanceof ServletException) {
                            rootCause = ((ServletException)rootCause).getRootCause();
                            continue;
                        }
                        rootCause = rootCause.getCause();
                    }
                    this.problem(e.toString(), 500);
                }
                catch (IOException ioe) {
                    throw ioe;
                }
                catch (Exception e) {
                    this.serve.log("Unexpected problem running servlet", e);
                    this.problem("Unexpected problem running servlet: " + e.toString(), 500);
                }
                finally {
                    this.closeStreams();
                }
            }
        }

        private boolean authenificate() throws IOException {
            Object[] o = this.serve.realms.get(this.reqUriPath);
            BasicAuthRealm realm = null;
            if (o != null) {
                realm = (BasicAuthRealm)o[0];
            }
            if (realm == null) {
                return true;
            }
            String credentials = this.getHeader("Authorization");
            if (credentials != null) {
                credentials = Utils.base64Decode(credentials.substring(credentials.indexOf(32) + 1), this.getCharacterEncoding());
                int i = credentials.indexOf(58);
                String user = credentials.substring(0, i);
                String password = credentials.substring(i + 1);
                this.remoteUser = user;
                this.authType = "BASIC";
                String realPassword = (String)realm.get(user);
                if (realPassword != null && realPassword.equals(password)) {
                    return true;
                }
            }
            this.setStatus(401);
            this.setHeader("WWW-Authenticate", "basic realm=\"" + realm.name() + '\"');
            this.realSendError();
            return false;
        }

        private void problem(String logMessage, int resCode) {
            this.serve.log(logMessage);
            try {
                this.sendError(resCode, logMessage);
            }
            catch (IllegalStateException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void parseCookies() throws IOException {
            String cookies;
            if (this.inCookies == null) {
                this.inCookies = new Vector();
            }
            if ((cookies = this.getHeader(COOKIE)) == null) {
                return;
            }
            try {
                String cookie_name = null;
                String cookie_value = null;
                String cookie_path = null;
                String cookie_domain = null;
                if (cookies.length() > 1228800) {
                    throw new IOException("Cookie string too long:" + cookies.length());
                }
                char[] cookiesChars = cookies.toCharArray();
                int state = 1;
                StringBuffer token = new StringBuffer(256);
                boolean quoted = false;
                block22: for (int i = 0; i < cookiesChars.length; ++i) {
                    char c = cookiesChars[i];
                    switch (state) {
                        case 1: {
                            if (c == ' ') continue block22;
                            token.append(c);
                            if (c == '$') {
                                state = 2;
                                continue block22;
                            }
                            state = 3;
                            continue block22;
                        }
                        case 3: {
                            if (c == '=') {
                                state = 4;
                                cookie_name = token.toString();
                                token.setLength(0);
                                continue block22;
                            }
                            if (c == ' ' && token.length() <= 0) continue block22;
                            token.append(c);
                            continue block22;
                        }
                        case 4: {
                            if (!quoted) {
                                if (c == ';') {
                                    state = 3;
                                    cookie_value = token.toString();
                                    token.setLength(0);
                                    this.addCookie(cookie_name, cookie_value, null, null);
                                    continue block22;
                                }
                                if (c == '\"' && token.length() == 0) {
                                    quoted = true;
                                    continue block22;
                                }
                                token.append(c);
                                continue block22;
                            }
                            if (c == '\"') {
                                quoted = false;
                                continue block22;
                            }
                            token.append(c);
                            continue block22;
                        }
                        case 2: {
                            if (c == '=') {
                                if ("$Version".equals(token.toString())) {
                                    state = 5;
                                } else {
                                    state = 4;
                                    cookie_name = token.toString();
                                }
                                token.setLength(0);
                                continue block22;
                            }
                            token.append(c);
                            continue block22;
                        }
                        case 5: {
                            if (c == ',' || c == ';') {
                                token.setLength(0);
                                state = 7;
                                continue block22;
                            }
                            if (!Character.isDigit(c)) {
                                state = 6;
                                continue block22;
                            }
                            token.append(c);
                            continue block22;
                        }
                        case 7: {
                            if (c == '=') {
                                state = 8;
                                cookie_name = token.toString();
                                token.setLength(0);
                                continue block22;
                            }
                            if (c == ' ' && token.length() <= 0) continue block22;
                            token.append(c);
                            continue block22;
                        }
                        case 8: {
                            if (c == ';') {
                                state = 10;
                                cookie_value = token.toString();
                                token.setLength(0);
                                cookie_path = null;
                                continue block22;
                            }
                            if (c == ',') {
                                state = 7;
                                cookie_value = token.toString();
                                token.setLength(0);
                                this.addCookie(cookie_name, cookie_value, null, null);
                                continue block22;
                            }
                            token.append(c);
                            continue block22;
                        }
                        case 10: {
                            if (c == ' ') continue block22;
                            token.append(c);
                            if (c == '$') {
                                state = 9;
                                continue block22;
                            }
                            this.addCookie(cookie_name, cookie_value, null, null);
                            state = 7;
                            continue block22;
                        }
                        case 9: {
                            if (c == '=') {
                                if ("$Path".equals(token.toString())) {
                                    state = 11;
                                } else {
                                    this.addCookie(cookie_name, cookie_value, null, null);
                                    state = 8;
                                    cookie_name = token.toString();
                                }
                                token.setLength(0);
                                continue block22;
                            }
                            token.append(c);
                            continue block22;
                        }
                        case 11: {
                            if (c == ',') {
                                cookie_path = token.toString();
                                state = 7;
                                this.addCookie(cookie_name, cookie_value, cookie_path, null);
                                token.setLength(0);
                                continue block22;
                            }
                            if (c == ';') {
                                state = 14;
                                cookie_path = token.toString();
                                token.setLength(0);
                                continue block22;
                            }
                            token.append(c);
                            continue block22;
                        }
                        case 14: {
                            if (c == ' ') continue block22;
                            token.append(c);
                            if (c == '$') {
                                state = 13;
                                continue block22;
                            }
                            this.addCookie(cookie_name, cookie_value, cookie_path, null);
                            state = 7;
                            continue block22;
                        }
                        case 13: {
                            if (c != '=') continue block22;
                            if ("$Domain".equals(token.toString())) {
                                state = 16;
                            } else {
                                this.addCookie(cookie_name, cookie_value, cookie_path, null);
                                state = 8;
                                cookie_name = token.toString();
                            }
                            token.setLength(0);
                            continue block22;
                        }
                        case 16: {
                            if (c == ',') {
                                state = 7;
                                this.addCookie(cookie_name, cookie_value, cookie_path, token.toString());
                                token.setLength(0);
                                continue block22;
                            }
                            if (c == ';') {
                                cookie_domain = token.toString();
                                state = 12;
                                continue block22;
                            }
                            token.append(c);
                            continue block22;
                        }
                        case 12: {
                            if (c == ' ') continue block22;
                            token.append(c);
                            if (c == '$') {
                                state = 15;
                                continue block22;
                            }
                            this.addCookie(cookie_name, cookie_value, cookie_path, cookie_domain);
                            state = 7;
                            continue block22;
                        }
                        case 15: {
                            if (c != '=') continue block22;
                            if ("$Port".equals(token.toString())) {
                                state = 17;
                            } else {
                                this.addCookie(cookie_name, cookie_value, cookie_path, cookie_domain);
                                state = 8;
                                cookie_name = token.toString();
                            }
                            token.setLength(0);
                            continue block22;
                        }
                        case 17: {
                            if (c == ',' || c == ';') {
                                int port = Integer.parseInt(token.toString());
                                state = 7;
                                this.addCookie(cookie_name, cookie_value, cookie_path, cookie_domain);
                                token.setLength(0);
                                continue block22;
                            }
                            if (!Character.isDigit(c)) {
                                state = 6;
                                continue block22;
                            }
                            token.append(c);
                            continue block22;
                        }
                        case 6: {
                            this.serve.log("Parsing recover of cookie string " + cookies, null);
                            if (c != ';' && c != ',') continue block22;
                            token.setLength(0);
                            state = 7;
                        }
                    }
                }
                if (state == 4 || state == 8) {
                    cookie_value = token.toString();
                    this.addCookie(cookie_name, cookie_value, null, null);
                } else if (state == 11) {
                    this.addCookie(cookie_name, cookie_value, token.toString(), null);
                } else if (state == 16) {
                    this.addCookie(cookie_name, cookie_value, cookie_path, token.toString());
                } else if (state == 17) {
                    this.addCookie(cookie_name, cookie_value, cookie_path, cookie_domain);
                }
            }
            catch (Error e) {
                this.serve.log("Error in parsing cookies: " + cookies, e);
            }
            catch (Exception e) {
                this.serve.log("An exception in parsing cookies: " + cookies, e);
            }
        }

        private void addCookie(String name, String value, String path, String domain) {
            if (SESSION_COOKIE_NAME.equals(name) && this.sessionCookieValue == null) {
                this.sessionCookieValue = value;
                try {
                    this.serve.getSession(this.sessionCookieValue).userTouch();
                    this.sessionValue = this.sessionCookieValue;
                    this.sessionUrlValue = null;
                }
                catch (IllegalStateException ise) {
                    this.sessionCookieValue = null;
                }
                catch (NullPointerException npe) {
                    this.sessionCookieValue = null;
                }
            } else {
                Cookie c = new Cookie(name, value);
                this.inCookies.addElement(c);
                if (path != null) {
                    c.setPath(path);
                    if (domain != null) {
                        c.setDomain(domain);
                    }
                }
            }
        }

        public int getContentLength() {
            return this.getIntHeader(CONTENTLENGTH);
        }

        public String getContentType() {
            return this.getHeader(CONTENTTYPE);
        }

        public String getProtocol() {
            return this.reqProtocol;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getScheme() {
            if (this.scheme == null) {
                ServeConnection serveConnection = this;
                synchronized (serveConnection) {
                    if (this.scheme == null) {
                        this.scheme = this.socket.getClass().getName().indexOf("SSLSocket") > 0 ? "https" : "http";
                    }
                }
            }
            return this.scheme;
        }

        public String getServerName() {
            int slash;
            int colon;
            String serverName = this.getHeader(HOST);
            if (serverName != null && serverName.length() > 0 && (colon = serverName.indexOf(58)) >= 0 && colon < serverName.length()) {
                serverName = serverName.substring(0, colon);
            }
            if (serverName == null) {
                try {
                    serverName = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException ignore) {
                    serverName = "127.0.0.0";
                }
            }
            if ((slash = serverName.indexOf("/")) >= 0) {
                serverName = serverName.substring(slash + 1);
            }
            return serverName;
        }

        public int getServerPort() {
            return this.socket.getLocalPort();
        }

        public String getRemoteAddr() {
            return this.socket.getInetAddress().getHostAddress();
        }

        public String getRemoteHost() {
            String result = this.socket.getInetAddress().getHostName();
            return result != null ? result : this.getRemoteAddr();
        }

        public String getRealPath(String path) {
            return this.serve.getRealPath(path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ServletInputStream getInputStream() throws IOException {
            ServletInputStream servletInputStream = this.in;
            synchronized (servletInputStream) {
                if (((ServeInputStream)this.in).isReturnedAsReader()) {
                    throw new IllegalStateException("Already returned as a reader.");
                }
                ((ServeInputStream)this.in).setReturnedAsStream(true);
            }
            return this.in;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BufferedReader getReader() {
            ServletInputStream servletInputStream = this.in;
            synchronized (servletInputStream) {
                if (((ServeInputStream)this.in).isReturnedAsStream()) {
                    throw new IllegalStateException("Already returned as a stream.");
                }
                ((ServeInputStream)this.in).setReturnedAsReader(true);
            }
            if (this.charEncoding != null) {
                try {
                    return new BufferedReader(new InputStreamReader((InputStream)this.in, this.charEncoding));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            return new BufferedReader(new InputStreamReader((InputStream)this.in));
        }

        private synchronized Map getParametersFromRequest() {
            Map result = null;
            if ("GET".equals(this.reqMethod)) {
                if (this.reqQuery != null) {
                    try {
                        result = Utils.parseQueryString(this.reqQuery, this.charEncoding);
                    }
                    catch (IllegalArgumentException ex) {
                        this.serve.log("Exception " + ex + " at parsing 'get' data " + this.reqQuery);
                    }
                }
            } else if ("POST".equals(this.reqMethod)) {
                String contentType = this.getContentType();
                if (contentType != null && WWWFORMURLENCODE.regionMatches(true, 0, contentType, 0, WWWFORMURLENCODE.length())) {
                    if (this.postCache == null) {
                        this.postCache = new String[1];
                        ServletInputStream is = null;
                        try {
                            is = this.getInputStream();
                            result = Utils.parsePostData(this.getContentLength(), (InputStream)is, this.charEncoding, this.postCache);
                        }
                        catch (Exception ex) {
                            this.serve.log("Exception " + ex + " at parsing 'POST' data of length " + this.getContentLength());
                            return EMPTYHASHTABLE;
                        }
                    } else {
                        result = Utils.parseQueryString(this.postCache[0], this.charEncoding);
                    }
                    if (this.reqQuery != null && this.reqQuery.length() > 0) {
                        result.putAll(Utils.parseQueryString(this.reqQuery, this.charEncoding));
                    }
                } else if (this.reqQuery != null) {
                    result = Utils.parseQueryString(this.reqQuery, this.charEncoding);
                }
            }
            return result != null ? result : EMPTYHASHTABLE;
        }

        public synchronized Enumeration getParameterNames() {
            if (this.formParameters == null) {
                this.formParameters = this.getParametersFromRequest();
            }
            return ((Hashtable)this.formParameters).keys();
        }

        public String getParameter(String name) {
            String[] params = this.getParameterValues(name);
            if (params == null || params.length == 0) {
                return null;
            }
            return params[0];
        }

        public synchronized String[] getParameterValues(String name) {
            if (this.formParameters == null) {
                this.getParameterNames();
            }
            return (String[])this.formParameters.get(name);
        }

        public Object getAttribute(String name) {
            return this.attributes.get(name);
        }

        public Cookie[] getCookies() {
            Object[] cookieArray = new Cookie[this.inCookies.size()];
            this.inCookies.copyInto(cookieArray);
            return cookieArray;
        }

        public String getMethod() {
            return this.reqMethod;
        }

        public String getRequestURI() {
            return this.reqUriPathUn;
        }

        public StringBuffer getRequestURL() {
            int port = this.getServerPort();
            return new StringBuffer().append(this.getScheme()).append("://").append(this.getServerName()).append("https".equals(this.getScheme()) && port == 443 || port == 80 ? "" : ":" + String.valueOf(port)).append(this.getRequestURI());
        }

        public String getServletPath() {
            return this.uriLen > 0 ? this.reqUriPath.substring(0, this.uriLen) : "";
        }

        public String getPathInfo() {
            return this.uriLen >= this.reqUriPath.length() ? null : this.reqUriPath.substring(this.uriLen);
        }

        public String getPathTranslated() {
            return this.getRealPath(this.getPathInfo());
        }

        public String getQueryString() {
            return this.reqQuery;
        }

        public String getRemoteUser() {
            return this.remoteUser;
        }

        public String getAuthType() {
            return this.authType;
        }

        public String getHeader(String name) {
            int i = this.reqHeaderNames.indexOf(name.toLowerCase());
            if (i == -1) {
                return null;
            }
            return (String)this.reqHeaderValues.elementAt(i);
        }

        public int getIntHeader(String name) {
            String val = this.getHeader(name);
            if (val == null) {
                return -1;
            }
            return Integer.parseInt(val);
        }

        public long getDateHeader(String name) {
            String val = this.getHeader(name);
            if (val == null) {
                return -1L;
            }
            try {
                return this.headerdateformat.parse(val).getTime();
            }
            catch (ParseException pe) {
                try {
                    return this.rfc850DateFmt.parse(val).getTime();
                }
                catch (ParseException pe1) {
                    try {
                        return this.asciiDateFmt.parse(val).getTime();
                    }
                    catch (ParseException pe3) {
                        throw new IllegalArgumentException("Value " + val + " can't be converted to Date using any of formats: [" + this.headerdateformat.toPattern() + "][ " + this.rfc850DateFmt.toPattern() + "][" + this.asciiDateFmt.toPattern());
                    }
                }
            }
        }

        public Enumeration getHeaderNames() {
            return this.reqHeaderNames.elements();
        }

        public synchronized HttpSession getSession(boolean create) {
            AcmeSession result = null;
            if (this.sessionValue != null && (result = this.serve.getSession(this.sessionValue)) != null && !result.isValid()) {
                this.serve.removeSession(this.sessionValue);
                result = null;
            }
            if (result == null && create) {
                result = this.serve.createSession();
                if (result != null) {
                    this.sessionValue = result.getId();
                } else {
                    throw new RuntimeException("A session can't be created");
                }
            }
            return result;
        }

        public HttpSession getSession() {
            return this.getSession(true);
        }

        public boolean isRequestedSessionIdFromURL() {
            return this.isRequestedSessionIdFromUrl();
        }

        public Enumeration getAttributeNames() {
            return this.attributes.keys();
        }

        public void setAttribute(String key, Object o) {
            if (o != null) {
                this.attributes.put(key, o);
            } else {
                this.attributes.remove(key);
            }
        }

        public String getRequestedSessionId() {
            return this.sessionValue;
        }

        public boolean isRequestedSessionIdValid() {
            if (this.sessionValue != null) {
                AcmeSession session = this.serve.getSession(this.sessionValue);
                return session != null && session.isValid();
            }
            return false;
        }

        public boolean isRequestedSessionIdFromCookie() {
            return this.sessionCookieValue != null;
        }

        public boolean isRequestedSessionIdFromUrl() {
            return this.sessionUrlValue != null;
        }

        public void setContentLength(int length) {
            if (length >= 0) {
                this.setIntHeader(CONTENTLENGTH, length);
            } else {
                this.setHeader(CONTENTLENGTH, null);
            }
        }

        public void setContentType(String type) {
            this.setHeader(CONTENTTYPE, type != null ? type : "Unknown");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ServletOutputStream getOutputStream() {
            ServletOutputStream servletOutputStream = this.out;
            synchronized (servletOutputStream) {
                if (this.rout == null) {
                    if (this.pw != null) {
                        throw new IllegalStateException("Already returned as a writer");
                    }
                    this.rout = this.out;
                }
            }
            return this.rout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PrintWriter getWriter() throws IOException {
            ServletOutputStream servletOutputStream = this.out;
            synchronized (servletOutputStream) {
                if (this.pw == null) {
                    if (this.rout != null) {
                        throw new IllegalStateException("Already was returned as servlet output stream");
                    }
                    String encoding = this.getCharacterEncoding();
                    this.pw = encoding != null ? new PrintWriter(new OutputStreamWriter((OutputStream)this.out, encoding)) : new PrintWriter((OutputStream)this.out);
                }
            }
            return this.pw;
        }

        public String getCharacterEncoding() {
            String enc;
            String ct = (String)this.resHeaderNames.get(CONTENTTYPE.toLowerCase());
            if (ct != null && (enc = this.extractEncodingFromContentType(ct)) != null) {
                return enc;
            }
            return this.charEncoding;
        }

        private String extractEncodingFromContentType(String ct) {
            if (ct == null) {
                return null;
            }
            int scp = ct.indexOf(59);
            if (scp > 0 && (scp = ct.toLowerCase().indexOf("charset=", scp)) >= 0) {
                int l;
                if ((scp = (ct = ct.substring(scp + "charset=".length()).trim()).indexOf(59)) > 0) {
                    ct = ct.substring(0, scp);
                }
                if ((l = ct.length()) > 2 && ct.charAt(0) == '\"') {
                    return ct.substring(1, l - 1);
                }
                return ct;
            }
            return null;
        }

        public void flushBuffer() throws IOException {
            ((ServeOutputStream)this.out).flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetBuffer() {
            ((ServeOutputStream)this.out).reset();
            ServeConnection serveConnection = this;
            synchronized (serveConnection) {
                this.headersWritten = false;
            }
        }

        public int getBufferSize() {
            return ((ServeOutputStream)this.out).getBufferSize();
        }

        public void setBufferSize(int size) {
            ((ServeOutputStream)this.out).setBufferSize(size);
        }

        public boolean isCommitted() {
            return this.headersWritten && ((ServeOutputStream)this.out).lengthWritten() > 0L;
        }

        public void reset() throws IllegalStateException {
            if (!this.isCommitted()) {
                if (this.outCookies != null) {
                    this.outCookies.clear();
                }
            } else {
                throw new IllegalStateException("Header have already been committed.");
            }
            this.resHeaderNames.clear();
            this.pw = null;
            this.rout = null;
            ((ServeOutputStream)this.out).reset();
            this.assureHeaders();
        }

        public void setLocale(Locale locale) {
            this.locale = locale;
        }

        public Locale getLocale() {
            if (this.locale != null) {
                return this.locale;
            }
            Enumeration e = this.getLocales();
            if (e.hasMoreElements()) {
                return (Locale)e.nextElement();
            }
            return Locale.getDefault();
        }

        public Enumeration getLocales() {
            String al = this.getHeader(ACCEPT_LANGUAGE);
            TreeSet<LocaleWithWeight> ts = new TreeSet<LocaleWithWeight>();
            if (al != null) {
                StringTokenizer st = new StringTokenizer(al, ";", false);
                try {
                    while (st.hasMoreTokens()) {
                        String langs = st.nextToken(";");
                        String q = st.nextToken(";=");
                        q = st.nextToken("=,");
                        float w = 0.0f;
                        try {
                            w = Float.valueOf(q).floatValue();
                        }
                        catch (NumberFormatException nfe) {
                            // empty catch block
                        }
                        if (!(w > 0.0f)) continue;
                        StringTokenizer lst = new StringTokenizer(langs, ", ", false);
                        while (lst.hasMoreTokens()) {
                            String lan = lst.nextToken();
                            int di = lan.indexOf(45);
                            if (di < 0) {
                                ts.add(new LocaleWithWeight(new Locale(lan.trim()), w));
                                continue;
                            }
                            ts.add(new LocaleWithWeight(new Locale(lan.substring(0, di), lan.substring(di + 1).trim().toUpperCase()), w));
                        }
                    }
                }
                catch (NoSuchElementException ncee) {
                    // empty catch block
                }
            }
            if (ts.size() == 0) {
                ts.add(new LocaleWithWeight(Locale.getDefault(), 1.0f));
            }
            return new AcceptLocaleEnumeration(ts);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setCharacterEncoding(String _enc) {
            this.charEncoding = _enc;
            ServeConnection serveConnection = this;
            synchronized (serveConnection) {
                this.formParameters = null;
            }
        }

        public void addDateHeader(String header, long date) {
            this.addHeader(header, this.headerdateformat.format(new Date(date)));
        }

        public void addHeader(String header, String value) {
            Object o = this.resHeaderNames.get(header = header.trim().toLowerCase());
            if (o == null) {
                this.setHeader(header, value);
            } else if (o instanceof String[]) {
                String[] oldVal = (String[])o;
                String[] newVal = new String[oldVal.length + 1];
                System.arraycopy(oldVal, 0, newVal, 0, oldVal.length);
                newVal[oldVal.length] = value;
                this.resHeaderNames.put(header, newVal);
            } else if (o instanceof String) {
                String[] newVal = new String[]{(String)o, value};
                this.resHeaderNames.put(header, newVal);
            } else {
                throw new RuntimeException("Invalid content of header hash - " + o.getClass().getName());
            }
        }

        public void addIntHeader(String header, int value) {
            this.addHeader(header, Integer.toString(value));
        }

        public RequestDispatcher getRequestDispatcher(String urlpath) {
            if (urlpath.length() > 0 && urlpath.charAt(0) != '/') {
                String dispatchPath = this.getContextPath();
                String pathInfo = this.getPathInfo();
                String servletPath = this.getServletPath();
                if (pathInfo != null) {
                    dispatchPath = dispatchPath + servletPath;
                    int slp = pathInfo.indexOf(47, 1);
                    if (slp > 0) {
                        dispatchPath = dispatchPath + pathInfo.substring(0, slp - 1);
                    }
                } else {
                    int spsp = servletPath.lastIndexOf(47);
                    if (spsp >= 0) {
                        dispatchPath = dispatchPath + servletPath.substring(0, spsp);
                    }
                }
                urlpath = dispatchPath + '/' + urlpath;
            }
            return this.serve.getRequestDispatcher(urlpath);
        }

        public boolean isSecure() {
            return "https".equals(this.getScheme());
        }

        public void removeAttribute(String name) {
            this.attributes.remove(name);
        }

        public String getContextPath() {
            return "";
        }

        public Enumeration getHeaders(String header) {
            Vector result = new Vector();
            int i = -1;
            while ((i = this.reqHeaderNames.indexOf(header.toLowerCase(), i + 1)) >= 0) {
                result.addElement(this.reqHeaderValues.elementAt(i));
            }
            return result.elements();
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public boolean isUserInRole(String user) {
            return false;
        }

        public synchronized Map getParameterMap() {
            if (this.formParameters == null) {
                this.getParameterNames();
            }
            return this.formParameters;
        }

        public void addCookie(Cookie cookie) {
            if (this.outCookies == null) {
                this.outCookies = new Vector();
            }
            this.outCookies.addElement(cookie);
        }

        public boolean containsHeader(String name) {
            return this.resHeaderNames.contains(name);
        }

        public String encodeURL(String url) {
            int uop = url.indexOf(SESSION_URL_NAME);
            if (uop > 0) {
                url = url.substring(0, uop);
            }
            if (this.sessionValue == null || this.isRequestedSessionIdFromCookie()) {
                return url;
            }
            try {
                new URL(url);
                int ehp = url.indexOf(47);
                if (ehp < 0) {
                    ehp = url.indexOf(63);
                }
                if (ehp < 0) {
                    ehp = url.indexOf(35);
                }
                if (ehp < 0) {
                    ehp = url.length();
                }
                if (!url.regionMatches(true, 0, this.getRequestURL().toString(), 0, ehp)) {
                    return url;
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            return url + SESSION_URL_NAME + this.sessionValue;
        }

        public String encodeRedirectURL(String url) {
            return this.encodeURL(url);
        }

        public int getRemotePort() {
            return this.socket.getPort();
        }

        public String getLocalName() {
            InetAddress ia = this.socket.getLocalAddress();
            return ia == null ? null : ia.getHostAddress();
        }

        public String getLocalAddr() {
            InetAddress ia = this.socket.getLocalAddress();
            return ia == null ? null : ia.getCanonicalHostName();
        }

        public int getLocalPort() {
            return this.getServerPort();
        }

        public void setStatus(int resCode, String resMessage) {
            this.resCode = resCode;
            this.resMessage = resMessage;
        }

        public void setStatus(int resCode) {
            switch (resCode) {
                case 100: {
                    this.setStatus(resCode, "Continue");
                    break;
                }
                case 101: {
                    this.setStatus(resCode, "Switching protocols");
                    break;
                }
                case 200: {
                    this.setStatus(resCode, "Ok");
                    break;
                }
                case 201: {
                    this.setStatus(resCode, "Created");
                    break;
                }
                case 202: {
                    this.setStatus(resCode, "Accepted");
                    break;
                }
                case 203: {
                    this.setStatus(resCode, "Non-authoritative");
                    break;
                }
                case 204: {
                    this.setStatus(resCode, "No content");
                    break;
                }
                case 205: {
                    this.setStatus(resCode, "Reset content");
                    break;
                }
                case 206: {
                    this.setStatus(resCode, "Partial content");
                    break;
                }
                case 300: {
                    this.setStatus(resCode, "Multiple choices");
                    break;
                }
                case 301: {
                    this.setStatus(resCode, "Moved permanentently");
                    break;
                }
                case 302: {
                    this.setStatus(resCode, "Moved temporarily");
                    break;
                }
                case 303: {
                    this.setStatus(resCode, "See other");
                    break;
                }
                case 304: {
                    this.setStatus(resCode, "Not modified");
                    break;
                }
                case 305: {
                    this.setStatus(resCode, "Use proxy");
                    break;
                }
                case 400: {
                    this.setStatus(resCode, "Bad request");
                    break;
                }
                case 401: {
                    this.setStatus(resCode, "Unauthorized");
                    break;
                }
                case 402: {
                    this.setStatus(resCode, "Payment required");
                    break;
                }
                case 403: {
                    this.setStatus(resCode, "Forbidden");
                    break;
                }
                case 404: {
                    this.setStatus(resCode, "Not found");
                    break;
                }
                case 405: {
                    this.setStatus(resCode, "Method not allowed");
                    break;
                }
                case 406: {
                    this.setStatus(resCode, "Not acceptable");
                    break;
                }
                case 407: {
                    this.setStatus(resCode, "Proxy auth required");
                    break;
                }
                case 408: {
                    this.setStatus(resCode, "Request timeout");
                    break;
                }
                case 409: {
                    this.setStatus(resCode, "Conflict");
                    break;
                }
                case 410: {
                    this.setStatus(resCode, "Gone");
                    break;
                }
                case 411: {
                    this.setStatus(resCode, "Length required");
                    break;
                }
                case 412: {
                    this.setStatus(resCode, "Precondition failed");
                    break;
                }
                case 413: {
                    this.setStatus(resCode, "Request entity too large");
                    break;
                }
                case 414: {
                    this.setStatus(resCode, "Request URI too long");
                    break;
                }
                case 415: {
                    this.setStatus(resCode, "Unsupported media type");
                    break;
                }
                case 500: {
                    this.setStatus(resCode, "Internal server error");
                    break;
                }
                case 501: {
                    this.setStatus(resCode, "Not implemented");
                    break;
                }
                case 502: {
                    this.setStatus(resCode, "Bad gateway");
                    break;
                }
                case 503: {
                    this.setStatus(resCode, "Service unavailable");
                    break;
                }
                case 504: {
                    this.setStatus(resCode, "Gateway timeout");
                    break;
                }
                case 505: {
                    this.setStatus(resCode, "HTTP version not supported");
                    break;
                }
                case 207: {
                    this.setStatus(resCode, "Multi Status");
                    break;
                }
                default: {
                    this.setStatus(resCode, "");
                }
            }
        }

        public void setHeader(String header, String value) {
            header = header.trim().toLowerCase();
            if (value == null) {
                this.resHeaderNames.remove(header);
            } else {
                this.resHeaderNames.put(header, value);
            }
        }

        public void setIntHeader(String header, int value) {
            this.setHeader(header, Integer.toString(value));
        }

        public void setLongHeader(String header, long value) {
            this.setHeader(header, Long.toString(value));
        }

        public void setDateHeader(String header, long value) {
            this.setHeader(header, this.headerdateformat.format(new Date(value)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeHeaders() throws IOException {
            ServeConnection serveConnection = this;
            synchronized (serveConnection) {
                if (this.headersWritten) {
                    return;
                }
                this.headersWritten = true;
            }
            if (this.reqMime) {
                AcmeSession session;
                boolean chunked_out = false;
                boolean wasContentLen = false;
                if (this.resMessage.length() < 256) {
                    this.out.println(this.reqProtocol + " " + this.resCode + " " + this.resMessage.replace('\r', '/').replace('\n', '/'));
                } else {
                    this.out.println(this.reqProtocol + " " + this.resCode + " " + this.resMessage.substring(0, 255).replace('\r', '/').replace('\n', '/'));
                }
                Enumeration he = this.resHeaderNames.keys();
                while (he.hasMoreElements()) {
                    String name = (String)he.nextElement();
                    Object o = this.resHeaderNames.get(name);
                    if (o instanceof String) {
                        String value = (String)o;
                        if (value == null) continue;
                        this.out.println(name + ": " + value);
                        if (!wasContentLen && CONTENTLENGTH.equals(name)) {
                            try {
                                wasContentLen = Long.parseLong(value) > 0L;
                            }
                            catch (NumberFormatException nfe) {
                                // empty catch block
                            }
                        }
                        if (chunked_out || !TRANSFERENCODING.equals(name) || !CHUNKED.equals(value)) continue;
                        chunked_out = true;
                        continue;
                    }
                    if (!(o instanceof String[])) continue;
                    String[] values = (String[])o;
                    this.out.print(name + ": " + values[0]);
                    for (int i = 1; i < values.length; ++i) {
                        this.out.print("," + values[i]);
                    }
                    this.out.println();
                }
                StringBuffer sb = null;
                StringBuffer sb2 = null;
                Cookie cc = null;
                if (this.sessionValue != null && (session = this.serve.getSession(this.sessionValue)) != null) {
                    if (session.isValid()) {
                        if (session.isNew()) {
                            cc = new Cookie(SESSION_COOKIE_NAME, this.sessionValue);
                            if (this.serve.expiredIn < 0) {
                                cc.setMaxAge(Math.abs(this.serve.expiredIn) * 60);
                            }
                            ServletContext sc = session.getServletContext();
                            try {
                                String cp = (String)sc.getClass().getMethod("getContextPath", Utils.EMPTY_CLASSES).invoke((Object)sc, Utils.EMPTY_OBJECTS);
                                if (cp.length() == 0) {
                                    cp = "/";
                                }
                                cc.setPath(cp);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            this.addCookie(cc);
                        }
                    } else {
                        cc = new Cookie(SESSION_COOKIE_NAME, "");
                        cc.setMaxAge(0);
                        this.addCookie(cc);
                    }
                }
                for (int i = 0; this.outCookies != null && i < this.outCookies.size(); ++i) {
                    cc = (Cookie)this.outCookies.elementAt(i);
                    if (cc.getSecure() && !this.isSecure()) continue;
                    int version = cc.getVersion();
                    if (version > 1) {
                        if (sb2 == null) {
                            sb2 = new StringBuffer(SETCOOKIE + "2: ");
                        } else {
                            sb2.append(',');
                        }
                        sb2.append(cc.getName());
                        sb2.append("=\"");
                        sb2.append(cc.getValue()).append('\"');
                        String token = cc.getComment();
                        if (token != null) {
                            sb2.append("; Comment=\"").append(token).append('\"');
                        }
                        if ((token = cc.getDomain()) != null) {
                            sb2.append("; Domain=\"").append(token).append('\"');
                        }
                        if (cc.getMaxAge() >= 0) {
                            sb2.append("; Max-Age=\"").append(cc.getMaxAge()).append('\"');
                        }
                        if ((token = cc.getPath()) != null) {
                            sb2.append("; Path=\"").append(token).append('\"');
                        }
                        if (cc.getSecure()) {
                            sb2.append("; Secure");
                        }
                        sb2.append("; Version=\"").append(version).append('\"');
                        continue;
                    }
                    if (sb == null) {
                        sb = new StringBuffer(SETCOOKIE + ": ");
                    } else {
                        sb.append("\r\n" + SETCOOKIE + ": ");
                    }
                    sb.append(cc.getName());
                    sb.append('=');
                    sb.append(cc.getValue());
                    if (cc.getDomain() != null && cc.getDomain().length() > 0) {
                        sb.append("; domain=" + cc.getDomain());
                    }
                    if (cc.getMaxAge() >= 0) {
                        sb.append("; expires=");
                        sb.append(this.expdatefmt.format(new Date(new Date().getTime() + 1000L * (long)cc.getMaxAge())));
                    }
                    if (cc.getPath() != null && cc.getPath().length() > 0) {
                        sb.append("; path=" + cc.getPath());
                    }
                    if (!cc.getSecure()) continue;
                    sb.append("; secure");
                }
                if (sb != null) {
                    this.out.println(sb.toString());
                }
                if (sb2 != null) {
                    this.out.println(sb2.toString());
                }
                if (this.containsBody() && !wasContentLen && !chunked_out && this.serve.isKeepAlive()) {
                    this.out.println(TRANSFERENCODING + ": " + CHUNKED);
                    chunked_out = true;
                }
                this.out.println();
                this.out.flush();
                ((ServeOutputStream)this.out).setChunked(chunked_out);
            }
        }

        private boolean containsBody() {
            return !"HEAD".equalsIgnoreCase(this.reqMethod) && (100 > this.resCode || this.resCode >= 200) && this.resCode != 204 && this.resCode != 304;
        }

        public void sendError(int resCode, String resMessage) throws IOException {
            this.setStatus(resCode, resMessage);
            this.realSendError();
        }

        public void sendError(int resCode) throws IOException {
            this.setStatus(resCode);
            this.realSendError();
        }

        public void setInInclude(boolean set) {
            ((ServeOutputStream)this.out).setInInclude(set);
        }

        private void realSendError() throws IOException {
            if (this.isCommitted()) {
                throw new IllegalStateException("Can not send an error, headers have been already written");
            }
            this.setContentType("text/html");
            StringBuffer sb = new StringBuffer(100);
            int lsp = this.resMessage.indexOf(10);
            sb.append("<HTML><HEAD>").append("<TITLE>" + this.resCode + " " + (lsp < 0 ? this.resMessage : this.resMessage.substring(0, lsp)) + "</TITLE>").append("</HEAD><BODY BGCOLOR=\"#D1E9FE\"").append("><H2>" + this.resCode + " " + (lsp < 0 ? this.resMessage : this.resMessage.substring(0, lsp)) + "</H2>");
            if (lsp > 0) {
                sb.append("<PRE>").append(Utils.htmlEncode(this.resMessage.substring(lsp), false)).append("</PRE>");
            }
            sb.append("<HR>");
            sb.append("<ADDRESS><A HREF=\"http://tjws.sourceforge.net\">D. Rogatkin's TJWS based on Acme.Serve Version 1.70, $Revision: 1.194 $</A></ADDRESS>");
            sb.append("</BODY></HTML>");
            this.setContentLength(sb.length());
            this.out.print(sb.toString());
            this.closeStreams();
        }

        public void sendRedirect(String location) throws IOException {
            if (this.isCommitted()) {
                throw new IllegalStateException("Can not redirect, headers have been already written");
            }
            if (location.indexOf(":/") < 0) {
                String portString = "";
                if ("https".equalsIgnoreCase(this.getScheme())) {
                    if (this.getServerPort() != 443) {
                        portString = ":" + this.getServerPort();
                    }
                } else if (this.getServerPort() != 80) {
                    portString = ":" + this.getServerPort();
                }
                if (location.length() > 0 && location.charAt(0) == '/') {
                    location = this.getScheme() + "://" + this.getServerName() + portString + location;
                } else {
                    String uri;
                    int sp = this.reqUriPathUn.lastIndexOf(47);
                    if (sp < 0) {
                        uri = this.reqUriPathUn + '/';
                        sp = uri.length();
                    } else {
                        uri = this.reqUriPathUn;
                        ++sp;
                    }
                    location = this.getScheme() + "://" + this.getServerName() + portString + uri.substring(0, sp) + location;
                }
            }
            this.setHeader("Location", location);
            this.setStatus(302);
            this.setContentType("text/html");
            StringBuffer sb = new StringBuffer(200);
            sb.append("<HTML><HEAD><TITLE>302 Moved</TITLE></HEAD><BODY BGCOLOR=\"#D1E9FE\"><H2>302 Moved</H2>This document has moved <a href=" + location + ">here.<HR>");
            sb.append("<ADDRESS><A HREF=\"http://tjws.sourceforge.net\">D. Rogatkin's TJWS based on Acme.Serve Version 1.70, $Revision: 1.194 $</A></ADDRESS>");
            sb.append("</BODY></HTML>");
            this.setContentLength(sb.length());
            this.out.print(sb.toString());
            this.closeStreams();
        }

        public String encodeUrl(String url) {
            return this.encodeURL(url);
        }

        public String encodeRedirectUrl(String url) {
            return this.encodeRedirectURL(url);
        }

        public Socket getSocket() {
            return this.socket;
        }

        static {
            tz.setID("GMT");
        }
    }

    protected static class ServeConfig
    implements ServletConfig {
        private ServletContext context;
        private Hashtable init_params;
        private String servletName;

        public ServeConfig(ServletContext context) {
            this(context, null, "undefined");
        }

        public ServeConfig(ServletContext context, Hashtable initParams, String servletName) {
            this.context = context;
            this.init_params = initParams;
            this.servletName = servletName;
        }

        public ServletContext getServletContext() {
            return this.context;
        }

        public String getInitParameter(String name) {
            if (this.init_params != null) {
                return (String)this.init_params.get(name);
            }
            return null;
        }

        public Enumeration getInitParameterNames() {
            if (this.init_params != null) {
                return this.init_params.keys();
            }
            return new Vector().elements();
        }

        public String getServletName() {
            return this.servletName;
        }
    }

    static final class Identification {
        public static final String serverName = "D. Rogatkin's TJWS based on Acme.Serve";
        public static final String serverVersion = "Version 1.70, $Revision: 1.194 $";
        public static final String serverUrl = "http://tjws.sourceforge.net";
        public static final String serverIdHtml = "<ADDRESS><A HREF=\"http://tjws.sourceforge.net\">D. Rogatkin's TJWS based on Acme.Serve Version 1.70, $Revision: 1.194 $</A></ADDRESS>";

        Identification() {
        }
    }

    class KeepAliveCleaner
    extends Thread {
        protected List connections;
        protected List ingoings;
        protected volatile boolean stopped;
        private boolean noCheckClose;

        KeepAliveCleaner() {
            super("KeepAlive cleaner");
            this.connections = new ArrayList();
            this.ingoings = new ArrayList();
            this.setDaemon(true);
        }

        public void end() {
            this.stopped = true;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void addConnection(ServeConnection conn) {
            List list = this.ingoings;
            synchronized (list) {
                if (!this.stopped) {
                    this.ingoings.add(conn);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long d = Serve.this.getKeepAliveDuration();
            int maxUse = Serve.this.getMaxTimesConnectionUse();
            while (true) {
                List list = this.ingoings;
                synchronized (list) {
                    Iterator i = this.ingoings.iterator();
                    while (i.hasNext()) {
                        this.connections.add(i.next());
                        i.remove();
                    }
                }
                Iterator i = this.connections.iterator();
                long ct = System.currentTimeMillis();
                d = Serve.this.getKeepAliveDuration();
                while (i.hasNext()) {
                    ServeConnection serveConnection;
                    boolean closed;
                    ServeConnection conn = (ServeConnection)i.next();
                    boolean bl = closed = conn.socket == null;
                    if (!this.noCheckClose) {
                        serveConnection = conn;
                        synchronized (serveConnection) {
                            if (conn.socket != null) {
                                try {
                                    closed = (Boolean)conn.socket.getClass().getMethod("isClosed", Utils.EMPTY_CLASSES).invoke((Object)conn.socket, Utils.EMPTY_OBJECTS);
                                }
                                catch (IllegalArgumentException e) {
                                }
                                catch (SecurityException e) {
                                }
                                catch (IllegalAccessException e) {
                                }
                                catch (InvocationTargetException e) {
                                }
                                catch (NoSuchMethodException e) {
                                    this.noCheckClose = true;
                                }
                            }
                        }
                    }
                    if (!closed && (!conn.keepAlive || ct - conn.lastWait <= d || conn.lastRun >= conn.lastWait) && !this.stopped) continue;
                    i.remove();
                    serveConnection = conn;
                    synchronized (serveConnection) {
                        if (conn.socket != null) {
                            try {
                                conn.socket.getInputStream().close();
                            }
                            catch (IOException ioe) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (this.stopped && this.connections.size() == 0) break;
                try {
                    KeepAliveCleaner.sleep(d);
                }
                catch (InterruptedException ie) {
                    this.stopped = true;
                }
            }
        }
    }

    protected class SimpleRequestDispatcher
    implements RequestDispatcher {
        HttpServlet servlet;
        String dispatchPath;
        String dispatchQuery;
        int dispatchLen;

        SimpleRequestDispatcher(String path) {
            Object[] os = Serve.this.registry.get(path);
            this.servlet = (HttpServlet)os[0];
            if (this.servlet == null) {
                throw new NullPointerException();
            }
            this.dispatchLen = (Integer)os[1];
            int qmp = path.indexOf(63);
            if (qmp < 0 || qmp >= path.length() - 1) {
                this.dispatchPath = path;
            } else {
                this.dispatchPath = path.substring(0, qmp);
                this.dispatchQuery = path.substring(qmp + 1);
            }
        }

        public void forward(ServletRequest _request, ServletResponse _response) throws ServletException, IOException {
            _request.removeAttribute("javax.servlet.forward.request_uri");
            _response.reset();
            this.servlet.service((ServletRequest)new HttpServletRequestWrapper((HttpServletRequest)_request){

                public String getPathInfo() {
                    return SimpleRequestDispatcher.this.dispatchLen >= SimpleRequestDispatcher.this.dispatchPath.length() ? null : SimpleRequestDispatcher.this.dispatchPath.substring(SimpleRequestDispatcher.this.dispatchLen);
                }

                public String getRequestURI() {
                    return SimpleRequestDispatcher.this.dispatchPath;
                }

                public String getQueryString() {
                    return SimpleRequestDispatcher.this.dispatchQuery;
                }

                public String getPathTranslated() {
                    return this.getRequest().getRealPath(this.getPathInfo());
                }

                public String getServletPath() {
                    return SimpleRequestDispatcher.this.dispatchLen <= 0 ? "" : SimpleRequestDispatcher.this.dispatchPath.substring(0, SimpleRequestDispatcher.this.dispatchLen);
                }

                public synchronized Enumeration getAttributeNames() {
                    if (super.getAttribute("javax.servlet.forward.request_uri") == null) {
                        this.setAttribute("javax.servlet.forward.request_uri", super.getRequestURI());
                        this.setAttribute("javax.servlet.forward.context_path", this.getContextPath());
                        this.setAttribute("javax.servlet.forward.servlet_path", super.getServletPath());
                        this.setAttribute("javax.servlet.forward.path_info", super.getPathInfo());
                        this.setAttribute("javax.servlet.forward.query_string", super.getQueryString());
                    }
                    return super.getAttributeNames();
                }

                public Object getAttribute(String name) {
                    this.getAttributeNames();
                    return super.getAttribute(name);
                }
            }, _response);
            ((ServeConnection)_response).closeStreams();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void include(ServletRequest _request, ServletResponse _response) throws ServletException, IOException {
            _request.removeAttribute("javax.servlet.include.request_uri");
            ((ServeConnection)_response).setInInclude(true);
            try {
                this.servlet.service((ServletRequest)new HttpServletRequestWrapper((HttpServletRequest)_request){

                    public synchronized Enumeration getAttributeNames() {
                        if (super.getAttribute("javax.servlet.include.request_uri") == null) {
                            this.setAttribute("javax.servlet.include.request_uri", SimpleRequestDispatcher.this.dispatchPath);
                            this.setAttribute("javax.servlet.include.context_path", this.getContextPath());
                            this.setAttribute("javax.servlet.include.servlet_path", SimpleRequestDispatcher.this.dispatchLen <= 0 ? "" : SimpleRequestDispatcher.this.dispatchPath.substring(0, SimpleRequestDispatcher.this.dispatchLen));
                            this.setAttribute("javax.servlet.include.path_info", SimpleRequestDispatcher.this.dispatchLen >= SimpleRequestDispatcher.this.dispatchPath.length() ? null : SimpleRequestDispatcher.this.dispatchPath.substring(SimpleRequestDispatcher.this.dispatchLen));
                            this.setAttribute("javax.servlet.include.query_string", SimpleRequestDispatcher.this.dispatchQuery);
                        }
                        return super.getAttributeNames();
                    }

                    public Object getAttribute(String name) {
                        this.getAttributeNames();
                        return super.getAttribute(name);
                    }
                }, _response);
            }
            finally {
                ((ServeConnection)_response).setInInclude(false);
            }
        }
    }

    public static interface Acceptor {
        public void init(Map var1, Map var2) throws IOException;

        public Socket accept() throws IOException;

        public void destroy() throws IOException;
    }
}

