/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.skeleton.key.idm.service;

import java.io.Serializable;
import java.net.URI;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.skeleton.key.idm.IdentityManager;
import org.jboss.resteasy.skeleton.key.idm.i18n.Messages;
import org.jboss.resteasy.skeleton.key.idm.model.data.Realm;
import org.jboss.resteasy.skeleton.key.idm.model.data.RequiredCredential;
import org.jboss.resteasy.skeleton.key.idm.model.data.Resource;
import org.jboss.resteasy.skeleton.key.idm.model.data.Role;
import org.jboss.resteasy.skeleton.key.idm.model.data.RoleMapping;
import org.jboss.resteasy.skeleton.key.idm.model.data.ScopeMapping;
import org.jboss.resteasy.skeleton.key.idm.model.data.User;
import org.jboss.resteasy.skeleton.key.idm.model.data.UserAttribute;
import org.jboss.resteasy.skeleton.key.idm.model.data.UserCredential;
import org.jboss.resteasy.skeleton.key.idm.service.RealmResource;
import org.jboss.resteasy.skeleton.key.representations.idm.RealmRepresentation;
import org.jboss.resteasy.skeleton.key.representations.idm.RequiredCredentialRepresentation;
import org.jboss.resteasy.skeleton.key.representations.idm.ResourceRepresentation;
import org.jboss.resteasy.skeleton.key.representations.idm.RoleMappingRepresentation;
import org.jboss.resteasy.skeleton.key.representations.idm.ScopeMappingRepresentation;
import org.jboss.resteasy.skeleton.key.representations.idm.UserRepresentation;

@Path(value="/realms")
public class RealmFactory {
    protected IdentityManager identityManager;
    @Context
    protected UriInfo uriInfo;

    public RealmFactory(IdentityManager identityManager) {
        this.identityManager = identityManager;
    }

    @POST
    @Consumes(value={"application/json"})
    public Response importDomain(RealmRepresentation rep) {
        Realm realm = this.createRealm(rep);
        UriBuilder builder = this.uriInfo.getRequestUriBuilder().path(realm.getId());
        return Response.created((URI)builder.build(new Object[0])).entity((Object)RealmResource.realmRep(realm, this.uriInfo)).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    protected Realm createRealm(RealmRepresentation rep) {
        User user;
        Serializable attribute;
        this.verifyRealmRepresentation(rep);
        Realm realm = new Realm();
        KeyPair keyPair = null;
        try {
            keyPair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        realm.setPrivateKey(keyPair.getPrivate());
        realm.setPublicKey(keyPair.getPublic());
        realm.setName(rep.getRealm());
        realm.setEnabled(rep.isEnabled());
        realm.setTokenLifespan(rep.getTokenLifespan());
        realm.setAccessCodeLifespan(rep.getAccessCodeLifespan());
        realm.setSslNotRequired(rep.isSslNotRequired());
        realm = this.identityManager.create(realm);
        HashMap<String, User> userMap = new HashMap<String, User>();
        Role adminRole = this.identityManager.create(realm, "admin");
        for (RequiredCredentialRepresentation requiredCred : rep.getRequiredCredentials()) {
            RequiredCredential credential = new RequiredCredential();
            credential.setType(requiredCred.getType());
            credential.setInput(requiredCred.isInput());
            credential.setSecret(requiredCred.isSecret());
            this.identityManager.create(realm, credential);
        }
        for (UserRepresentation userRep : rep.getUsers()) {
            User user2 = new User();
            user2.setUsername(userRep.getUsername());
            user2.setEnabled(userRep.isEnabled());
            user2 = this.identityManager.create(realm, user2);
            userMap.put(user2.getUsername(), user2);
            if (userRep.getCredentials() != null) {
                for (UserRepresentation.Credential credential : userRep.getCredentials()) {
                    UserCredential credential2 = new UserCredential();
                    credential2.setType(credential.getType());
                    credential2.setValue(credential.getValue());
                    credential2.setHashed(credential.isHashed());
                    this.identityManager.create(user2, credential2);
                }
            }
            if (userRep.getAttributes() == null) continue;
            for (Map.Entry entry : userRep.getAttributes().entrySet()) {
                attribute = new UserAttribute();
                attribute.setName((String)entry.getKey());
                attribute.setValue((String)entry.getValue());
                this.identityManager.create(user2, (UserAttribute)attribute);
            }
        }
        for (RoleMappingRepresentation mapping : rep.getRoleMappings()) {
            RoleMapping roleMapping = this.createRoleMapping(userMap, mapping);
            user = (User)userMap.get(mapping.getUsername());
            this.identityManager.create(realm, user, roleMapping);
        }
        for (ScopeMappingRepresentation scope : rep.getScopeMappings()) {
            ScopeMapping scopeMapping = this.createScopeMapping(userMap, scope);
            user = (User)userMap.get(scope.getUsername());
            this.identityManager.create(realm, user, scopeMapping);
        }
        if (rep.getResources() != null) {
            for (ResourceRepresentation resourceRep : rep.getResources()) {
                Resource resource = new Resource();
                resource.setName(resourceRep.getName());
                resource.setSurrogateAuthRequired(resourceRep.isSurrogateAuthRequired());
                resource = this.identityManager.create(realm, resource);
                if (resourceRep.getRoles() != null) {
                    for (String string : resourceRep.getRoles()) {
                        attribute = this.identityManager.create(realm, resource, string);
                    }
                }
                if (resourceRep.getRoleMappings() != null) {
                    for (RoleMappingRepresentation roleMappingRepresentation : resourceRep.getRoleMappings()) {
                        RoleMapping roleMapping = this.createRoleMapping(userMap, roleMappingRepresentation);
                        User user3 = (User)userMap.get(roleMappingRepresentation.getUsername());
                        this.identityManager.create(realm, resource, user3, roleMapping);
                    }
                }
                if (resourceRep.getScopeMappings() == null) continue;
                for (ScopeMappingRepresentation scopeMappingRepresentation : resourceRep.getScopeMappings()) {
                    ScopeMapping scopeMapping = this.createScopeMapping(userMap, scopeMappingRepresentation);
                    User user2 = (User)userMap.get(scopeMappingRepresentation.getUsername());
                    this.identityManager.create(realm, resource, user2, scopeMapping);
                }
            }
        }
        return realm;
    }

    protected RoleMapping createRoleMapping(Map<String, User> userMap, RoleMappingRepresentation mapping) {
        RoleMapping roleMapping = new RoleMapping();
        User user = userMap.get(mapping.getUsername());
        roleMapping.setUserid(user.getId());
        if (mapping.getSurrogates() != null) {
            for (String s : mapping.getSurrogates()) {
                User surrogate = userMap.get(s);
                roleMapping.getSurrogateIds().add(surrogate.getId());
            }
        }
        for (String role : mapping.getRoles()) {
            roleMapping.getRoles().add(role);
        }
        return roleMapping;
    }

    protected ScopeMapping createScopeMapping(Map<String, User> userMap, ScopeMappingRepresentation mapping) {
        ScopeMapping scopeMapping = new ScopeMapping();
        User user = userMap.get(mapping.getUsername());
        scopeMapping.setUserid(user.getId());
        for (String role : mapping.getRoles()) {
            scopeMapping.getRoles().add(role);
        }
        return scopeMapping;
    }

    protected void verifyRealmRepresentation(RealmRepresentation rep) {
        if (rep.getUsers() == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)Messages.MESSAGES.noRealmAdminUsersDefined()).type("text/plain").build());
        }
        if (rep.getRequiredCredentials() == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)Messages.MESSAGES.realmCredentialRequirementsNotDefined()).type("text/plain").build());
        }
        if (rep.getRoleMappings() == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)Messages.MESSAGES.noRealmAdminUsersDefined()).type("text/plain").build());
        }
        HashMap<String, UserRepresentation> userReps = new HashMap<String, UserRepresentation>();
        for (UserRepresentation userRep : rep.getUsers()) {
            userReps.put(userRep.getUsername(), userRep);
        }
        HashSet admins = new HashSet();
        for (RoleMappingRepresentation mapping : rep.getRoleMappings()) {
            if (!userReps.containsKey(mapping.getUsername())) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)Messages.MESSAGES.noUsersDeclaredForRoleMapping()).type("text/plain").build());
            }
            for (Object role : mapping.getRoles()) {
                if (!((String)role).equals("admin")) {
                    throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)Messages.MESSAGES.thereIsOnlyAdminRole()).type("text/plain").build());
                }
                admins.add(userReps.get(mapping.getUsername()));
            }
        }
        if (admins.size() == 0) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)Messages.MESSAGES.noRealmAdminUsersDefined()).type("text/plain").build());
        }
        for (UserRepresentation userRep : rep.getUsers()) {
            if (!userRep.isEnabled()) {
                admins.remove(userRep);
                continue;
            }
            if (userRep.getCredentials() == null) {
                admins.remove(userRep);
                userRep.setEnabled(false);
                continue;
            }
            boolean hasBrowserCredentials = true;
            for (RequiredCredentialRepresentation credential : rep.getRequiredCredentials()) {
                boolean hasCredential = false;
                for (UserRepresentation.Credential cred : userRep.getCredentials()) {
                    if (!cred.getType().equals(credential.getType())) continue;
                    hasCredential = true;
                    break;
                }
                if (hasCredential) continue;
                hasBrowserCredentials = false;
                break;
            }
            if (hasBrowserCredentials) continue;
            userRep.setEnabled(false);
            admins.remove(userRep);
        }
        if (admins.size() == 0) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)Messages.MESSAGES.noRealmAdminUsersEnabled()).type("text/plain").build());
        }
        if (rep.getResources() != null) {
            for (ResourceRepresentation resourceRep : rep.getResources()) {
                if (resourceRep.getRoleMappings() == null) continue;
                for (RoleMappingRepresentation mapping : resourceRep.getRoleMappings()) {
                    if (!userReps.containsKey(mapping.getUsername())) {
                        throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)Messages.MESSAGES.noUsersDeclaredForRoleMapping()).type("text/plain").build());
                    }
                    if (mapping.getSurrogates() != null) {
                        for (String surrogate : mapping.getSurrogates()) {
                            if (userReps.containsKey(surrogate)) continue;
                            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)Messages.MESSAGES.noUsersDeclaredForRoleMappingSurrogate()).type("text/plain").build());
                        }
                    }
                    for (String role : mapping.getRoles()) {
                        if (resourceRep.getRoles().contains(role)) continue;
                        throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)Messages.MESSAGES.noResourceRoleForRoleMapping()).type("text/plain").build());
                    }
                }
            }
        }
    }
}

