/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.skeleton.key.as7;

import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.UriBuilder;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.FormAuthenticator;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.realm.GenericPrincipal;
import org.jboss.logging.Logger;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.skeleton.key.RealmConfiguration;
import org.jboss.resteasy.skeleton.key.ResourceMetadata;
import org.jboss.resteasy.skeleton.key.SkeletonKeyPrincipal;
import org.jboss.resteasy.skeleton.key.SkeletonKeySession;
import org.jboss.resteasy.skeleton.key.as7.CatalinaBearerTokenAuthenticator;
import org.jboss.resteasy.skeleton.key.as7.CatalinaSecurityContextHelper;
import org.jboss.resteasy.skeleton.key.as7.ServletOAuthLogin;
import org.jboss.resteasy.skeleton.key.as7.UserSessionManagement;
import org.jboss.resteasy.skeleton.key.as7.config.ManagedResourceConfig;
import org.jboss.resteasy.skeleton.key.as7.config.ManagedResourceConfigLoader;
import org.jboss.resteasy.skeleton.key.representations.SkeletonKeyToken;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class OAuthManagedResourceValve
extends FormAuthenticator
implements LifecycleListener {
    protected RealmConfiguration realmConfiguration;
    private static final Logger log = Logger.getLogger(OAuthManagedResourceValve.class);
    protected UserSessionManagement userSessionManagement = new UserSessionManagement();
    protected ManagedResourceConfig remoteSkeletonKeyConfig;
    protected ResourceMetadata resourceMetadata;

    public void start() throws LifecycleException {
        super.start();
        StandardContext standardContext = (StandardContext)this.context;
        standardContext.addLifecycleListener((LifecycleListener)this);
    }

    public void lifecycleEvent(LifecycleEvent event) {
        if (event.getType() == "after_start") {
            this.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        ManagedResourceConfigLoader managedResourceConfigLoader = new ManagedResourceConfigLoader(this.context);
        this.resourceMetadata = managedResourceConfigLoader.getResourceMetadata();
        this.remoteSkeletonKeyConfig = managedResourceConfigLoader.getRemoteSkeletonKeyConfig();
        String client_id = this.remoteSkeletonKeyConfig.getClientId();
        if (client_id == null) {
            throw new IllegalArgumentException("Must set client-id to use with auth server");
        }
        this.realmConfiguration = new RealmConfiguration();
        String authUrl = this.remoteSkeletonKeyConfig.getAuthUrl();
        if (authUrl == null) {
            throw new RuntimeException("You must specify auth-url");
        }
        String tokenUrl = this.remoteSkeletonKeyConfig.getCodeUrl();
        if (tokenUrl == null) {
            throw new RuntimeException("You mut specify code-url");
        }
        this.realmConfiguration.setMetadata(this.resourceMetadata);
        this.realmConfiguration.setClientId(client_id);
        for (Map.Entry<String, String> entry : managedResourceConfigLoader.getRemoteSkeletonKeyConfig().getClientCredentials().entrySet()) {
            this.realmConfiguration.getCredentials().param(entry.getKey(), entry.getValue());
        }
        int size = 10;
        if (managedResourceConfigLoader.getRemoteSkeletonKeyConfig().getConnectionPoolSize() > 0) {
            size = managedResourceConfigLoader.getRemoteSkeletonKeyConfig().getConnectionPoolSize();
        }
        ResteasyClientBuilder.HostnameVerificationPolicy policy = ResteasyClientBuilder.HostnameVerificationPolicy.WILDCARD;
        if (managedResourceConfigLoader.getRemoteSkeletonKeyConfig().isAllowAnyHostname()) {
            policy = ResteasyClientBuilder.HostnameVerificationPolicy.ANY;
        }
        ResteasyProviderFactory providerFactory = new ResteasyProviderFactory();
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(OAuthManagedResourceValve.class.getClassLoader());
        try {
            ResteasyProviderFactory.getInstance();
            RegisterBuiltin.register((ResteasyProviderFactory)providerFactory);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        ResteasyClient client = new ResteasyClientBuilder().providerFactory(providerFactory).connectionPoolSize(size).hostnameVerification(policy).trustStore(this.resourceMetadata.getTruststore()).keyStore(this.resourceMetadata.getClientKeystore(), this.resourceMetadata.getClientKeyPassword()).build();
        this.realmConfiguration.setClient(client);
        this.realmConfiguration.setAuthUrl(UriBuilder.fromUri((String)authUrl).queryParam("client_id", new Object[]{client_id}));
        this.realmConfiguration.setCodeUrl(client.target(tokenUrl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        try {
            String requestURI = request.getDecodedRequestURI();
            if (requestURI.endsWith("j_oauth_remote_logout")) {
                this.remoteLogout(request, (HttpServletResponse)response);
                return;
            }
            super.invoke(request, response);
        }
        finally {
            ResteasyProviderFactory.clearContextData();
        }
    }

    public boolean authenticate(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        try {
            if (this.bearer(false, request, response)) {
                return true;
            }
            if (this.checkLoggedIn(request, response)) {
                if (request.getSessionInternal().getNote("org.apache.catalina.authenticator.REQUEST") != null) {
                    if (this.restoreRequest(request, request.getSessionInternal())) {
                        log.info((Object)"restoreRequest");
                        return true;
                    }
                    log.info((Object)"Restore of original request failed");
                    response.sendError(400);
                    return false;
                }
                return true;
            }
            this.oauth(request, response);
        }
        catch (LoginException e) {
            // empty catch block
        }
        return false;
    }

    protected void remoteLogout(Request request, HttpServletResponse response) throws IOException {
        try {
            log.info((Object)"->> remoteLogout: ");
            if (!this.bearer(true, request, response)) {
                log.info((Object)"remoteLogout: bearer auth failed");
                return;
            }
            GenericPrincipal gp = (GenericPrincipal)request.getPrincipal();
            if (!gp.hasRole(this.remoteSkeletonKeyConfig.getAdminRole())) {
                log.info((Object)"remoteLogout: role failure");
                response.sendError(403);
                return;
            }
            String user = request.getParameter("user");
            if (user != null) {
                this.userSessionManagement.logout(user);
            } else {
                this.userSessionManagement.logoutAll();
            }
        }
        catch (Exception e) {
            log.error((Object)"failed to logout", (Throwable)e);
        }
        response.setStatus(204);
    }

    protected boolean bearer(boolean challenge, Request request, HttpServletResponse response) throws LoginException, IOException {
        CatalinaBearerTokenAuthenticator bearer = new CatalinaBearerTokenAuthenticator(this.realmConfiguration.getMetadata(), !this.remoteSkeletonKeyConfig.isCancelPropagation(), challenge);
        return bearer.login(request, response);
    }

    protected boolean checkLoggedIn(Request request, HttpServletResponse response) {
        SkeletonKeySession skSession;
        if (request.getSessionInternal() == null || request.getSessionInternal().getPrincipal() == null) {
            return false;
        }
        log.info((Object)"remote logged in already");
        GenericPrincipal principal = (GenericPrincipal)request.getSessionInternal().getPrincipal();
        request.setUserPrincipal((Principal)principal);
        request.setAuthType("OAUTH");
        Session session = request.getSessionInternal();
        if (session != null && !this.remoteSkeletonKeyConfig.isCancelPropagation() && (skSession = (SkeletonKeySession)session.getNote(SkeletonKeySession.class.getName())) != null) {
            request.setAttribute(SkeletonKeySession.class.getName(), (Object)skSession);
            ResteasyProviderFactory.pushContext(SkeletonKeySession.class, (Object)skSession);
        }
        return true;
    }

    protected void oauth(Request request, HttpServletResponse response) throws IOException {
        SkeletonKeyToken.Access access;
        ServletOAuthLogin oauth = new ServletOAuthLogin(this.realmConfiguration, (HttpServletRequest)request, response, request.getConnector().getRedirectPort());
        String code = oauth.getCode();
        if (code == null) {
            String error = oauth.getError();
            if (error != null) {
                response.sendError(400, "OAuth " + error);
                return;
            }
            this.saveRequest(request, request.getSessionInternal(true));
            oauth.loginRedirect();
            return;
        }
        if (!oauth.resolveCode(code)) {
            return;
        }
        SkeletonKeyToken token = oauth.getToken();
        Set roles = null;
        if (this.resourceMetadata.getResourceName() != null) {
            access = token.getResourceAccess(this.resourceMetadata.getResourceName());
            if (access != null) {
                roles = access.getRoles();
            }
        } else {
            access = token.getRealmAccess();
            if (access != null) {
                roles = access.getRoles();
            }
        }
        SkeletonKeyPrincipal skp = new SkeletonKeyPrincipal(token.getPrincipal(), null);
        GenericPrincipal principal = new CatalinaSecurityContextHelper().createPrincipal(this.context.getRealm(), (Principal)skp, roles);
        Session session = request.getSessionInternal(true);
        session.setPrincipal((Principal)principal);
        session.setAuthType("OAUTH");
        if (!this.remoteSkeletonKeyConfig.isCancelPropagation()) {
            SkeletonKeySession skSession = new SkeletonKeySession(oauth.getTokenString(), this.realmConfiguration.getMetadata());
            session.setNote(SkeletonKeySession.class.getName(), (Object)skSession);
        }
        String username = token.getPrincipal();
        log.info((Object)("userSessionManage.login: " + username));
        this.userSessionManagement.login(session, username);
    }
}

