/*
 * Decompiled with CFR 0.152.
 */
package dev.resteasy.embedded.server;

import dev.resteasy.embedded.server.CdiResteasyDeployment;
import dev.resteasy.embedded.server.LogMessages;
import dev.resteasy.embedded.server.UndertowBuilderConfigurator;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import jakarta.annotation.Priority;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.MultipartConfig;
import jakarta.ws.rs.SeBootstrap;
import jakarta.ws.rs.core.Application;
import java.util.Map;
import org.jboss.resteasy.plugins.server.embedded.EmbeddedServer;
import org.jboss.resteasy.plugins.server.embedded.EmbeddedServers;
import org.jboss.resteasy.plugins.server.servlet.HttpServlet30Dispatcher;
import org.jboss.resteasy.spi.PriorityServiceLoader;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.weld.environment.ContainerInstance;
import org.jboss.weld.environment.servlet.Listener;
import org.jboss.weld.environment.undertow.UndertowContainer;
import org.xnio.Options;
import org.xnio.SslClientAuthMode;

@Priority(value=100)
public class UndertowCdiEmbeddedServer
implements EmbeddedServer {
    private final ServletContainer servletContainer = ServletContainer.Factory.newInstance();
    private final PathHandler rootHandler = new PathHandler();
    private final CdiResteasyDeployment deployment = new CdiResteasyDeployment();
    private volatile Undertow server;
    private volatile Runnable undeployAction;

    public void start(SeBootstrap.Configuration configuration) {
        Undertow.Builder builder = Undertow.builder().setHandler((HttpHandler)this.rootHandler);
        if ("HTTPS".equalsIgnoreCase(configuration.protocol())) {
            builder.addHttpsListener(configuration.port(), configuration.host(), configuration.sslContext());
        } else {
            builder.addHttpListener(configuration.port(), configuration.host());
        }
        switch (configuration.sslClientAuthentication()) {
            case NONE: {
                builder.setSocketOption(Options.SSL_CLIENT_AUTH_MODE, (Object)SslClientAuthMode.NOT_REQUESTED);
                break;
            }
            case OPTIONAL: {
                builder.setSocketOption(Options.SSL_CLIENT_AUTH_MODE, (Object)SslClientAuthMode.REQUESTED);
                return;
            }
            case MANDATORY: {
                builder.setSocketOption(Options.SSL_CLIENT_AUTH_MODE, (Object)SslClientAuthMode.REQUIRED);
            }
        }
        PriorityServiceLoader undertowBuilderConfigurators = PriorityServiceLoader.load(UndertowBuilderConfigurator.class);
        for (UndertowBuilderConfigurator undertowBuilderConfigurator : undertowBuilderConfigurators) {
            undertowBuilderConfigurator.configure(builder);
        }
        Undertow server = builder.build();
        server.start();
        this.server = server;
        DeploymentInfo deploymentInfo = this.deploymentInfo(configuration);
        DeploymentManager manager = this.servletContainer.addDeployment(deploymentInfo);
        manager.deploy();
        try {
            this.rootHandler.addPrefixPath(deploymentInfo.getContextPath(), manager.start());
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        this.undeployAction = () -> {
            try {
                manager.stop();
            }
            catch (ServletException e) {
                LogMessages.LOGGER.failedToStopDeploymentManager(e, deploymentInfo.getDeploymentName());
            }
            manager.undeploy();
            this.servletContainer.removeDeployment(deploymentInfo);
        };
    }

    public void stop() {
        Undertow server;
        Runnable undeployAction;
        CdiResteasyDeployment deployment = this.deployment;
        if (deployment != null) {
            deployment.stop();
        }
        if ((undeployAction = this.undeployAction) != null) {
            undeployAction.run();
        }
        if ((server = this.server) != null) {
            server.stop();
        }
    }

    public ResteasyDeployment getDeployment() {
        return this.deployment;
    }

    private DeploymentInfo deploymentInfo(SeBootstrap.Configuration configuration) {
        DeploymentInfo deploymentInfo;
        if (configuration.hasProperty("dev.resteasy.embedded.undertow.deployment")) {
            Object deployment = configuration.property("dev.resteasy.embedded.undertow.deployment");
            if (deployment instanceof DeploymentInfo) {
                deploymentInfo = (DeploymentInfo)deployment;
            } else {
                LogMessages.LOGGER.invalidProperty("dev.resteasy.embedded.undertow.deployment", deployment.getClass().getName(), DeploymentInfo.class.getName());
                deploymentInfo = new DeploymentInfo();
            }
        } else {
            deploymentInfo = new DeploymentInfo();
        }
        return this.configure(deploymentInfo, configuration);
    }

    private DeploymentInfo configure(DeploymentInfo deploymentInfo, SeBootstrap.Configuration configuration) {
        Application application;
        MultipartConfig multipartConfig;
        ContainerInstance container = this.deployment.getContainer();
        EmbeddedServers.validateDeployment((ResteasyDeployment)this.deployment);
        Object mapping = EmbeddedServers.checkContextPath((ResteasyDeployment)this.deployment);
        if (!((String)mapping).endsWith("/")) {
            mapping = (String)mapping + "/";
        }
        mapping = (String)mapping + "*";
        ServletInfo resteasyServlet = deploymentInfo.getServlets().containsKey("ResteasyServlet") ? (ServletInfo)deploymentInfo.getServlets().get("ResteasyServlet") : Servlets.servlet((String)"ResteasyServlet", HttpServlet30Dispatcher.class).setAsyncSupported(true).setLoadOnStartup(Integer.valueOf(1)).addMapping((String)mapping);
        if (!"/*".equals(mapping)) {
            String prefix = ((String)mapping).substring(0, ((String)mapping).length() - 2);
            resteasyServlet.addInitParam("resteasy.servlet.mapping.prefix", prefix);
        }
        if (configuration.hasProperty("dev.resteasy.embedded.undertow.context.parameters")) {
            Object value = configuration.property("dev.resteasy.embedded.undertow.context.parameters");
            if (value instanceof Map) {
                for (Map.Entry e : ((Map)value).entrySet()) {
                    deploymentInfo.addInitParameter((String)e.getKey(), (String)e.getValue());
                }
            } else {
                LogMessages.LOGGER.invalidProperty("dev.resteasy.embedded.undertow.context.parameters", value.getClass().getName(), Map.class.getName());
            }
        }
        deploymentInfo.addInitParameter("org.jboss.weld.environment.container.class", UndertowContainer.class.getName());
        String contextPath = EmbeddedServers.checkContextPath((String)configuration.rootPath());
        if (deploymentInfo.getDefaultMultipartConfig() == null && (multipartConfig = (application = this.deployment.getApplication()).getClass().getAnnotation(MultipartConfig.class)) != null) {
            deploymentInfo.setDefaultMultipartConfig(new MultipartConfigElement(multipartConfig));
        }
        return deploymentInfo.setClassLoader(this.deployment.getApplication().getClass().getClassLoader()).setContextPath(contextPath).setDeploymentName("RESTEasy-" + contextPath).addServletContextAttribute(ResteasyDeployment.class.getName(), (Object)this.deployment).addServlet(resteasyServlet).addListener(Servlets.listener(Listener.class, (InstanceFactory)new ImmediateInstanceFactory((Object)Listener.using((ContainerInstance)container))));
    }
}

