/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.multipart;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWorkers;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.annotations.providers.multipart.MultipartForm;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInputImpl;
import org.jboss.resteasy.spi.LoggableFailure;
import org.jboss.resteasy.util.FindAnnotation;

@Provider
@Consumes(value={"multipart/form-data"})
public class MultipartFormAnnotationReader
implements MessageBodyReader {
    @Context
    protected MessageBodyWorkers workers;

    public boolean isReadable(Class type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return FindAnnotation.findAnnotation((Annotation[])annotations, MultipartForm.class) != null || type.isAnnotationPresent(MultipartForm.class);
    }

    public Object readFrom(Class type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        Object obj;
        String boundary = (String)mediaType.getParameters().get("boundary");
        if (boundary == null) {
            throw new IOException("Unable to get boundary for multipart");
        }
        MultipartFormDataInputImpl input = new MultipartFormDataInputImpl(boundary, this.workers);
        input.parse(entityStream);
        try {
            obj = type.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        for (Class theType = type; theType != null && !theType.equals(Object.class); theType = theType.getSuperclass()) {
            this.setFields(theType, input, obj);
        }
        for (Method method : type.getMethods()) {
            if (!method.isAnnotationPresent(FormParam.class) || !method.getName().startsWith("set") || method.getParameterTypes().length != 1) continue;
            FormParam param = method.getAnnotation(FormParam.class);
            InputPart part = input.getFormData().get(param.value());
            if (part == null) {
                throw new LoggableFailure("Unable to find @FormParam in multipart: " + param.value());
            }
            Object data = part.getBody(method.getParameterTypes()[0], method.getGenericParameterTypes()[0]);
            try {
                method.invoke(obj, data);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return obj;
    }

    protected void setFields(Class type, MultipartFormDataInputImpl input, Object obj) throws IOException {
        for (Field field : type.getDeclaredFields()) {
            if (!field.isAnnotationPresent(FormParam.class)) continue;
            field.setAccessible(true);
            FormParam param = field.getAnnotation(FormParam.class);
            InputPart part = input.getFormData().get(param.value());
            if (part == null) {
                throw new LoggableFailure("Unable to find @FormParam in multipart: " + param.value());
            }
            Object data = part.getBody(field.getType(), field.getGenericType());
            try {
                field.set(obj, data);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

