/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.keystone.as7;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.acl.Group;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MediaType;
import org.apache.catalina.connector.Request;
import org.jboss.resteasy.keystone.as7.JBossWebAuthLoginModule;
import org.jboss.resteasy.keystone.core.UserPrincipal;
import org.jboss.resteasy.keystone.model.Access;
import org.jboss.resteasy.keystone.model.Role;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.security.smime.PKCS7SignatureInput;
import org.jboss.security.JSSESecurityDomain;
import org.jboss.security.SecurityDomain;
import org.jboss.security.SecurityUtil;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;

public class SignedSkeletonKeyStoneLoginModule
extends JBossWebAuthLoginModule {
    private static final Logger log = Logger.getLogger(SignedSkeletonKeyStoneLoginModule.class);
    private static final String SECURITY_DOMAIN = "securityDomain";
    protected String projectId;
    protected String skeletonKeyCertificateAlias;
    protected Access access;
    private Object domain = null;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.projectId = (String)options.get("projectId");
        this.skeletonKeyCertificateAlias = (String)options.get("skeleton.key.certificate.alias");
        String sd = (String)options.get(SECURITY_DOMAIN);
        log.error("Security Domain: " + sd);
        sd = SecurityUtil.unprefixSecurityDomain((String)sd);
        if (sd == null) {
            sd = "other";
        }
        try {
            Object tempDomain = new InitialContext().lookup("java:jboss/jaas/" + sd);
            if (tempDomain instanceof SecurityDomain) {
                this.domain = tempDomain;
            } else {
                tempDomain = new InitialContext().lookup("java:jboss/jaas/" + sd + "/jsse");
                if (tempDomain instanceof JSSESecurityDomain) {
                    this.domain = tempDomain;
                } else {
                    log.error("The JSSE security domain " + sd + " is not valid. All authentication using this login module will fail!");
                }
            }
        }
        catch (NamingException e) {
            log.error("Unable to find the securityDomain named: " + sd, (Throwable)e);
        }
    }

    @Override
    protected boolean login(Request request, HttpServletResponse response) throws LoginException {
        String tokenHeader = request.getHeader("X-Auth-Signed-Token");
        if (tokenHeader == null) {
            return false;
        }
        KeyStore keyStore = null;
        if (this.domain != null) {
            if (this.domain instanceof SecurityDomain) {
                keyStore = ((SecurityDomain)this.domain).getKeyStore();
            } else if (this.domain instanceof JSSESecurityDomain) {
                keyStore = ((JSSESecurityDomain)this.domain).getKeyStore();
            }
        }
        if (keyStore == null) {
            throw new LoginException("No trust store found");
        }
        X509Certificate certificate = null;
        try {
            certificate = (X509Certificate)keyStore.getCertificate(this.skeletonKeyCertificateAlias);
        }
        catch (KeyStoreException e) {
            throw new LoginException("Could not get certificate from keyStore");
        }
        try {
            PKCS7SignatureInput input = new PKCS7SignatureInput(tokenHeader);
            if (!input.verify(certificate)) {
                throw new LoginException("Bad Signature");
            }
            this.access = (Access)input.getEntity(Access.class, MediaType.APPLICATION_JSON_TYPE);
        }
        catch (LoginException le) {
            throw le;
        }
        catch (Exception e) {
            throw new LoginException("Bad Token");
        }
        if (this.access.getToken().expired()) {
            throw new LoginException("Token expired");
        }
        if (!this.projectId.equals(this.access.getToken().getProject().getId())) {
            throw new LoginException("Token project id doesn't match");
        }
        this.loginOk = true;
        return true;
    }

    protected Principal getIdentity() {
        UserPrincipal principal = new UserPrincipal(this.access.getUser());
        return principal;
    }

    protected Group[] getRoleSets() throws LoginException {
        SimpleGroup roles = new SimpleGroup("Roles");
        Group[] roleSets = new Group[]{roles};
        for (Role role : this.access.getUser().getRoles()) {
            roles.addMember((Principal)new SimplePrincipal(role.getName()));
        }
        return roleSets;
    }
}

