/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jaxb;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.bind.annotation.XmlType;
import org.jboss.resteasy.plugins.providers.jaxb.JAXBContextFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJAXBContextFinder
implements JAXBContextFinder {
    protected static final String OBJECT_FACTORY_NAME = ".ObjectFactory";
    @Context
    protected Providers providers;

    public JAXBContext findProvidedJAXBContext(Class<?> type, MediaType mediaType) throws JAXBException {
        JAXBContext jaxb = null;
        ContextResolver resolver = this.providers.getContextResolver(JAXBContext.class, mediaType);
        if (resolver != null && (jaxb = (JAXBContext)resolver.getContext(type)) != null) {
            return jaxb;
        }
        return jaxb;
    }

    public static Class<?> findDefaultObjectFactoryClass(Class<?> type) {
        XmlType typeAnnotation = type.getAnnotation(XmlType.class);
        if (typeAnnotation == null) {
            return null;
        }
        if (!typeAnnotation.factoryClass().equals(XmlType.DEFAULT.class)) {
            return null;
        }
        StringBuilder b = new StringBuilder(type.getPackage().getName());
        b.append(OBJECT_FACTORY_NAME);
        Class<?> factoryClass = null;
        try {
            factoryClass = Thread.currentThread().getContextClassLoader().loadClass(b.toString());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        if (factoryClass.isAnnotationPresent(XmlRegistry.class)) {
            return factoryClass;
        }
        return null;
    }

    protected abstract JAXBContext createContextObject(Annotation[] var1, Class ... var2) throws JAXBException;

    @Override
    public JAXBContext createContext(Annotation[] parameterAnnotations, Class ... classes) throws JAXBException {
        HashSet classes1 = new HashSet();
        for (Class type : classes) {
            classes1.add(type);
            Class<?> factory = AbstractJAXBContextFinder.findDefaultObjectFactoryClass(type);
            if (factory == null) continue;
            classes1.add(factory);
        }
        Class[] classArray = classes1.toArray(new Class[classes1.size()]);
        return this.createContextObject(parameterAnnotations, classArray);
    }

    public JAXBContextFinder getContext(Class<?> type) {
        return this;
    }

    public static class CacheKey {
        private Class[] classes;
        private int hashCode;

        public CacheKey(Class[] classes) {
            this.classes = classes;
            for (Class clazz : classes) {
                this.hashCode += clazz.hashCode();
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.hashCode != cacheKey.hashCode) {
                return false;
            }
            if (this.classes.length != cacheKey.classes.length) {
                return false;
            }
            for (Class clazz : this.classes) {
                boolean found = false;
                for (Class compare : cacheKey.classes) {
                    if (!compare.equals(clazz)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

