/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.validation.hibernate;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import org.jboss.resteasy.spi.validation.DoNotValidateRequest;
import org.jboss.resteasy.spi.validation.ValidateRequest;
import org.jboss.resteasy.spi.validation.ValidatorAdapter;
import org.jboss.resteasy.util.FindAnnotation;

class HibernateValidatorAdapter
implements ValidatorAdapter {
    private final Validator validator;

    HibernateValidatorAdapter(Validator validator) {
        if (validator == null) {
            throw new IllegalArgumentException("Validator cannot be null");
        }
        this.validator = validator;
    }

    public void applyValidation(Object resource, Method invokedMethod, Object[] args) {
        HashSet constraintViolations;
        ValidateRequest resourceValidateRequest = (ValidateRequest)FindAnnotation.findAnnotation((Annotation[])invokedMethod.getDeclaringClass().getAnnotations(), ValidateRequest.class);
        if (resourceValidateRequest != null && (constraintViolations = new HashSet(this.validator.validate(resource, resourceValidateRequest.groups()))).size() > 0) {
            throw new ConstraintViolationException(constraintViolations);
        }
        ValidateRequest methodValidateRequest = (ValidateRequest)FindAnnotation.findAnnotation((Annotation[])invokedMethod.getAnnotations(), ValidateRequest.class);
        DoNotValidateRequest doNotValidateRequest = (DoNotValidateRequest)FindAnnotation.findAnnotation((Annotation[])invokedMethod.getAnnotations(), DoNotValidateRequest.class);
        if ((resourceValidateRequest != null || methodValidateRequest != null) && doNotValidateRequest == null) {
            HashSet constraintViolations2;
            HashSet<Class> set = new HashSet<Class>();
            if (resourceValidateRequest != null) {
                for (Class group : resourceValidateRequest.groups()) {
                    set.add(group);
                }
            }
            if (methodValidateRequest != null) {
                for (Class group : methodValidateRequest.groups()) {
                    set.add(group);
                }
            }
            if ((constraintViolations2 = new HashSet(this.validator.forExecutables().validateParameters(resource, invokedMethod, args, set.toArray(new Class[set.size()])))).size() > 0) {
                throw new ConstraintViolationException(constraintViolations2);
            }
        }
    }
}

