/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.guice;

import com.google.inject.Module;
import com.google.inject.Stage;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.plugins.guice.ModuleProcessor;
import org.jboss.resteasy.plugins.server.servlet.ResteasyBootstrap;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class GuiceResteasyBootstrapServletContextListener
extends ResteasyBootstrap
implements ServletContextListener {
    private static final Logger logger = Logger.getLogger(GuiceResteasyBootstrapServletContextListener.class);
    private List<Module> modules;

    public void contextInitialized(ServletContextEvent event) {
        super.contextInitialized(event);
        ServletContext context = event.getServletContext();
        Registry registry = (Registry)context.getAttribute(Registry.class.getName());
        ResteasyProviderFactory providerFactory = (ResteasyProviderFactory)context.getAttribute(ResteasyProviderFactory.class.getName());
        ModuleProcessor processor = new ModuleProcessor(registry, providerFactory);
        List<Module> modules = this.getModules(context);
        Stage stage = this.getStage(context);
        if (stage == null) {
            processor.process(modules);
        } else {
            processor.process(stage, modules);
        }
        this.modules = modules;
        this.triggerAnnotatedMethods(this.modules, PostConstruct.class);
    }

    private Stage getStage(ServletContext context) {
        String stageAsString = context.getInitParameter("resteasy.guice.stage");
        if (stageAsString == null) {
            return null;
        }
        try {
            return Stage.valueOf((String)stageAsString.trim());
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Injector stage is not defined properly. " + stageAsString + " is wrong value." + " Possible values are PRODUCTION, DEVELOPMENT, TOOL.");
        }
    }

    protected List<Module> getModules(ServletContext context) {
        ArrayList<Module> result = new ArrayList<Module>();
        String modulesString = context.getInitParameter("resteasy.guice.modules");
        if (modulesString != null) {
            String[] moduleStrings;
            for (String moduleString : moduleStrings = modulesString.trim().split(",")) {
                try {
                    logger.info("found module: {0}", new Object[]{moduleString});
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(moduleString.trim());
                    Module module = (Module)clazz.newInstance();
                    result.add(module);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return result;
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.triggerAnnotatedMethods(this.modules, PreDestroy.class);
    }

    private void triggerAnnotatedMethods(List<Module> modules, Class<? extends Annotation> annotationClass) {
        for (Module module : this.modules) {
            Method[] methods;
            for (Method method : methods = module.getClass().getMethods()) {
                if (!method.isAnnotationPresent(annotationClass)) continue;
                if (method.getParameterTypes().length > 0) {
                    logger.warn("Cannot execute expected module {}'s @{} method {} because it has unexpected parameters: skipping.", new Object[]{module.getClass().getSimpleName(), annotationClass.getSimpleName(), method.getName()});
                    continue;
                }
                try {
                    method.invoke((Object)module, new Object[0]);
                }
                catch (InvocationTargetException ex) {
                    logger.warn("Problem running annotation method @" + annotationClass.getSimpleName(), (Throwable)ex);
                }
                catch (IllegalAccessException ex) {
                    logger.warn("Problem running annotation method @" + annotationClass.getSimpleName(), (Throwable)ex);
                }
            }
        }
    }
}

