/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.dao;

import java.util.Collection;
import se.unlogic.standardutils.dao.Column;
import se.unlogic.standardutils.dao.QueryOperators;

public class QueryParameter<BeanType, ColumnType> {
    private final ColumnType value;
    private final Collection<ColumnType> values;
    private Column<BeanType, ? super ColumnType> column;
    private String operator = QueryOperators.EQUALS.getOperator();

    QueryParameter(Column<BeanType, ? super ColumnType> column, ColumnType value) {
        this.column = column;
        this.value = value;
        this.values = null;
    }

    QueryParameter(Column<BeanType, ? super ColumnType> column, ColumnType value, String operator) {
        this.column = column;
        this.value = value;
        this.operator = operator;
        this.values = null;
    }

    QueryParameter(Column<BeanType, ? super ColumnType> column, String operator) {
        this.column = column;
        this.operator = operator;
        this.value = null;
        this.values = null;
    }

    QueryParameter(Column<BeanType, ? super ColumnType> column, Collection<ColumnType> values, String operator) {
        this.column = column;
        this.operator = operator;
        this.value = null;
        this.values = values;
    }

    public ColumnType getValue() {
        return this.value;
    }

    public Collection<ColumnType> getValues() {
        return this.values;
    }

    public Column<BeanType, ? super ColumnType> getColumn() {
        return this.column;
    }

    public String getOperator() {
        return this.operator;
    }

    public boolean hasValues() {
        return this.value != null || this.values != null;
    }

    public boolean hasMultipleValues() {
        return this.values != null;
    }
}

