/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.engines;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.jboss.resteasy.client.core.SelfExpandingBufferredInputStream;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocation;
import org.jboss.resteasy.client.jaxrs.internal.ClientResponse;
import org.jboss.resteasy.util.CaseInsensitiveMap;

public class ApacheHttpClient4Engine
implements ClientHttpEngine {
    protected HttpClient httpClient;
    protected boolean createdHttpClient;
    protected HttpContext httpContext;
    protected boolean closed;
    protected SSLContext sslContext;
    protected HostnameVerifier hostnameVerifier;

    public ApacheHttpClient4Engine() {
        this.httpClient = new DefaultHttpClient();
        this.createdHttpClient = true;
    }

    public ApacheHttpClient4Engine(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public ApacheHttpClient4Engine(HttpClient httpClient, boolean closeHttpClient) {
        this.httpClient = httpClient;
        this.createdHttpClient = closeHttpClient;
    }

    public ApacheHttpClient4Engine(HttpClient httpClient, HttpContext httpContext) {
        this.httpClient = httpClient;
        this.httpContext = httpContext;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public void setHttpContext(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    @Override
    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    @Override
    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public static CaseInsensitiveMap<String> extractHeaders(HttpResponse response) {
        CaseInsensitiveMap headers = new CaseInsensitiveMap();
        for (Header header : response.getAllHeaders()) {
            headers.add(header.getName(), (Object)header.getValue());
        }
        return headers;
    }

    @Override
    public ClientResponse invoke(ClientInvocation request) {
        HttpResponse res;
        String uri = request.getUri().toString();
        HttpRequestBase httpMethod = this.createHttpMethod(uri, request.getMethod());
        try {
            this.loadHttpMethod(request, httpMethod);
            res = this.httpClient.execute((HttpUriRequest)httpMethod, this.httpContext);
        }
        catch (Exception e) {
            throw new ProcessingException("Unable to invoke request", (Throwable)e);
        }
        ClientResponse response = new ClientResponse(request.getClientConfiguration()){
            InputStream stream;
            InputStream hc4Stream;

            @Override
            protected void setInputStream(InputStream is) {
                this.stream = is;
            }

            @Override
            public InputStream getInputStream() {
                if (this.stream == null) {
                    HttpEntity entity = res.getEntity();
                    if (entity == null) {
                        return null;
                    }
                    try {
                        this.hc4Stream = entity.getContent();
                        this.stream = new SelfExpandingBufferredInputStream(this.hc4Stream);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return this.stream;
            }

            @Override
            public void releaseConnection() {
                this.isClosed = true;
                try {
                    if (this.stream != null) {
                        this.stream.close();
                    } else {
                        InputStream is = this.getInputStream();
                        if (is != null) {
                            is.close();
                        }
                    }
                    if (this.hc4Stream != null) {
                        this.hc4Stream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        response.setProperties(request.getMutableProperties());
        response.setStatus(res.getStatusLine().getStatusCode());
        response.setHeaders((MultivaluedMap<String, String>)ApacheHttpClient4Engine.extractHeaders(res));
        response.setClientConfiguration(request.getClientConfiguration());
        return response;
    }

    protected HttpRequestBase createHttpMethod(String url, String restVerb) {
        if ("GET".equals(restVerb)) {
            return new HttpGet(url);
        }
        if ("POST".equals(restVerb)) {
            return new HttpPost(url);
        }
        final String verb = restVerb;
        return new HttpPost(url){

            public String getMethod() {
                return verb;
            }
        };
    }

    protected void loadHttpMethod(final ClientInvocation request, HttpRequestBase httpMethod) throws Exception {
        if (httpMethod instanceof HttpGet) {
            // empty if block
        }
        HttpClientParams.setRedirecting((HttpParams)httpMethod.getParams(), (boolean)false);
        if (request.getEntity() != null) {
            if (httpMethod instanceof HttpGet) {
                throw new ProcessingException("A GET request cannot have a body.");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            request.getDelegatingOutputStream().setDelegate((OutputStream)baos);
            try {
                request.writeRequestBody(request.getEntityStream());
                ByteArrayEntity entity = new ByteArrayEntity(baos.toByteArray()){

                    public Header getContentType() {
                        return new BasicHeader("Content-Type", request.getHeaders().getMediaType().toString());
                    }
                };
                HttpPost post = (HttpPost)httpMethod;
                this.commitHeaders(request, httpMethod);
                post.setEntity((HttpEntity)entity);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.commitHeaders(request, httpMethod);
        }
    }

    protected void commitHeaders(ClientInvocation request, HttpRequestBase httpMethod) {
        MultivaluedMap<String, String> headers = request.getHeaders().asMap();
        for (Map.Entry header : headers.entrySet()) {
            List values = (List)header.getValue();
            for (String value : values) {
                httpMethod.addHeader((String)header.getKey(), value);
            }
        }
    }

    @Override
    public void close() {
        ClientConnectionManager manager;
        if (this.closed) {
            return;
        }
        if (this.createdHttpClient && this.httpClient != null && (manager = this.httpClient.getConnectionManager()) != null) {
            manager.shutdown();
        }
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

