/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.interceptor.InvocationContext;
import javax.ws.rs.client.ResponseProcessingException;
import org.jboss.resteasy.microprofile.client.ExceptionMapping;

public class InvocationContextImpl
implements InvocationContext {
    private final Object target;
    private final Method method;
    private Object[] args;
    private final int position;
    private final Map<String, Object> contextData;
    private final List<InterceptorInvocation> chain;

    public InvocationContextImpl(Object target, Method method, Object[] args, List<InterceptorInvocation> chain) {
        this(target, method, args, chain, 0);
    }

    private InvocationContextImpl(Object target, Method method, Object[] args, List<InterceptorInvocation> chain, int position) {
        this.target = target;
        this.method = method;
        this.args = args;
        this.contextData = new HashMap<String, Object>();
        this.position = position;
        this.chain = chain;
    }

    boolean hasNextInterceptor() {
        return this.position < this.chain.size();
    }

    protected Object invokeNext() throws Exception {
        return this.chain.get(this.position).invoke(this.nextContext());
    }

    private InvocationContext nextContext() {
        return new InvocationContextImpl(this.target, this.method, this.args, this.chain, this.position + 1);
    }

    protected Object interceptorChainCompleted() throws Exception {
        try {
            return this.method.invoke(this.target, this.args);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof ExceptionMapping.HandlerException) {
                ((ExceptionMapping.HandlerException)((Object)e.getCause())).mapException(this.method);
            }
            if (e.getCause() instanceof ResponseProcessingException) {
                ResponseProcessingException rpe = (ResponseProcessingException)e.getCause();
                rpe.getResponse().close();
                Throwable cause = rpe.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
            }
            throw e;
        }
    }

    public Object proceed() throws Exception {
        try {
            if (this.hasNextInterceptor()) {
                return this.invokeNext();
            }
            return this.interceptorChainCompleted();
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public Object getTarget() {
        return this.target;
    }

    public Method getMethod() {
        return this.method;
    }

    public Constructor<?> getConstructor() {
        return null;
    }

    public Object[] getParameters() throws IllegalStateException {
        return this.args;
    }

    public void setParameters(Object[] params) throws IllegalStateException, IllegalArgumentException {
        this.args = params;
    }

    public Map<String, Object> getContextData() {
        return this.contextData;
    }

    public Object getTimer() {
        return null;
    }

    public static class InterceptorInvocation {
        private final Interceptor interceptor;
        private final Object interceptorInstance;

        public InterceptorInvocation(Interceptor<?> interceptor, Object interceptorInstance) {
            this.interceptor = interceptor;
            this.interceptorInstance = interceptorInstance;
        }

        Object invoke(InvocationContext ctx) throws Exception {
            return this.interceptor.intercept(InterceptionType.AROUND_INVOKE, this.interceptorInstance, ctx);
        }
    }
}

