/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client;

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.WithAnnotations;
import org.eclipse.microprofile.rest.client.inject.RegisterRestClient;
import org.jboss.resteasy.microprofile.client.RestClientDelegateBean;

public class RestClientExtension
implements Extension {
    private Set<RestClientData> proxyTypes = new LinkedHashSet<RestClientData>();
    private Set<Throwable> errors = new LinkedHashSet<Throwable>();

    public void registerRestClient(@Observes @WithAnnotations(value={RegisterRestClient.class}) ProcessAnnotatedType<?> type) {
        Class javaClass = type.getAnnotatedType().getJavaClass();
        if (javaClass.isInterface()) {
            RegisterRestClient annotation = (RegisterRestClient)type.getAnnotatedType().getAnnotation(RegisterRestClient.class);
            Optional<String> maybeUri = this.extractBaseUri(annotation);
            Optional<String> maybeConfigKey = this.extractConfigKey(annotation);
            this.proxyTypes.add(new RestClientData(javaClass, maybeUri, maybeConfigKey));
            type.veto();
        } else {
            this.errors.add(new IllegalArgumentException("Rest client needs to be an interface " + javaClass));
        }
    }

    private Optional<String> extractBaseUri(RegisterRestClient annotation) {
        String baseUri = annotation.baseUri();
        return Optional.ofNullable("".equals(baseUri) ? null : baseUri);
    }

    private Optional<String> extractConfigKey(RegisterRestClient annotation) {
        String configKey = annotation.configKey();
        return Optional.ofNullable("".equals(configKey) ? null : configKey);
    }

    public void createProxy(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        for (RestClientData clientData : this.proxyTypes) {
            afterBeanDiscovery.addBean((Bean)new RestClientDelegateBean(clientData.javaClass, beanManager, clientData.baseUri, clientData.configKey));
        }
    }

    public void reportErrors(@Observes AfterDeploymentValidation afterDeploymentValidation) {
        for (Throwable error : this.errors) {
            afterDeploymentValidation.addDeploymentProblem(error);
        }
    }

    private static class RestClientData {
        private final Class<?> javaClass;
        private final Optional<String> baseUri;
        private final Optional<String> configKey;

        private RestClientData(Class<?> javaClass, Optional<String> baseUri, Optional<String> configKey) {
            this.javaClass = javaClass;
            this.baseUri = baseUri;
            this.configKey = configKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RestClientData that = (RestClientData)o;
            return this.javaClass.equals(that.javaClass);
        }

        public int hashCode() {
            return Objects.hash(this.javaClass);
        }
    }
}

