/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.config;

import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.microprofile.config.ResteasyConfigSource;

public class FilterConfigSource
implements ResteasyConfigSource {
    private volatile String name;

    public Map<String, String> getProperties() {
        FilterConfig config = (FilterConfig)ResteasyContext.getContextData(FilterConfig.class);
        if (config == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Enumeration keys = config.getInitParameterNames();
        if (keys != null) {
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                map.put(key, config.getInitParameter(key));
            }
        }
        return map;
    }

    public Set<String> getPropertyNames() {
        FilterConfig config = (FilterConfig)ResteasyContext.getContextData(FilterConfig.class);
        if (config == null) {
            return Collections.emptySet();
        }
        return new LinkedHashSet<String>(Collections.list(config.getInitParameterNames()));
    }

    public String getValue(String propertyName) {
        FilterConfig config = (FilterConfig)ResteasyContext.getContextData(FilterConfig.class);
        if (config == null) {
            return null;
        }
        return config.getInitParameter(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        String currentName = this.name;
        if (currentName == null) {
            FilterConfigSource filterConfigSource = this;
            synchronized (filterConfigSource) {
                currentName = this.name;
                if (currentName == null) {
                    ServletContext servletContext = (ServletContext)ResteasyContext.getContextData(ServletContext.class);
                    FilterConfig filterConfig = (FilterConfig)ResteasyContext.getContextData(FilterConfig.class);
                    StringBuilder sb = new StringBuilder();
                    this.name = currentName = sb.append(servletContext != null ? servletContext.getServletContextName() : null).append(':').append(filterConfig != null ? filterConfig.getFilterName() : null).append(":FilterConfigSource").toString();
                }
            }
        }
        return currentName;
    }

    @Override
    public int getDefaultOrdinal() {
        return 50;
    }
}

