/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.resteasy752;

import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.Suspend;
import org.jboss.resteasy.spi.AsynchronousResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class TestResource {
    public static final int SERVLET_TIMEOUT = 10000;
    public static final int SERVLET_EXTRA_TIME = 10000;
    private static final Logger log = LoggerFactory.getLogger(TestResource.class);
    private static int counter = 0;
    private ExecutorService _executor = Executors.newSingleThreadExecutor();

    public TestResource() {
        log.info("console, in ctor()");
    }

    @GET
    @Path(value="/timeoutStacks")
    public void timeoutStacksMultipleResponses(final @Suspend(value=10000L) AsynchronousResponse response) throws InterruptedException {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                if (counter++ % 2 == 0) {
                    try {
                        int sleeper = 20000;
                        log.info(this + " forcing timeout by sleeping for " + sleeper + "ms: " + new Date());
                        Thread.sleep(sleeper);
                        log.info(this + " woke up: " + new Date());
                    }
                    catch (InterruptedException e) {
                        log.info("interrupted: " + Thread.interrupted());
                    }
                }
                try {
                    log.info(this + " writing response");
                    Date date = new Date();
                    response.setResponse(Response.ok((Object)(this + " string returned at " + date + "\n")).build());
                }
                catch (Exception e) {
                    log.debug("failed setting response", (Throwable)e);
                }
            }
        };
        this._executor.submit(runner);
    }
}

