/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Attachments;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.ConnectionImpl;
import org.jboss.remoting3.DuplicateRegistrationException;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.HandleableCloseable;
import org.jboss.remoting3.LocalConnectionProvider;
import org.jboss.remoting3.NotOpenException;
import org.jboss.remoting3.OpenListener;
import org.jboss.remoting3.Registration;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3.ServiceRegistrationException;
import org.jboss.remoting3.UnknownURISchemeException;
import org.jboss.remoting3.UnlockedReadHashMap;
import org.jboss.remoting3.Version;
import org.jboss.remoting3.security.PasswordClientCallbackHandler;
import org.jboss.remoting3.security.RemotingPermission;
import org.jboss.remoting3.spi.AbstractHandleableCloseable;
import org.jboss.remoting3.spi.ConnectionHandlerContext;
import org.jboss.remoting3.spi.ConnectionHandlerFactory;
import org.jboss.remoting3.spi.ConnectionProvider;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.jboss.remoting3.spi.ConnectionProviderFactory;
import org.jboss.remoting3.spi.SpiUtils;
import org.xnio.Cancellable;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Result;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.ssl.JsseXnioSsl;
import org.xnio.ssl.XnioSsl;

final class EndpointImpl
extends AbstractHandleableCloseable<Endpoint>
implements Endpoint {
    private static final Logger log;
    private static final RemotingPermission REGISTER_SERVICE_PERM;
    private static final RemotingPermission CONNECT_PERM;
    private static final RemotingPermission ADD_CONNECTION_PROVIDER_PERM;
    private static final RemotingPermission GET_CONNECTION_PROVIDER_INTERFACE_PERM;
    private static final int CLOSED_FLAG = Integer.MIN_VALUE;
    private static final int COUNT_MASK = Integer.MAX_VALUE;
    private static final String FQCN;
    private final Set<ConnectionImpl> connections = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
    private final Attachments attachments = new Attachments();
    private final ConcurrentMap<String, ConnectionProvider> connectionProviders = new UnlockedReadHashMap<String, ConnectionProvider>();
    private final ConcurrentMap<String, OpenListener> registeredServices = new UnlockedReadHashMap<String, OpenListener>();
    private final Xnio xnio;
    private final XnioWorker worker;
    private static final AtomicIntegerFieldUpdater<EndpointImpl> resourceCountUpdater;
    private volatile int resourceCount = 0;
    private static final Pattern VALID_SERVICE_PATTERN;
    private final String name;
    private final OptionMap optionMap;
    private final ConnectionProviderContext connectionProviderContext;
    private final CloseHandler<Object> resourceCloseHandler = new CloseHandler<Object>(){

        @Override
        public void handleClose(Object closed, IOException exception) {
            EndpointImpl.this.closeTick1(closed);
        }
    };
    private final ConnectionCloseHandler connectionCloseHandler = new ConnectionCloseHandler();
    private static final Charset UTF_8;
    private static final UserAndRealm EMPTY;

    private EndpointImpl(Xnio xnio, XnioWorker xnioWorker, String name, OptionMap optionMap, HoldingRunnable holdingRunnable) throws IOException {
        super((Executor)xnioWorker);
        holdingRunnable.setTask(new Runnable(){

            @Override
            public void run() {
                EndpointImpl.this.closeComplete();
            }
        });
        this.worker = xnioWorker;
        this.xnio = xnio;
        this.name = name;
        this.optionMap = optionMap;
        this.connectionProviderContext = new ConnectionProviderContextImpl();
        this.connectionProviders.put("local", new LocalConnectionProvider(this.connectionProviderContext, (Executor)this.worker));
        log.tracef("Completed open of %s", (Object)this);
    }

    static EndpointImpl construct(Xnio xnio, String name, OptionMap optionMap) throws IOException {
        HoldingRunnable holdingRunnable = new HoldingRunnable();
        XnioWorker xnioWorker = xnio.createWorker(null, OptionMap.builder().addAll(optionMap).set(Options.WORKER_NAME, (Object)(name == null ? "Remoting (anonymous)" : "Remoting \"" + name + "\"")).getMap(), (Runnable)holdingRunnable);
        return new EndpointImpl(xnio, xnioWorker, name, optionMap, holdingRunnable);
    }

    @Override
    public Attachments getAttachments() {
        return this.attachments;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Executor getExecutor() {
        return this.worker;
    }

    private void closeTick1(Object c) {
        int res = resourceCountUpdater.decrementAndGet(this);
        if (res == Integer.MIN_VALUE) {
            this.finishPhase1();
        } else if ((res & Integer.MIN_VALUE) != 0) {
            if (log.isTraceEnabled()) {
                log.logf(FQCN, Logger.Level.TRACE, null, "Phase 1 shutdown count %08x of %s (closed %s)", (Object)(res & Integer.MAX_VALUE), (Object)this, c);
            }
        } else if (log.isTraceEnabled()) {
            log.logf(FQCN, Logger.Level.TRACE, null, "Resource closed count %08x of %s (closed %s)", (Object)(res & Integer.MAX_VALUE), (Object)this, c);
        }
    }

    private void finishPhase1() {
        log.tracef("Finished phase 1 shutdown of %s", (Object)this);
        this.worker.shutdown();
    }

    void resourceUntick(Object opened) throws NotOpenException {
        int old;
        do {
            if (((old = resourceCountUpdater.get(this)) & Integer.MIN_VALUE) == 0) continue;
            throw new NotOpenException("Endpoint is not open");
        } while (!resourceCountUpdater.compareAndSet(this, old, old + 1));
        if (log.isTraceEnabled()) {
            log.tracef("Allocated tick to %d of %s (opened %s)", (Object)(old + 1), (Object)this, opened);
        }
    }

    @Override
    protected void closeAction() throws IOException {
        int res;
        while (!resourceCountUpdater.compareAndSet(this, res = this.resourceCount, res | Integer.MIN_VALUE)) {
        }
        if (res == 0) {
            this.finishPhase1();
        } else {
            for (Object connection : this.connections.toArray()) {
                ((ConnectionImpl)connection).closeAsync();
            }
            for (ConnectionProvider connectionProvider : this.connectionProviders.values()) {
                connectionProvider.closeAsync();
            }
        }
    }

    @Override
    public Registration registerService(String serviceType, final OpenListener openListener, OptionMap optionMap) throws ServiceRegistrationException {
        OpenListener existing;
        if (!VALID_SERVICE_PATTERN.matcher(serviceType).matches()) {
            throw new IllegalArgumentException("Service type must match " + VALID_SERVICE_PATTERN);
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(REGISTER_SERVICE_PERM);
        }
        if ((existing = this.registeredServices.putIfAbsent(serviceType, openListener)) != null) {
            throw new ServiceRegistrationException("Service type '" + serviceType + "' is already registered");
        }
        MapRegistration<OpenListener> registration = new MapRegistration<OpenListener>(this.registeredServices, serviceType, openListener){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void closeAction() throws IOException {
                try {
                    openListener.registrationTerminated();
                }
                finally {
                    super.closeAction();
                }
            }
        };
        final HandleableCloseable.Key key = this.addCloseHandler(SpiUtils.closingCloseHandler(registration));
        registration.addCloseHandler(new CloseHandler<Registration>(){

            @Override
            public void handleClose(Registration closed, IOException exception) {
                key.remove();
            }
        });
        return registration;
    }

    private IoFuture<Connection> doConnect(URI uri, OptionMap connectOptions, CallbackHandler callbackHandler, XnioSsl xnioSsl) throws IOException {
        int destinationPort;
        String scheme = uri.getScheme();
        String destinationHost = uri.getHost();
        InetSocketAddress destination = destinationHost != null ? new InetSocketAddress(destinationHost, (destinationPort = uri.getPort()) == -1 ? 0 : destinationPort) : null;
        return this.doConnect(scheme, null, destination, connectOptions, callbackHandler, xnioSsl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IoFuture<Connection> doConnect(String scheme, SocketAddress bindAddress, SocketAddress destination, OptionMap connectOptions, CallbackHandler callbackHandler, XnioSsl xnioSsl) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CONNECT_PERM);
        }
        boolean ok = false;
        this.resourceUntick("Connection to " + destination);
        try {
            ConnectionProvider connectionProvider = (ConnectionProvider)this.connectionProviders.get(scheme);
            if (connectionProvider == null) {
                throw new UnknownURISchemeException("No connection provider for URI scheme \"" + scheme + "\" is installed");
            }
            final FutureResult futureResult = new FutureResult(this.getExecutor());
            final StackTraceElement[] mark = Thread.currentThread().getStackTrace();
            Cancellable connect = connectionProvider.connect(bindAddress, destination, connectOptions, new Result<ConnectionHandlerFactory>(){
                private final AtomicBoolean called = new AtomicBoolean();

                public boolean setResult(ConnectionHandlerFactory result) {
                    if (this.called.getAndSet(true)) {
                        log.logf(this.getClass().getName(), Logger.Level.TRACE, null, "Got redundant complete result %s", (Object)result);
                        return false;
                    }
                    log.logf(this.getClass().getName(), Logger.Level.TRACE, null, "Registered successful result %s", (Object)result);
                    ConnectionImpl connection = new ConnectionImpl(EndpointImpl.this, result, EndpointImpl.this.connectionProviderContext);
                    EndpointImpl.this.connections.add(connection);
                    connection.getConnectionHandler().addCloseHandler(SpiUtils.asyncClosingCloseHandler(connection));
                    connection.addCloseHandler(EndpointImpl.this.resourceCloseHandler);
                    connection.addCloseHandler(EndpointImpl.this.connectionCloseHandler);
                    return futureResult.setResult((Object)connection);
                }

                public boolean setException(IOException exception) {
                    if (this.called.getAndSet(true)) {
                        log.logf(this.getClass().getName(), Logger.Level.TRACE, (Throwable)exception, "Got redundant exception result", new Object[0]);
                        return false;
                    }
                    log.logf(this.getClass().getName(), Logger.Level.TRACE, (Throwable)exception, "Registered exception result", new Object[0]);
                    EndpointImpl.this.closeTick1("a failed connection (2)");
                    SpiUtils.glueStackTraces(exception, mark, 1, "asynchronous invocation");
                    return futureResult.setException(exception);
                }

                public boolean setCancelled() {
                    if (this.called.getAndSet(true)) {
                        log.logf(this.getClass().getName(), Logger.Level.TRACE, null, "Got redundant cancellation result", new Object[0]);
                        return false;
                    }
                    log.logf(this.getClass().getName(), Logger.Level.TRACE, null, "Registered cancellation result", new Object[0]);
                    EndpointImpl.this.closeTick1("a cancelled connection");
                    return futureResult.setCancelled();
                }
            }, callbackHandler, xnioSsl);
            ok = true;
            futureResult.addCancelHandler(connect);
            IoFuture ioFuture = futureResult.getIoFuture();
            return ioFuture;
        }
        finally {
            if (!ok) {
                this.closeTick1("a failed connection (1)");
            }
        }
    }

    @Override
    public IoFuture<Connection> connect(URI destination) throws IOException {
        UserAndRealm userRealm = this.getUserAndRealm(destination);
        String uriUserName = userRealm.getUser();
        String uriUserRealm = userRealm.getRealm();
        OptionMap.Builder builder = OptionMap.builder();
        if (uriUserName != null) {
            builder.set(RemotingOptions.AUTHORIZE_ID, (Object)uriUserName);
        }
        if (uriUserRealm != null) {
            builder.set(RemotingOptions.AUTH_REALM, (Object)uriUserRealm);
        }
        OptionMap finalMap = builder.getMap();
        return this.doConnect(destination, finalMap, new PasswordClientCallbackHandler((String)finalMap.get(RemotingOptions.AUTHORIZE_ID), (String)finalMap.get(RemotingOptions.AUTH_REALM), null), null);
    }

    @Override
    public IoFuture<Connection> connect(URI destination, OptionMap connectOptions) throws IOException {
        UserAndRealm userRealm = this.getUserAndRealm(destination);
        String uriUserName = userRealm.getUser();
        String uriUserRealm = userRealm.getRealm();
        OptionMap.Builder builder = OptionMap.builder().addAll(connectOptions);
        if (uriUserName != null) {
            builder.set(RemotingOptions.AUTHORIZE_ID, (Object)uriUserName);
        }
        if (uriUserRealm != null) {
            builder.set(RemotingOptions.AUTH_REALM, (Object)uriUserRealm);
        }
        OptionMap finalMap = builder.getMap();
        return this.doConnect(destination, finalMap, new PasswordClientCallbackHandler((String)finalMap.get(RemotingOptions.AUTHORIZE_ID), (String)finalMap.get(RemotingOptions.AUTH_REALM), null), null);
    }

    @Override
    public IoFuture<Connection> connect(URI destination, OptionMap connectOptions, CallbackHandler callbackHandler) throws IOException {
        return this.connect(destination, connectOptions, callbackHandler, (XnioSsl)null);
    }

    @Override
    public IoFuture<Connection> connect(URI destination, OptionMap connectOptions, CallbackHandler callbackHandler, SSLContext sslContext) throws IOException {
        return this.connect(destination, connectOptions, callbackHandler, (XnioSsl)(sslContext == null ? (XnioSsl)null : new JsseXnioSsl(this.xnio, this.optionMap, sslContext)));
    }

    @Override
    public IoFuture<Connection> connect(URI destination, OptionMap connectOptions, CallbackHandler callbackHandler, XnioSsl xnioSsl) throws IOException {
        UserAndRealm userRealm = this.getUserAndRealm(destination);
        String uriUserName = userRealm.getUser();
        String uriUserRealm = userRealm.getRealm();
        OptionMap.Builder builder = OptionMap.builder().addAll(connectOptions);
        if (uriUserName != null) {
            builder.set(RemotingOptions.AUTHORIZE_ID, (Object)uriUserName);
        }
        if (uriUserRealm != null) {
            builder.set(RemotingOptions.AUTH_REALM, (Object)uriUserRealm);
        }
        OptionMap finalMap = builder.getMap();
        return this.doConnect(destination, finalMap, callbackHandler, xnioSsl);
    }

    @Override
    public IoFuture<Connection> connect(URI destination, OptionMap connectOptions, String userName, String realmName, char[] password) throws IOException {
        return this.connect(destination, connectOptions, userName, realmName, password, (XnioSsl)null);
    }

    @Override
    public IoFuture<Connection> connect(URI destination, OptionMap connectOptions, String userName, String realmName, char[] password, SSLContext sslContext) throws IOException {
        return this.connect(destination, connectOptions, userName, realmName, password, (XnioSsl)(sslContext == null ? (XnioSsl)null : new JsseXnioSsl(this.xnio, this.optionMap, sslContext)));
    }

    @Override
    public IoFuture<Connection> connect(URI destination, OptionMap connectOptions, String userName, String realmName, char[] password, XnioSsl xnioSsl) throws IOException {
        String actualUserName;
        UserAndRealm userRealm = this.getUserAndRealm(destination);
        String uriUserName = userRealm.getUser();
        String uriUserRealm = userRealm.getRealm();
        String string = userName != null ? userName : (actualUserName = uriUserName != null ? uriUserName : (String)connectOptions.get(RemotingOptions.AUTHORIZE_ID));
        String actualUserRealm = realmName != null ? realmName : (uriUserRealm != null ? uriUserRealm : (String)connectOptions.get(RemotingOptions.AUTH_REALM));
        OptionMap.Builder builder = OptionMap.builder().addAll(connectOptions);
        if (actualUserName != null) {
            builder.set(RemotingOptions.AUTHORIZE_ID, (Object)actualUserName);
        }
        if (actualUserRealm != null) {
            builder.set(RemotingOptions.AUTH_REALM, (Object)actualUserRealm);
        }
        OptionMap finalMap = builder.getMap();
        return this.doConnect(destination, finalMap, new PasswordClientCallbackHandler(actualUserName, actualUserRealm, password), xnioSsl);
    }

    @Override
    public IoFuture<Connection> connect(String protocol, SocketAddress bindAddress, SocketAddress destination) throws IOException {
        return this.doConnect(protocol, bindAddress, destination, OptionMap.EMPTY, null, null);
    }

    @Override
    public IoFuture<Connection> connect(String protocol, SocketAddress bindAddress, SocketAddress destination, OptionMap connectOptions) throws IOException {
        return this.doConnect(protocol, bindAddress, destination, connectOptions, null, null);
    }

    @Override
    public IoFuture<Connection> connect(String protocol, SocketAddress bindAddress, SocketAddress destination, OptionMap connectOptions, CallbackHandler callbackHandler) throws IOException {
        return this.doConnect(protocol, bindAddress, destination, connectOptions, callbackHandler, null);
    }

    @Override
    public IoFuture<Connection> connect(String protocol, SocketAddress bindAddress, SocketAddress destination, OptionMap connectOptions, CallbackHandler callbackHandler, SSLContext sslContext) throws IOException {
        return this.doConnect(protocol, bindAddress, destination, connectOptions, callbackHandler, (XnioSsl)(sslContext == null ? (XnioSsl)null : new JsseXnioSsl(this.xnio, this.optionMap, sslContext)));
    }

    @Override
    public IoFuture<Connection> connect(String protocol, SocketAddress bindAddress, SocketAddress destination, OptionMap connectOptions, CallbackHandler callbackHandler, XnioSsl xnioSsl) throws IOException {
        return this.doConnect(protocol, bindAddress, destination, connectOptions, callbackHandler, xnioSsl);
    }

    @Override
    public IoFuture<Connection> connect(String protocol, SocketAddress bindAddress, SocketAddress destination, OptionMap connectOptions, String userName, String realmName, char[] password) throws IOException {
        return this.connect(protocol, bindAddress, destination, connectOptions, userName, realmName, password, (XnioSsl)null);
    }

    @Override
    public IoFuture<Connection> connect(String protocol, SocketAddress bindAddress, SocketAddress destination, OptionMap connectOptions, String userName, String realmName, char[] password, SSLContext sslContext) throws IOException {
        return this.connect(protocol, bindAddress, destination, connectOptions, userName, realmName, password, (XnioSsl)(sslContext == null ? (XnioSsl)null : new JsseXnioSsl(this.xnio, this.optionMap, sslContext)));
    }

    @Override
    public IoFuture<Connection> connect(String protocol, SocketAddress bindAddress, SocketAddress destination, OptionMap connectOptions, String userName, String realmName, char[] password, XnioSsl xnioSsl) throws IOException {
        OptionMap.Builder builder = OptionMap.builder().addAll(connectOptions);
        if (userName != null) {
            builder.set(RemotingOptions.AUTHORIZE_ID, (Object)userName);
        } else {
            userName = (String)this.optionMap.get(RemotingOptions.AUTHORIZE_ID);
        }
        if (realmName != null) {
            builder.set(RemotingOptions.AUTH_REALM, (Object)realmName);
        } else {
            realmName = (String)this.optionMap.get(RemotingOptions.AUTH_REALM);
        }
        OptionMap finalMap = builder.getMap();
        return this.doConnect(protocol, bindAddress, destination, finalMap, new PasswordClientCallbackHandler(userName, realmName, password), xnioSsl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Registration addConnectionProvider(String uriScheme, ConnectionProviderFactory providerFactory, OptionMap optionMap) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ADD_CONNECTION_PROVIDER_PERM);
        }
        boolean ok = false;
        this.resourceUntick("Connection provider for " + uriScheme);
        try {
            MapRegistration<ConnectionProvider> mapRegistration;
            block10: {
                ConnectionProviderContextImpl context = new ConnectionProviderContextImpl();
                final ConnectionProvider provider = providerFactory.createInstance(context, optionMap);
                try {
                    if (this.connectionProviders.putIfAbsent(uriScheme, provider) != null) {
                        throw new DuplicateRegistrationException("URI scheme '" + uriScheme + "' is already registered to a provider");
                    }
                    log.tracef("Adding connection provider registration named '%s': %s", (Object)uriScheme, (Object)provider);
                    final MapRegistration<ConnectionProvider> registration = new MapRegistration<ConnectionProvider>(this.connectionProviders, uriScheme, provider){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        protected void closeAction() throws IOException {
                            try {
                                provider.closeAsync();
                            }
                            finally {
                                super.closeAction();
                            }
                        }
                    };
                    provider.addCloseHandler(new CloseHandler<ConnectionProvider>(){

                        @Override
                        public void handleClose(ConnectionProvider closed, IOException exception) {
                            registration.closeAsync();
                            EndpointImpl.this.closeTick1(closed);
                        }
                    });
                    ok = true;
                    mapRegistration = registration;
                    if (ok) break block10;
                }
                catch (Throwable throwable) {
                    if (!ok) {
                        provider.close();
                    }
                    throw throwable;
                }
                provider.close();
            }
            return mapRegistration;
        }
        finally {
            if (!ok) {
                this.closeTick1("Connection provider for " + uriScheme);
            }
        }
    }

    @Override
    public <T> T getConnectionProviderInterface(String uriScheme, Class<T> expectedType) throws UnknownURISchemeException, ClassCastException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONNECTION_PROVIDER_INTERFACE_PERM);
        }
        if (!expectedType.isInterface()) {
            throw new IllegalArgumentException("Interface expected");
        }
        ConnectionProvider provider = (ConnectionProvider)this.connectionProviders.get(uriScheme);
        if (provider == null) {
            throw new UnknownURISchemeException("No connection provider for URI scheme \"" + uriScheme + "\" is installed");
        }
        return expectedType.cast(provider.getProviderInterface());
    }

    @Override
    public boolean isValidUriScheme(String uriScheme) {
        return this.connectionProviders.containsKey(uriScheme);
    }

    @Override
    public XnioWorker getXnioWorker() {
        return this.worker;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("endpoint ");
        if (this.name != null) {
            b.append('\"').append(this.name).append('\"');
        } else {
            b.append("(anonymous)");
        }
        b.append(" <").append(Integer.toHexString(this.hashCode())).append(">");
        return b.toString();
    }

    private static String uriDecode(String encoded) {
        char[] chars = encoded.toCharArray();
        int olen = chars.length;
        byte[] buf = new byte[olen];
        int c = 0;
        for (int i = 0; i < olen; ++i) {
            char ch = chars[i];
            if (ch == '%') {
                buf[c++] = (byte)(Character.digit(chars[++i], 16) << 4 | Character.digit(chars[++i], 16));
                continue;
            }
            if (ch < ' ' || ch > '\u007f') continue;
            buf[c++] = (byte)ch;
        }
        return new String(buf, 0, c, UTF_8);
    }

    private UserAndRealm getUserAndRealm(URI uri) {
        String userInfo = uri.getRawUserInfo();
        if (userInfo == null) {
            return EMPTY;
        }
        int i = userInfo.indexOf(59);
        if (i == -1) {
            return new UserAndRealm(uri.getUserInfo(), null);
        }
        return new UserAndRealm(EndpointImpl.uriDecode(userInfo.substring(0, i)), EndpointImpl.uriDecode(userInfo.substring(i + 1)));
    }

    static {
        Logger.getLogger((String)"org.jboss.remoting").infof("JBoss Remoting version %s", (Object)Version.VERSION);
        log = Logger.getLogger((String)"org.jboss.remoting.endpoint");
        REGISTER_SERVICE_PERM = new RemotingPermission("registerService");
        CONNECT_PERM = new RemotingPermission("connect");
        ADD_CONNECTION_PROVIDER_PERM = new RemotingPermission("addConnectionProvider");
        GET_CONNECTION_PROVIDER_INTERFACE_PERM = new RemotingPermission("getConnectionProviderInterface");
        FQCN = EndpointImpl.class.getName();
        resourceCountUpdater = AtomicIntegerFieldUpdater.newUpdater(EndpointImpl.class, "resourceCount");
        VALID_SERVICE_PATTERN = Pattern.compile("[-.:a-zA-Z_0-9]+");
        UTF_8 = Charset.forName("UTF-8");
        EMPTY = new UserAndRealm(null, null);
    }

    private static class HoldingRunnable
    implements Runnable {
        private volatile Runnable task;

        private HoldingRunnable() {
        }

        public void setTask(Runnable task) {
            this.task = task;
        }

        @Override
        public void run() {
            Runnable task = this.task;
            if (task != null) {
                task.run();
            }
        }
    }

    private class ConnectionCloseHandler
    implements CloseHandler<Connection> {
        private ConnectionCloseHandler() {
        }

        @Override
        public void handleClose(Connection closed, IOException exception) {
            EndpointImpl.this.connections.remove(closed);
        }
    }

    private final class ConnectionProviderContextImpl
    implements ConnectionProviderContext {
        private ConnectionProviderContextImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(ConnectionHandlerFactory connectionHandlerFactory) {
            try {
                EndpointImpl.this.resourceUntick("an inbound connection");
            }
            catch (NotOpenException e) {
                throw new IllegalStateException("Accept after endpoint close", e);
            }
            boolean ok = false;
            try {
                ConnectionImpl connection = new ConnectionImpl(EndpointImpl.this, connectionHandlerFactory, this);
                EndpointImpl.this.connections.add(connection);
                connection.getConnectionHandler().addCloseHandler(SpiUtils.asyncClosingCloseHandler(connection));
                connection.addCloseHandler(EndpointImpl.this.connectionCloseHandler);
                connection.addCloseHandler(EndpointImpl.this.resourceCloseHandler);
                ok = true;
            }
            finally {
                if (!ok) {
                    EndpointImpl.this.closeTick1("a failed inbound connection");
                }
            }
        }

        @Override
        public Endpoint getEndpoint() {
            return EndpointImpl.this;
        }

        @Override
        public Xnio getXnio() {
            return EndpointImpl.this.xnio;
        }

        @Override
        public Executor getExecutor() {
            return EndpointImpl.this.worker;
        }

        @Override
        public XnioWorker getXnioWorker() {
            return EndpointImpl.this.worker;
        }
    }

    final class LocalConnectionContext
    implements ConnectionHandlerContext {
        private final ConnectionProviderContext connectionProviderContext;
        private final Connection connection;

        LocalConnectionContext(ConnectionProviderContext connectionProviderContext, Connection connection) {
            this.connectionProviderContext = connectionProviderContext;
            this.connection = connection;
        }

        @Override
        public ConnectionProviderContext getConnectionProviderContext() {
            return this.connectionProviderContext;
        }

        @Override
        public OpenListener getServiceOpenListener(String serviceType) {
            return (OpenListener)EndpointImpl.this.registeredServices.get(serviceType);
        }

        @Override
        public Connection getConnection() {
            return this.connection;
        }

        @Override
        public void remoteClosed() {
            this.connection.closeAsync();
        }
    }

    private class MapRegistration<T>
    extends AbstractHandleableCloseable<Registration>
    implements Registration {
        private final ConcurrentMap<String, T> map;
        private final String key;
        private final T value;

        private MapRegistration(ConcurrentMap<String, T> map, String key, T value) {
            super((Executor)EndpointImpl.this.worker, false);
            this.map = map;
            this.key = key;
            this.value = value;
        }

        @Override
        protected void closeAction() throws IOException {
            this.map.remove(this.key, this.value);
            this.closeComplete();
        }

        @Override
        public void close() {
            try {
                super.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        public String toString() {
            return String.format("Registration of '%s': %s", this.key, this.value);
        }
    }

    static final class UserAndRealm {
        private final String user;
        private final String realm;

        UserAndRealm(String user, String realm) {
            this.user = user;
            this.realm = realm;
        }

        public String getUser() {
            return this.user;
        }

        public String getRealm() {
            return this.realm;
        }
    }
}

