/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.regex.Pattern;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Attachments;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.ConnectionImpl;
import org.jboss.remoting3.DuplicateRegistrationException;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.HandleableCloseable;
import org.jboss.remoting3.LocalConnectionProvider;
import org.jboss.remoting3.NotOpenException;
import org.jboss.remoting3.OpenListener;
import org.jboss.remoting3.Registration;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3.ServiceNotFoundException;
import org.jboss.remoting3.ServiceRegistrationException;
import org.jboss.remoting3.UnknownURISchemeException;
import org.jboss.remoting3.UnlockedReadHashMap;
import org.jboss.remoting3.Version;
import org.jboss.remoting3.security.PasswordClientCallbackHandler;
import org.jboss.remoting3.security.RemotingPermission;
import org.jboss.remoting3.spi.AbstractHandleableCloseable;
import org.jboss.remoting3.spi.ConnectionHandlerContext;
import org.jboss.remoting3.spi.ConnectionHandlerFactory;
import org.jboss.remoting3.spi.ConnectionProvider;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.jboss.remoting3.spi.ConnectionProviderFactory;
import org.jboss.remoting3.spi.SpiUtils;
import org.xnio.Cancellable;
import org.xnio.ChannelThread;
import org.xnio.ChannelThreadPool;
import org.xnio.ChannelThreadPools;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.ReadChannelThread;
import org.xnio.Result;
import org.xnio.WriteChannelThread;
import org.xnio.Xnio;

final class EndpointImpl
extends AbstractHandleableCloseable<Endpoint>
implements Endpoint {
    private static final Logger log;
    private static final RemotingPermission REGISTER_SERVICE_PERM;
    private static final RemotingPermission CONNECT_PERM;
    private static final RemotingPermission ADD_CONNECTION_PROVIDER_PERM;
    private static final RemotingPermission GET_CONNECTION_PROVIDER_INTERFACE_PERM;
    private static final int CLOSED_FLAG = Integer.MIN_VALUE;
    private static final int COUNT_MASK = Integer.MAX_VALUE;
    private final Set<ConnectionImpl> connections;
    private final Attachments attachments;
    private final ConcurrentMap<String, ConnectionProvider> connectionProviders;
    private final ConcurrentMap<String, OpenListener> registeredServices;
    private final Xnio xnio;
    private final ChannelThreadPool<ReadChannelThread> readPool;
    private final ChannelThreadPool<WriteChannelThread> writePool;
    private final ThreadPoolExecutor executor;
    private static final AtomicIntegerFieldUpdater<EndpointImpl> resourceCountUpdater;
    private volatile int resourceCount;
    private static final Pattern VALID_SERVICE_PATTERN;
    private final String name;
    private final OptionMap optionMap;
    private final ConnectionProviderContext connectionProviderContext;
    private final CloseHandler<Object> resourceCloseHandler;
    private final ConnectionCloseHandler connectionCloseHandler;
    private static final Charset UTF_8;
    private static final UserAndRealm EMPTY;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EndpointImpl(Pool executor, Xnio xnio, String name, OptionMap optionMap) throws IOException {
        ChannelThreadPool writePool;
        ChannelThreadPool readPool;
        block16: {
            block17: {
                super(executor);
                this.connections = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
                this.attachments = new Attachments();
                this.connectionProviders = new UnlockedReadHashMap<String, ConnectionProvider>();
                this.registeredServices = new UnlockedReadHashMap<String, OpenListener>();
                this.resourceCount = 0;
                this.resourceCloseHandler = new CloseHandler<Object>(){

                    @Override
                    public void handleClose(Object closed, IOException exception) {
                        EndpointImpl.this.closeTick1(closed);
                    }
                };
                this.connectionCloseHandler = new ConnectionCloseHandler();
                executor.stopTask = new Runnable(){

                    @Override
                    public void run() {
                        log.tracef("Finished final shutdown of %s", (Object)EndpointImpl.this);
                        EndpointImpl.this.closeComplete();
                    }
                };
                executor.allowCoreThreadTimeOut(true);
                this.executor = executor;
                if (xnio == null) {
                    throw new IllegalArgumentException("xnio is null");
                }
                if (optionMap == null) {
                    throw new IllegalArgumentException("optionMap is null");
                }
                this.xnio = xnio;
                this.name = name;
                this.optionMap = optionMap;
                this.connectionProviderContext = new ConnectionProviderContextImpl();
                this.connectionProviders.put("local", new LocalConnectionProvider(this.connectionProviderContext, executor));
                int readPoolSize = optionMap.get(RemotingOptions.READ_THREAD_POOL_SIZE, 1);
                if (readPoolSize < 1) {
                    throw new IllegalArgumentException("Read thread pool must have at least one thread");
                }
                int writePoolSize = optionMap.get(RemotingOptions.WRITE_THREAD_POOL_SIZE, 1);
                if (writePoolSize < 1) {
                    throw new IllegalArgumentException("Write thread pool must have at least one thread");
                }
                boolean ok = false;
                readPool = null;
                writePool = null;
                try {
                    int i;
                    if (readPoolSize == 1) {
                        readPool = ChannelThreadPools.singleton((ChannelThread)xnio.createReadChannelThread(OptionMap.create((Option)Options.ALLOW_BLOCKING, (Object)Boolean.FALSE, (Option)Options.THREAD_NAME, (Object)String.format("Remoting \"%s\" read-1", name))));
                    } else {
                        readPool = ChannelThreadPools.createRoundRobinPool();
                        for (i = 1; i <= readPoolSize; ++i) {
                            readPool.addToPool((ChannelThread)xnio.createReadChannelThread(OptionMap.create((Option)Options.ALLOW_BLOCKING, (Object)Boolean.FALSE, (Option)Options.THREAD_NAME, (Object)String.format("Remoting \"%s\" read-%d", name, i))));
                        }
                    }
                    if (writePoolSize == 1) {
                        writePool = ChannelThreadPools.singleton((ChannelThread)xnio.createWriteChannelThread(OptionMap.create((Option)Options.ALLOW_BLOCKING, (Object)Boolean.FALSE, (Option)Options.THREAD_NAME, (Object)String.format("Remoting \"%s\" write-1", name))));
                    } else {
                        writePool = ChannelThreadPools.createRoundRobinPool();
                        for (i = 1; i <= readPoolSize; ++i) {
                            writePool.addToPool((ChannelThread)xnio.createWriteChannelThread(OptionMap.create((Option)Options.ALLOW_BLOCKING, (Object)Boolean.FALSE, (Option)Options.THREAD_NAME, (Object)String.format("Remoting \"%s\" write-%d", name, i))));
                        }
                    }
                    ok = true;
                    if (ok) break block16;
                    if (readPool == null) break block17;
                }
                catch (Throwable throwable) {
                    if (!ok) {
                        if (readPool != null) {
                            ChannelThreadPools.shutdown((ChannelThreadPool)readPool);
                        }
                        if (writePool != null) {
                            ChannelThreadPools.shutdown(writePool);
                        }
                        executor.shutdown();
                    }
                    throw throwable;
                }
                ChannelThreadPools.shutdown((ChannelThreadPool)readPool);
            }
            if (writePool != null) {
                ChannelThreadPools.shutdown((ChannelThreadPool)writePool);
            }
            executor.shutdown();
        }
        this.readPool = readPool;
        this.writePool = writePool;
        log.tracef("Completed open of %s", (Object)this);
    }

    private EndpointImpl(int poolSize, Xnio xnio, String name, OptionMap optionMap) throws IOException {
        this(new Pool(poolSize, poolSize, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new EndpointThreadFactory(name)), xnio, name, optionMap);
    }

    EndpointImpl(Xnio xnio, String name, OptionMap optionMap) throws IOException {
        this(optionMap.get(RemotingOptions.TASK_THREAD_POOL_SIZE, 4), xnio, name, optionMap);
    }

    @Override
    protected Executor getExecutor() {
        return this.executor;
    }

    @Override
    public Attachments getAttachments() {
        return this.attachments;
    }

    @Override
    public String getName() {
        return this.name;
    }

    void closeTick1(Object c) {
        int res = resourceCountUpdater.decrementAndGet(this);
        if (res == Integer.MIN_VALUE) {
            this.finishPhase1();
        } else if ((res & Integer.MIN_VALUE) != 0) {
            if (log.isTraceEnabled()) {
                log.tracef("Phase 1 shutdown count %d of %s (closed %s)", (Object)(res & Integer.MAX_VALUE), (Object)this, c);
            }
        } else if (log.isTraceEnabled()) {
            log.tracef("Resource closed count %d of %s (closed %s)", (Object)(res & Integer.MAX_VALUE), (Object)this, c);
        }
    }

    private void finishPhase1() {
        log.tracef("Finished phase 1 shutdown of %s", (Object)this);
        this.closeUntick();
        ChannelThread.Listener listener = new ChannelThread.Listener(){

            public void handleTerminationInitiated(ChannelThread thread) {
            }

            public void handleTerminationComplete(ChannelThread thread) {
                EndpointImpl.this.closeTick2();
            }
        };
        for (ReadChannelThread thread : this.readPool.getCurrentPool()) {
            this.closeUntick();
            thread.addTerminationListener(listener);
            thread.shutdown();
        }
        for (ReadChannelThread thread : this.writePool.getCurrentPool()) {
            this.closeUntick();
            thread.addTerminationListener(listener);
            thread.shutdown();
        }
        this.closeTick2();
    }

    void closeTick2() {
        int res = resourceCountUpdater.decrementAndGet(this);
        if (res == Integer.MIN_VALUE) {
            log.tracef("Finished phase 2 shutdown of %s", (Object)this);
            this.executor.shutdown();
        } else if (log.isTraceEnabled()) {
            log.tracef("Phase 2 shutdown count %d of %s", (Object)(res & Integer.MAX_VALUE), (Object)this);
        }
    }

    void resourceUntick(Object opened) throws NotOpenException {
        int old;
        do {
            if (((old = resourceCountUpdater.get(this)) & Integer.MIN_VALUE) == 0) continue;
            throw new NotOpenException("Endpoint is not open");
        } while (!resourceCountUpdater.compareAndSet(this, old, old + 1));
        if (log.isTraceEnabled()) {
            log.tracef("Allocated tick to %d of %s (opened %s)", (Object)(old + 1), (Object)this, opened);
        }
    }

    void closeUntick() {
        resourceCountUpdater.incrementAndGet(this);
    }

    @Override
    protected void closeAction() throws IOException {
        int res;
        while (!resourceCountUpdater.compareAndSet(this, res = this.resourceCount, res | Integer.MIN_VALUE)) {
        }
        if (res == 0) {
            this.finishPhase1();
        } else {
            for (Object connection : this.connections.toArray()) {
                ((ConnectionImpl)connection).closeAsync();
            }
            for (ConnectionProvider connectionProvider : this.connectionProviders.values()) {
                connectionProvider.closeAsync();
            }
        }
    }

    @Override
    public Registration registerService(String serviceType, final OpenListener openListener, OptionMap optionMap) throws ServiceRegistrationException {
        OpenListener existing;
        if (!VALID_SERVICE_PATTERN.matcher(serviceType).matches()) {
            throw new IllegalArgumentException("Service type must match " + VALID_SERVICE_PATTERN);
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(REGISTER_SERVICE_PERM);
        }
        if ((existing = this.registeredServices.putIfAbsent(serviceType, openListener)) != null) {
            throw new ServiceRegistrationException("Service type '" + serviceType + "' is already registered");
        }
        MapRegistration<OpenListener> registration = new MapRegistration<OpenListener>(this.registeredServices, serviceType, openListener){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void closeAction() throws IOException {
                try {
                    openListener.registrationTerminated();
                }
                finally {
                    super.closeAction();
                }
            }
        };
        final HandleableCloseable.Key key = this.addCloseHandler(SpiUtils.closingCloseHandler(registration));
        registration.addCloseHandler(new CloseHandler<Registration>(){

            @Override
            public void handleClose(Registration closed, IOException exception) {
                key.remove();
            }
        });
        return registration;
    }

    @Override
    public IoFuture<Connection> connect(URI destination) throws IOException {
        UserAndRealm userRealm = this.getUserAndRealm(destination);
        String uriUserName = userRealm.getUser();
        String uriUserRealm = userRealm.getRealm();
        OptionMap.Builder builder = OptionMap.builder();
        if (uriUserName != null) {
            builder.set(RemotingOptions.AUTHORIZE_ID, (Object)uriUserName);
        }
        if (uriUserRealm != null) {
            builder.set(RemotingOptions.AUTH_REALM, (Object)uriUserRealm);
        }
        OptionMap finalMap = builder.getMap();
        return this.doConnect(destination, finalMap, new PasswordClientCallbackHandler((String)finalMap.get(RemotingOptions.AUTHORIZE_ID), (String)finalMap.get(RemotingOptions.AUTH_REALM), null));
    }

    @Override
    public IoFuture<Connection> connect(URI destination, OptionMap connectOptions) throws IOException {
        UserAndRealm userRealm = this.getUserAndRealm(destination);
        String uriUserName = userRealm.getUser();
        String uriUserRealm = userRealm.getRealm();
        OptionMap.Builder builder = OptionMap.builder().addAll(connectOptions);
        if (uriUserName != null) {
            builder.set(RemotingOptions.AUTHORIZE_ID, (Object)uriUserName);
        }
        if (uriUserRealm != null) {
            builder.set(RemotingOptions.AUTH_REALM, (Object)uriUserRealm);
        }
        OptionMap finalMap = builder.getMap();
        return this.doConnect(destination, finalMap, new PasswordClientCallbackHandler((String)finalMap.get(RemotingOptions.AUTHORIZE_ID), (String)finalMap.get(RemotingOptions.AUTH_REALM), null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IoFuture<Connection> doConnect(URI destination, OptionMap connectOptions, CallbackHandler callbackHandler) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CONNECT_PERM);
        }
        boolean ok = false;
        this.resourceUntick("Connection to " + destination);
        try {
            String scheme = destination.getScheme();
            ConnectionProvider connectionProvider = (ConnectionProvider)this.connectionProviders.get(scheme);
            if (connectionProvider == null) {
                throw new UnknownURISchemeException("No connection provider for URI scheme \"" + scheme + "\" is installed");
            }
            final FutureResult futureResult = new FutureResult(this.writePool);
            final StackTraceElement[] mark = Thread.currentThread().getStackTrace();
            Cancellable connect = connectionProvider.connect(destination, connectOptions, new Result<ConnectionHandlerFactory>(){

                public boolean setResult(ConnectionHandlerFactory result) {
                    ConnectionImpl connection = new ConnectionImpl(EndpointImpl.this, result, EndpointImpl.this.connectionProviderContext);
                    EndpointImpl.this.connections.add(connection);
                    connection.getConnectionHandler().addCloseHandler(SpiUtils.asyncClosingCloseHandler(connection));
                    connection.addCloseHandler(EndpointImpl.this.resourceCloseHandler);
                    connection.addCloseHandler(EndpointImpl.this.connectionCloseHandler);
                    return futureResult.setResult((Object)connection);
                }

                public boolean setException(IOException exception) {
                    EndpointImpl.this.closeTick1("a failed connection (2)");
                    SpiUtils.glueStackTraces(exception, mark, 1, "asynchronous invocation");
                    return futureResult.setException(exception);
                }

                public boolean setCancelled() {
                    EndpointImpl.this.closeTick1("a cancelled connection");
                    return futureResult.setCancelled();
                }
            }, callbackHandler);
            ok = true;
            futureResult.addCancelHandler(connect);
            IoFuture ioFuture = futureResult.getIoFuture();
            return ioFuture;
        }
        finally {
            if (!ok) {
                this.closeTick1("a failed connection (1)");
            }
        }
    }

    @Override
    public IoFuture<Connection> connect(URI destination, OptionMap connectOptions, CallbackHandler callbackHandler) throws IOException {
        UserAndRealm userRealm = this.getUserAndRealm(destination);
        String uriUserName = userRealm.getUser();
        String uriUserRealm = userRealm.getRealm();
        OptionMap.Builder builder = OptionMap.builder().addAll(connectOptions);
        if (uriUserName != null) {
            builder.set(RemotingOptions.AUTHORIZE_ID, (Object)uriUserName);
        }
        if (uriUserRealm != null) {
            builder.set(RemotingOptions.AUTH_REALM, (Object)uriUserRealm);
        }
        OptionMap finalMap = builder.getMap();
        return this.doConnect(destination, finalMap, callbackHandler);
    }

    @Override
    public IoFuture<Connection> connect(URI destination, OptionMap connectOptions, String userName, String realmName, char[] password) throws IOException {
        String actualUserName;
        UserAndRealm userRealm = this.getUserAndRealm(destination);
        String uriUserName = userRealm.getUser();
        String uriUserRealm = userRealm.getRealm();
        String string = userName != null ? userName : (actualUserName = uriUserName != null ? uriUserName : (String)connectOptions.get(RemotingOptions.AUTHORIZE_ID));
        String actualUserRealm = realmName != null ? realmName : (uriUserRealm != null ? uriUserRealm : (String)connectOptions.get(RemotingOptions.AUTH_REALM));
        OptionMap.Builder builder = OptionMap.builder().addAll(connectOptions);
        if (actualUserName != null) {
            builder.set(RemotingOptions.AUTHORIZE_ID, (Object)actualUserName);
        }
        if (actualUserRealm != null) {
            builder.set(RemotingOptions.AUTH_REALM, (Object)actualUserRealm);
        }
        OptionMap finalMap = builder.getMap();
        return this.doConnect(destination, finalMap, new PasswordClientCallbackHandler(actualUserName, actualUserRealm, password));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Registration addConnectionProvider(String uriScheme, ConnectionProviderFactory providerFactory, OptionMap optionMap) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ADD_CONNECTION_PROVIDER_PERM);
        }
        boolean ok = false;
        this.resourceUntick("Connection provider for " + uriScheme);
        try {
            MapRegistration<ConnectionProvider> mapRegistration;
            block10: {
                ConnectionProviderContextImpl context = new ConnectionProviderContextImpl();
                final ConnectionProvider provider = providerFactory.createInstance(context, optionMap);
                try {
                    if (this.connectionProviders.putIfAbsent(uriScheme, provider) != null) {
                        throw new DuplicateRegistrationException("URI scheme '" + uriScheme + "' is already registered to a provider");
                    }
                    log.tracef("Adding connection provider registration named '%s': %s", (Object)uriScheme, (Object)provider);
                    final MapRegistration<ConnectionProvider> registration = new MapRegistration<ConnectionProvider>(this.connectionProviders, uriScheme, provider){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        protected void closeAction() throws IOException {
                            try {
                                provider.closeAsync();
                            }
                            finally {
                                super.closeAction();
                            }
                        }
                    };
                    provider.addCloseHandler(new CloseHandler<ConnectionProvider>(){

                        @Override
                        public void handleClose(ConnectionProvider closed, IOException exception) {
                            registration.closeAsync();
                            EndpointImpl.this.closeTick1(closed);
                        }
                    });
                    ok = true;
                    mapRegistration = registration;
                    if (ok) break block10;
                }
                catch (Throwable throwable) {
                    if (!ok) {
                        provider.close();
                    }
                    throw throwable;
                }
                provider.close();
            }
            return mapRegistration;
        }
        finally {
            if (!ok) {
                this.closeTick1("Connection provider for " + uriScheme);
            }
        }
    }

    @Override
    public <T> T getConnectionProviderInterface(String uriScheme, Class<T> expectedType) throws UnknownURISchemeException, ClassCastException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONNECTION_PROVIDER_INTERFACE_PERM);
        }
        if (!expectedType.isInterface()) {
            throw new IllegalArgumentException("Interface expected");
        }
        ConnectionProvider provider = (ConnectionProvider)this.connectionProviders.get(uriScheme);
        if (provider == null) {
            throw new UnknownURISchemeException("No connection provider for URI scheme \"" + uriScheme + "\" is installed");
        }
        return expectedType.cast(provider.getProviderInterface());
    }

    @Override
    public boolean isValidUriScheme(String uriScheme) {
        return this.connectionProviders.containsKey(uriScheme);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("endpoint ");
        if (this.name != null) {
            b.append('\"').append(this.name).append('\"');
        } else {
            b.append("(anonymous)");
        }
        b.append(" <").append(Integer.toHexString(this.hashCode())).append(">");
        return b.toString();
    }

    private static String uriDecode(String encoded) {
        char[] chars = encoded.toCharArray();
        int olen = chars.length;
        byte[] buf = new byte[olen];
        int c = 0;
        for (int i = 0; i < olen; ++i) {
            char ch = chars[i];
            if (ch == '%') {
                buf[c++] = (byte)(Character.digit(chars[++i], 16) << 4 | Character.digit(chars[++i], 16));
                continue;
            }
            if (ch < ' ' || ch > '\u007f') continue;
            buf[c++] = (byte)ch;
        }
        return new String(buf, 0, c, UTF_8);
    }

    private UserAndRealm getUserAndRealm(URI uri) {
        String userInfo = uri.getRawUserInfo();
        if (userInfo == null) {
            return EMPTY;
        }
        int i = userInfo.indexOf(59);
        if (i == -1) {
            return new UserAndRealm(uri.getUserInfo(), null);
        }
        return new UserAndRealm(EndpointImpl.uriDecode(userInfo.substring(0, i)), EndpointImpl.uriDecode(userInfo.substring(i + 1)));
    }

    static {
        Logger.getLogger((String)"org.jboss.remoting").infof("JBoss Remoting version %s", (Object)Version.VERSION);
        log = Logger.getLogger((String)"org.jboss.remoting.endpoint");
        REGISTER_SERVICE_PERM = new RemotingPermission("registerService");
        CONNECT_PERM = new RemotingPermission("connect");
        ADD_CONNECTION_PROVIDER_PERM = new RemotingPermission("addConnectionProvider");
        GET_CONNECTION_PROVIDER_INTERFACE_PERM = new RemotingPermission("getConnectionProviderInterface");
        resourceCountUpdater = AtomicIntegerFieldUpdater.newUpdater(EndpointImpl.class, "resourceCount");
        VALID_SERVICE_PATTERN = Pattern.compile("[-.:a-zA-Z_0-9]+");
        UTF_8 = Charset.forName("UTF-8");
        EMPTY = new UserAndRealm(null, null);
    }

    private class ConnectionCloseHandler
    implements CloseHandler<Connection> {
        private ConnectionCloseHandler() {
        }

        @Override
        public void handleClose(Connection closed, IOException exception) {
            EndpointImpl.this.connections.remove(closed);
        }
    }

    static final class Pool
    extends ThreadPoolExecutor {
        volatile Runnable stopTask;

        Pool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        }

        @Override
        protected void terminated() {
            Runnable task = this.stopTask;
            if (task != null) {
                task.run();
            }
        }
    }

    static final class EndpointThreadFactory
    implements ThreadFactory {
        private final String name;
        private volatile int threadId = 1;
        private static final AtomicIntegerFieldUpdater<EndpointThreadFactory> threadIdUpdater = AtomicIntegerFieldUpdater.newUpdater(EndpointThreadFactory.class, "threadId");

        EndpointThreadFactory(String name) {
            this.name = name;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, String.format("Remoting \"%s\" task-%d", this.name, threadIdUpdater.getAndIncrement(this)));
            thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    log.errorf(e, "Uncaught exception in thread %s", (Object)t);
                }
            });
            return thread;
        }
    }

    private final class ConnectionProviderContextImpl
    implements ConnectionProviderContext {
        private ConnectionProviderContextImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(ConnectionHandlerFactory connectionHandlerFactory) {
            try {
                EndpointImpl.this.resourceUntick("an inbound connection");
            }
            catch (NotOpenException e) {
                throw new IllegalStateException("Accept after endpoint close", e);
            }
            boolean ok = false;
            try {
                ConnectionImpl connection = new ConnectionImpl(EndpointImpl.this, connectionHandlerFactory, this);
                EndpointImpl.this.connections.add(connection);
                connection.getConnectionHandler().addCloseHandler(SpiUtils.asyncClosingCloseHandler(connection));
                connection.addCloseHandler(EndpointImpl.this.connectionCloseHandler);
                connection.addCloseHandler(EndpointImpl.this.resourceCloseHandler);
                ok = true;
            }
            finally {
                if (!ok) {
                    EndpointImpl.this.closeTick1("a failed inbound connection");
                }
            }
        }

        @Override
        public Endpoint getEndpoint() {
            return EndpointImpl.this;
        }

        @Override
        public Xnio getXnio() {
            return EndpointImpl.this.xnio;
        }

        @Override
        public ChannelThreadPool<ReadChannelThread> getReadThreadPool() {
            return EndpointImpl.this.readPool;
        }

        @Override
        public ChannelThreadPool<WriteChannelThread> getWriteThreadPool() {
            return EndpointImpl.this.writePool;
        }

        @Override
        public Executor getExecutor() {
            return EndpointImpl.this.executor;
        }
    }

    final class LocalConnectionContext
    implements ConnectionHandlerContext {
        private final ConnectionProviderContext connectionProviderContext;
        private final Connection connection;

        LocalConnectionContext(ConnectionProviderContext connectionProviderContext, Connection connection) {
            this.connectionProviderContext = connectionProviderContext;
            this.connection = connection;
        }

        @Override
        public ConnectionProviderContext getConnectionProviderContext() {
            return this.connectionProviderContext;
        }

        @Override
        public OpenListener getServiceOpenListener(String serviceType) throws ServiceNotFoundException {
            OpenListener listener = (OpenListener)EndpointImpl.this.registeredServices.get(serviceType);
            if (listener == null) {
                throw new ServiceNotFoundException("Unable to find service type '" + serviceType + "'");
            }
            return listener;
        }

        @Override
        public Connection getConnection() {
            return this.connection;
        }

        @Override
        public void remoteClosed() {
            this.connection.closeAsync();
        }
    }

    private class MapRegistration<T>
    extends AbstractHandleableCloseable<Registration>
    implements Registration {
        private final ConcurrentMap<String, T> map;
        private final String key;
        private final T value;

        private MapRegistration(ConcurrentMap<String, T> map, String key, T value) {
            super((Executor)EndpointImpl.this.writePool, false);
            this.map = map;
            this.key = key;
            this.value = value;
        }

        @Override
        protected void closeAction() throws IOException {
            this.map.remove(this.key, this.value);
            this.closeComplete();
        }

        @Override
        public void close() {
            try {
                super.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        public String toString() {
            return String.format("Registration of '%s': %s", this.key, this.value);
        }
    }

    static final class UserAndRealm {
        private final String user;
        private final String realm;

        UserAndRealm(String user, String realm) {
            this.user = user;
            this.realm = realm;
        }

        public String getUser() {
            return this.user;
        }

        public String getRealm() {
            return this.realm;
        }
    }
}

