/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;

final class ExternalSaslServer
implements SaslServer {
    private final AtomicBoolean complete = new AtomicBoolean();
    private String authorizationID;
    private final Principal peerPrincipal;
    private final CallbackHandler callbackHandler;
    private static final byte[] EMPTY = new byte[0];

    ExternalSaslServer(CallbackHandler callbackHandler, Principal peerPrincipal) {
        this.callbackHandler = callbackHandler;
        this.peerPrincipal = peerPrincipal;
    }

    @Override
    public String getMechanismName() {
        return "EXTERNAL";
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        String userName;
        if (this.complete.getAndSet(true)) {
            throw new SaslException("Received response after complete");
        }
        try {
            userName = new String(response, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SaslException("Cannot convert user name from UTF-8", e);
        }
        AuthorizeCallback authorizeCallback = new AuthorizeCallback(this.peerPrincipal.getName(), userName);
        ExternalSaslServer.handleCallback(this.callbackHandler, authorizeCallback);
        this.authorizationID = userName;
        return EMPTY;
    }

    private static void handleCallback(CallbackHandler handler, Callback callback) throws SaslException {
        try {
            handler.handle(new Callback[]{callback});
        }
        catch (SaslException e) {
            throw e;
        }
        catch (IOException e) {
            throw new SaslException("Failed to authenticate due to callback exception", e);
        }
        catch (UnsupportedCallbackException e) {
            throw new SaslException("Failed to authenticate due to unsupported callback", e);
        }
    }

    @Override
    public boolean isComplete() {
        return this.complete.get();
    }

    @Override
    public String getAuthorizationID() {
        return this.authorizationID;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        throw new IllegalStateException();
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        throw new IllegalStateException();
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        return null;
    }

    @Override
    public void dispose() throws SaslException {
    }
}

