/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Attachments;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.ChannelPair;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.ConnectionImpl;
import org.jboss.remoting3.DuplicateRegistrationException;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.HandleableCloseable;
import org.jboss.remoting3.LocalConnectionProvider;
import org.jboss.remoting3.LoopbackChannel;
import org.jboss.remoting3.OpenListener;
import org.jboss.remoting3.Registration;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3.ServiceNotFoundException;
import org.jboss.remoting3.ServiceRegistrationException;
import org.jboss.remoting3.UnknownURISchemeException;
import org.jboss.remoting3.UnlockedReadHashMap;
import org.jboss.remoting3.Version;
import org.jboss.remoting3.security.PasswordClientCallbackHandler;
import org.jboss.remoting3.security.RemotingPermission;
import org.jboss.remoting3.spi.AbstractHandleableCloseable;
import org.jboss.remoting3.spi.ConnectionHandlerContext;
import org.jboss.remoting3.spi.ConnectionHandlerFactory;
import org.jboss.remoting3.spi.ConnectionProvider;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.jboss.remoting3.spi.ConnectionProviderFactory;
import org.jboss.remoting3.spi.SpiUtils;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Result;

final class EndpointImpl
extends AbstractHandleableCloseable<Endpoint>
implements Endpoint {
    private static final Logger log;
    private static final RemotingPermission REGISTER_SERVICE_PERM;
    private static final RemotingPermission CREATE_CHANNEL_PERM;
    private static final RemotingPermission CONNECT_PERM;
    private static final RemotingPermission ADD_CONNECTION_PROVIDER_PERM;
    private static final RemotingPermission GET_CONNECTION_PROVIDER_INTERFACE_PERM;
    private final Attachments attachments = new Attachments();
    private final ConcurrentMap<String, ConnectionProvider> connectionProviders = new UnlockedReadHashMap<String, ConnectionProvider>();
    private final ConcurrentMap<String, OpenListener> registeredServices = new UnlockedReadHashMap<String, OpenListener>();
    private final Set<Connection> connections = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
    private static final Pattern VALID_SERVICE_PATTERN;
    private final String name;
    private final OptionMap optionMap;
    private final ConnectionProviderContext connectionProviderContext;
    private final CloseHandler<Connection> connectionCloseHandler = new CloseHandler<Connection>(){

        @Override
        public void handleClose(Connection closed, IOException exception) {
            EndpointImpl.this.connections.remove(closed);
        }
    };
    private final Executor executor;
    private static final Charset UTF_8;
    private static final UserAndRealm EMPTY;

    EndpointImpl(Executor executor, String name, OptionMap optionMap) throws IOException {
        super(executor);
        this.executor = executor;
        this.name = name;
        this.connectionProviderContext = new ConnectionProviderContextImpl();
        this.connectionProviders.put("local", new LocalConnectionProvider(this.connectionProviderContext, executor));
        this.optionMap = optionMap;
    }

    @Override
    protected Executor getExecutor() {
        return this.executor;
    }

    @Override
    public Attachments getAttachments() {
        return this.attachments;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ChannelPair createChannelPair() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CREATE_CHANNEL_PERM);
        }
        LoopbackChannel channel = new LoopbackChannel(this.executor);
        return new ChannelPair(channel, channel.getOtherSide());
    }

    @Override
    protected void closeAction() throws IOException {
        Object[] array;
        class CloseCounter
        extends AtomicInteger
        implements CloseHandler<Object> {
            CloseCounter() {
                super(1);
            }

            @Override
            public void handleClose(Object closed, IOException exception) {
                this.tick();
            }

            void tick() {
                if (this.getAndDecrement() == 0) {
                    EndpointImpl.this.closeComplete();
                }
            }

            void addTo(HandleableCloseable<?> target) {
                this.getAndIncrement();
                target.closeAsync();
                target.addCloseHandler(this);
            }
        }
        CloseCounter counter = new CloseCounter();
        for (ConnectionProvider connectionProvider : this.connectionProviders.values()) {
            counter.addTo(connectionProvider);
        }
        for (Object connection : array = this.connections.toArray()) {
            counter.addTo((Connection)connection);
        }
        counter.tick();
    }

    @Override
    public Registration registerService(String serviceType, final OpenListener openListener, OptionMap optionMap) throws ServiceRegistrationException {
        OpenListener existing;
        if (!VALID_SERVICE_PATTERN.matcher(serviceType).matches()) {
            throw new IllegalArgumentException("Service type must match " + VALID_SERVICE_PATTERN);
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(REGISTER_SERVICE_PERM);
        }
        if ((existing = this.registeredServices.putIfAbsent(serviceType, openListener)) != null) {
            throw new ServiceRegistrationException("Service type '" + serviceType + "' is already registered");
        }
        MapRegistration<OpenListener> registration = new MapRegistration<OpenListener>(this.registeredServices, serviceType, openListener){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void closeAction() throws IOException {
                try {
                    openListener.registrationTerminated();
                }
                finally {
                    super.closeAction();
                }
            }
        };
        final HandleableCloseable.Key key = this.addCloseHandler(SpiUtils.closingCloseHandler(registration));
        registration.addCloseHandler(new CloseHandler<Registration>(){

            @Override
            public void handleClose(Registration closed, IOException exception) {
                key.remove();
            }
        });
        return registration;
    }

    @Override
    public IoFuture<Connection> connect(URI destination) throws IOException {
        UserAndRealm userRealm = this.getUserAndRealm(destination);
        String uriUserName = userRealm.getUser();
        String uriUserRealm = userRealm.getRealm();
        OptionMap.Builder builder = OptionMap.builder();
        if (uriUserName != null) {
            builder.set(RemotingOptions.AUTHORIZE_ID, (Object)uriUserName);
        }
        if (uriUserRealm != null) {
            builder.set(RemotingOptions.AUTH_REALM, (Object)uriUserRealm);
        }
        OptionMap finalMap = builder.getMap();
        return this.doConnect(destination, finalMap, new PasswordClientCallbackHandler((String)finalMap.get(RemotingOptions.AUTHORIZE_ID), (String)finalMap.get(RemotingOptions.AUTH_REALM), null));
    }

    @Override
    public IoFuture<Connection> connect(URI destination, OptionMap connectOptions) throws IOException {
        UserAndRealm userRealm = this.getUserAndRealm(destination);
        String uriUserName = userRealm.getUser();
        String uriUserRealm = userRealm.getRealm();
        OptionMap.Builder builder = OptionMap.builder().addAll(connectOptions);
        if (uriUserName != null) {
            builder.set(RemotingOptions.AUTHORIZE_ID, (Object)uriUserName);
        }
        if (uriUserRealm != null) {
            builder.set(RemotingOptions.AUTH_REALM, (Object)uriUserRealm);
        }
        OptionMap finalMap = builder.getMap();
        return this.doConnect(destination, finalMap, new PasswordClientCallbackHandler((String)finalMap.get(RemotingOptions.AUTHORIZE_ID), (String)finalMap.get(RemotingOptions.AUTH_REALM), null));
    }

    private IoFuture<Connection> doConnect(URI destination, OptionMap connectOptions, CallbackHandler callbackHandler) throws IOException {
        String scheme;
        ConnectionProvider connectionProvider;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CONNECT_PERM);
        }
        if ((connectionProvider = (ConnectionProvider)this.connectionProviders.get(scheme = destination.getScheme())) == null) {
            throw new UnknownURISchemeException("No connection provider for URI scheme \"" + scheme + "\" is installed");
        }
        final FutureResult futureResult = new FutureResult(this.executor);
        final StackTraceElement[] mark = Thread.currentThread().getStackTrace();
        futureResult.addCancelHandler(connectionProvider.connect(destination, connectOptions, new Result<ConnectionHandlerFactory>(){

            public boolean setResult(ConnectionHandlerFactory result) {
                ConnectionImpl connection = new ConnectionImpl(EndpointImpl.this, result, EndpointImpl.this.connectionProviderContext);
                EndpointImpl.this.connections.add(connection);
                connection.addCloseHandler(EndpointImpl.this.connectionCloseHandler);
                return futureResult.setResult((Object)connection);
            }

            public boolean setException(IOException exception) {
                SpiUtils.glueStackTraces(exception, mark, 1, "asynchronous invocation");
                return futureResult.setException(exception);
            }

            public boolean setCancelled() {
                return futureResult.setCancelled();
            }
        }, callbackHandler));
        return futureResult.getIoFuture();
    }

    @Override
    public IoFuture<Connection> connect(URI destination, OptionMap connectOptions, CallbackHandler callbackHandler) throws IOException {
        UserAndRealm userRealm = this.getUserAndRealm(destination);
        String uriUserName = userRealm.getUser();
        String uriUserRealm = userRealm.getRealm();
        OptionMap.Builder builder = OptionMap.builder().addAll(connectOptions);
        if (uriUserName != null) {
            builder.set(RemotingOptions.AUTHORIZE_ID, (Object)uriUserName);
        }
        if (uriUserRealm != null) {
            builder.set(RemotingOptions.AUTH_REALM, (Object)uriUserRealm);
        }
        OptionMap finalMap = builder.getMap();
        return this.doConnect(destination, finalMap, callbackHandler);
    }

    @Override
    public IoFuture<Connection> connect(URI destination, OptionMap connectOptions, String userName, String realmName, char[] password) throws IOException {
        String actualUserName;
        UserAndRealm userRealm = this.getUserAndRealm(destination);
        String uriUserName = userRealm.getUser();
        String uriUserRealm = userRealm.getRealm();
        String string = userName != null ? userName : (actualUserName = uriUserName != null ? uriUserName : (String)connectOptions.get(RemotingOptions.AUTHORIZE_ID));
        String actualUserRealm = realmName != null ? realmName : (uriUserRealm != null ? uriUserRealm : (String)connectOptions.get(RemotingOptions.AUTH_REALM));
        OptionMap.Builder builder = OptionMap.builder().addAll(connectOptions);
        if (actualUserName != null) {
            builder.set(RemotingOptions.AUTHORIZE_ID, (Object)actualUserName);
        }
        if (actualUserRealm != null) {
            builder.set(RemotingOptions.AUTH_REALM, (Object)actualUserRealm);
        }
        OptionMap finalMap = builder.getMap();
        return this.doConnect(destination, finalMap, new PasswordClientCallbackHandler(actualUserName, actualUserRealm, password));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Registration addConnectionProvider(String uriScheme, ConnectionProviderFactory providerFactory, OptionMap optionMap) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ADD_CONNECTION_PROVIDER_PERM);
        }
        ConnectionProviderContextImpl context = new ConnectionProviderContextImpl();
        final ConnectionProvider provider = providerFactory.createInstance(context, optionMap);
        boolean ok = false;
        try {
            if (this.connectionProviders.putIfAbsent(uriScheme, provider) != null) {
                throw new DuplicateRegistrationException("URI scheme '" + uriScheme + "' is already registered to a provider");
            }
            log.tracef("Adding connection provider registration named '%s': %s", (Object)uriScheme, (Object)provider);
            MapRegistration<ConnectionProvider> registration = new MapRegistration<ConnectionProvider>(this.connectionProviders, uriScheme, provider){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void closeAction() throws IOException {
                    try {
                        provider.close();
                    }
                    finally {
                        super.closeAction();
                    }
                }
            };
            final HandleableCloseable.Key key = this.addCloseHandler(SpiUtils.closingCloseHandler(registration));
            registration.addCloseHandler(new CloseHandler<Registration>(){

                @Override
                public void handleClose(Registration closed, IOException exception) {
                    key.remove();
                }
            });
            ok = true;
            MapRegistration<ConnectionProvider> mapRegistration = registration;
            return mapRegistration;
        }
        finally {
            if (!ok) {
                provider.close();
            }
        }
    }

    @Override
    public <T> T getConnectionProviderInterface(String uriScheme, Class<T> expectedType) throws UnknownURISchemeException, ClassCastException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONNECTION_PROVIDER_INTERFACE_PERM);
        }
        if (!expectedType.isInterface()) {
            throw new IllegalArgumentException("Interface expected");
        }
        ConnectionProvider provider = (ConnectionProvider)this.connectionProviders.get(uriScheme);
        if (provider == null) {
            throw new UnknownURISchemeException("No connection provider for URI scheme \"" + uriScheme + "\" is installed");
        }
        return expectedType.cast(provider.getProviderInterface());
    }

    @Override
    public boolean isValidUriScheme(String uriScheme) {
        return this.connectionProviders.containsKey(uriScheme);
    }

    public String toString() {
        return "endpoint \"" + this.name + "\" <" + Integer.toHexString(this.hashCode()) + ">";
    }

    private static String uriDecode(String encoded) {
        char[] chars = encoded.toCharArray();
        int olen = chars.length;
        byte[] buf = new byte[olen];
        int c = 0;
        for (int i = 0; i < olen; ++i) {
            char ch = chars[i];
            if (ch == '%') {
                buf[c++] = (byte)(Character.digit(chars[++i], 16) << 4 | Character.digit(chars[++i], 16));
                continue;
            }
            if (ch < ' ' || ch > '\u007f') continue;
            buf[c++] = (byte)ch;
        }
        return new String(buf, 0, c, UTF_8);
    }

    private UserAndRealm getUserAndRealm(URI uri) {
        String userInfo = uri.getRawUserInfo();
        if (userInfo == null) {
            return EMPTY;
        }
        int i = userInfo.indexOf(59);
        if (i == -1) {
            return new UserAndRealm(uri.getUserInfo(), null);
        }
        return new UserAndRealm(EndpointImpl.uriDecode(userInfo.substring(0, i)), EndpointImpl.uriDecode(userInfo.substring(i + 1)));
    }

    static {
        Logger.getLogger((String)"org.jboss.remoting").infof("JBoss Remoting version %s", (Object)Version.VERSION);
        log = Logger.getLogger((String)"org.jboss.remoting.endpoint");
        REGISTER_SERVICE_PERM = new RemotingPermission("registerService");
        CREATE_CHANNEL_PERM = new RemotingPermission("createChannel");
        CONNECT_PERM = new RemotingPermission("connect");
        ADD_CONNECTION_PROVIDER_PERM = new RemotingPermission("addConnectionProvider");
        GET_CONNECTION_PROVIDER_INTERFACE_PERM = new RemotingPermission("getConnectionProviderInterface");
        VALID_SERVICE_PATTERN = Pattern.compile("[-.:a-zA-Z_0-9]+");
        UTF_8 = Charset.forName("UTF-8");
        EMPTY = new UserAndRealm(null, null);
    }

    private final class ConnectionProviderContextImpl
    implements ConnectionProviderContext {
        private ConnectionProviderContextImpl() {
        }

        @Override
        public Executor getExecutor() {
            return EndpointImpl.this.executor;
        }

        @Override
        public void accept(ConnectionHandlerFactory connectionHandlerFactory) {
            ConnectionImpl connection = new ConnectionImpl(EndpointImpl.this, connectionHandlerFactory, this);
            connection.addCloseHandler(EndpointImpl.this.connectionCloseHandler);
            EndpointImpl.this.connections.add(connection);
        }

        @Override
        public Endpoint getEndpoint() {
            return EndpointImpl.this;
        }
    }

    final class LocalConnectionContext
    implements ConnectionHandlerContext {
        private final ConnectionProviderContext connectionProviderContext;
        private final Connection connection;

        LocalConnectionContext(ConnectionProviderContext connectionProviderContext, Connection connection) {
            this.connectionProviderContext = connectionProviderContext;
            this.connection = connection;
        }

        @Override
        public ConnectionProviderContext getConnectionProviderContext() {
            return this.connectionProviderContext;
        }

        @Override
        public void openService(final Channel newChannel, String serviceType) throws ServiceNotFoundException {
            final OpenListener listener = (OpenListener)EndpointImpl.this.registeredServices.get(serviceType);
            if (listener == null) {
                throw new ServiceNotFoundException("Unable to find service type '" + serviceType + "'");
            }
            EndpointImpl.this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    listener.channelOpened(newChannel);
                }
            });
        }

        @Override
        public void remoteClosed() {
            IoUtils.safeClose((Closeable)this.connection);
        }
    }

    private class MapRegistration<T>
    extends AbstractHandleableCloseable<Registration>
    implements Registration {
        private final ConcurrentMap<String, T> map;
        private final String key;
        private final T value;

        private MapRegistration(ConcurrentMap<String, T> map, String key, T value) {
            super(EndpointImpl.this.executor, false);
            this.map = map;
            this.key = key;
            this.value = value;
        }

        @Override
        protected void closeAction() throws IOException {
            this.map.remove(this.key, this.value);
            this.closeComplete();
        }

        @Override
        public void close() {
            try {
                super.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        public String toString() {
            return String.format("Registration of '%s': %s", this.key, this.value);
        }
    }

    static final class UserAndRealm {
        private final String user;
        private final String realm;

        UserAndRealm(String user, String realm) {
            this.user = user;
            this.realm = realm;
        }

        public String getUser() {
            return this.user;
        }

        public String getRealm() {
            return this.realm;
        }
    }
}

