/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.util.NoSuchElementException;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.remoting3.stream.ObjectSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class UnmarshallerObjectSource<T>
implements ObjectSource<T> {
    private final Unmarshaller unmarshaller;
    private State state;

    UnmarshallerObjectSource(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() throws IOException {
        UnmarshallerObjectSource unmarshallerObjectSource = this;
        synchronized (unmarshallerObjectSource) {
            if (this.state == State.NEW) {
                int cmd = this.unmarshaller.readUnsignedByte();
                if (cmd == 0) {
                    this.state = State.READY;
                } else {
                    this.state = State.DONE;
                    this.unmarshaller.close();
                    return false;
                }
            }
            return this.state == State.READY;
        }
    }

    @Override
    public T next() throws NoSuchElementException, IOException {
        UnmarshallerObjectSource unmarshallerObjectSource = this;
        synchronized (unmarshallerObjectSource) {
            if (this.hasNext()) {
                try {
                    Object obj = this.unmarshaller.readObject();
                    this.state = State.NEW;
                    return (T)obj;
                }
                catch (ClassNotFoundException e) {
                    this.state = State.NEW;
                    throw new InvalidObjectException("Class not found: " + e);
                }
            }
            throw new NoSuchElementException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        UnmarshallerObjectSource unmarshallerObjectSource = this;
        synchronized (unmarshallerObjectSource) {
            this.state = State.DONE;
            this.unmarshaller.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        NEW,
        READY,
        DONE;

    }
}

