/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.Map;
import javax.security.sasl.SaslServerFactory;
import org.jboss.remoting3.remote.AbstractMessageHandler;
import org.jboss.remoting3.remote.Loggers;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.ServerInitialAuthenticationHandler;
import org.jboss.remoting3.security.ServerAuthenticationProvider;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.jboss.xnio.Buffers;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ServerGreetingHandler
extends AbstractMessageHandler {
    private final RemoteConnection connection;
    private final ConnectionProviderContext connectionProviderContext;
    private final Map<String, SaslServerFactory> saslMechs;
    private final ServerAuthenticationProvider provider;
    private final Map<String, Object> propertyMap;
    private static final Logger log = Loggers.server;

    ServerGreetingHandler(RemoteConnection connection, ConnectionProviderContext connectionProviderContext, Map<String, SaslServerFactory> saslMechs, ServerAuthenticationProvider provider, Map<String, Object> propertyMap) {
        super(connection);
        this.connection = connection;
        this.connectionProviderContext = connectionProviderContext;
        this.saslMechs = saslMechs;
        this.provider = provider;
        this.propertyMap = propertyMap;
    }

    public void handleMessage(ByteBuffer buffer) {
        switch (buffer.get()) {
            case 0: {
                log.trace("Server received greeting message");
                int[] ourVersions = this.connection.getProviderDescriptor().getSupportedVersions();
                int bestVersion = -1;
                block7: while (buffer.hasRemaining()) {
                    byte type = buffer.get();
                    int len = buffer.get() & 0xFF;
                    ByteBuffer data = Buffers.slice((ByteBuffer)buffer, (int)len);
                    block3 : switch (type) {
                        case 0: {
                            break;
                        }
                        case 3: {
                            int remoteVersion = data.getInt();
                            if (remoteVersion <= bestVersion) break;
                            for (int ourVersion : ourVersions) {
                                if (ourVersion != remoteVersion) continue;
                                bestVersion = remoteVersion;
                                break block3;
                            }
                            continue block7;
                        }
                    }
                }
                this.connection.setMessageHandler(new ServerInitialAuthenticationHandler(this.connection, this.propertyMap, this.saslMechs, this.provider, this.connectionProviderContext));
                return;
            }
        }
        log.warn("Server received invalid greeting message");
        IoUtils.safeClose((Closeable)this.connection);
    }
}

