/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import org.jboss.marshalling.ProviderDescriptor;
import org.jboss.remoting3.remote.Loggers;
import org.jboss.remoting3.spi.AbstractHandleableCloseable;
import org.jboss.xnio.Buffers;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.Pool;
import org.jboss.xnio.channels.Channels;
import org.jboss.xnio.channels.ConnectedStreamChannel;
import org.jboss.xnio.channels.MessageHandler;
import org.jboss.xnio.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RemoteConnection
extends AbstractHandleableCloseable<RemoteConnection>
implements Closeable {
    private final ConnectedStreamChannel<InetSocketAddress> channel;
    private final ProviderDescriptor providerDescriptor;
    private final Pool<ByteBuffer> bufferPool = Buffers.createHeapByteBufferAllocator((int)4096);
    private final MessageHandler.Setter messageHandlerSetter;
    private final OptionMap optionMap;
    private final Object writeLock = new Object();
    private static final Logger log = Loggers.main;

    RemoteConnection(Executor executor, ConnectedStreamChannel<InetSocketAddress> channel, OptionMap optionMap, ProviderDescriptor providerDescriptor) {
        super(executor);
        this.channel = channel;
        this.providerDescriptor = providerDescriptor;
        this.messageHandlerSetter = Channels.createMessageReader(channel, (OptionMap)optionMap);
        this.optionMap = optionMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeAction() throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            try {
                this.shutdownWritesBlocking();
            }
            catch (IOException e) {
                IoUtils.safeClose(this.channel);
                return;
            }
        }
    }

    OptionMap getOptionMap() {
        return this.optionMap;
    }

    ConnectedStreamChannel<InetSocketAddress> getChannel() {
        return this.channel;
    }

    ByteBuffer allocate() {
        return (ByteBuffer)this.bufferPool.allocate();
    }

    void free(ByteBuffer buffer) {
        this.bufferPool.free((Object)buffer);
    }

    void setMessageHandler(MessageHandler handler) {
        this.messageHandlerSetter.set(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendBlocking(ByteBuffer buffer, boolean flush) throws IOException {
        try {
            Object object = this.writeLock;
            synchronized (object) {
                buffer.putInt(0, buffer.remaining() - 4);
                boolean intr = false;
                try {
                    while (buffer.hasRemaining()) {
                        if (this.channel.write(buffer) != 0) continue;
                        try {
                            this.channel.awaitWritable();
                        }
                        catch (InterruptedIOException e) {
                            intr = Thread.interrupted();
                        }
                    }
                    if (flush) {
                        while (!this.channel.flush()) {
                            try {
                                this.channel.awaitWritable();
                            }
                            catch (InterruptedIOException e) {
                                intr = Thread.interrupted();
                            }
                        }
                    }
                }
                finally {
                    if (intr) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
        catch (IOException e) {
            log.trace((Throwable)e, "Closing channel due to failure to send", new Object[0]);
            IoUtils.safeClose(this.channel);
            throw e;
        }
        catch (RuntimeException e) {
            log.trace((Throwable)e, "Closing channel due to failure to send", new Object[0]);
            IoUtils.safeClose(this.channel);
            throw e;
        }
        catch (Error e) {
            log.trace((Throwable)e, "Closing channel due to failure to send", new Object[0]);
            IoUtils.safeClose(this.channel);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushBlocking() throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            try {
                while (!this.channel.flush()) {
                    this.channel.awaitWritable();
                }
            }
            catch (IOException e) {
                log.trace((Throwable)e, "Closing channel due to failure to flush", new Object[0]);
                IoUtils.safeClose(this.channel);
                throw e;
            }
            catch (RuntimeException e) {
                log.trace((Throwable)e, "Closing channel due to failure to flush", new Object[0]);
                IoUtils.safeClose(this.channel);
                throw e;
            }
            catch (Error e) {
                log.trace((Throwable)e, "Closing channel due to failure to flush", new Object[0]);
                IoUtils.safeClose(this.channel);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdownWritesBlocking() throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            try {
                while (!this.channel.shutdownWrites()) {
                    this.channel.awaitWritable();
                }
            }
            catch (IOException e) {
                log.trace((Throwable)e, "Closing channel due to failure to shutdown writes", new Object[0]);
                IoUtils.safeClose(this.channel);
                throw e;
            }
            catch (RuntimeException e) {
                log.trace((Throwable)e, "Closing channel due to failure to shutdown writes", new Object[0]);
                IoUtils.safeClose(this.channel);
                throw e;
            }
            catch (Error e) {
                log.trace((Throwable)e, "Closing channel due to failure to shutdown writes", new Object[0]);
                IoUtils.safeClose(this.channel);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendAuthReject(String msg) throws IOException {
        ByteBuffer buf = this.allocate();
        try {
            buf.putInt(0);
            buf.put((byte)5);
            Buffers.putModifiedUtf8((ByteBuffer)buf, (String)msg);
            buf.flip();
            this.sendBlocking(buf, true);
        }
        finally {
            this.free(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendAuthMessage(byte msgType, byte[] message) throws IOException {
        ByteBuffer buf = this.allocate();
        try {
            buf.putInt(0);
            buf.put(msgType);
            if (message != null) {
                buf.put(message);
            }
            buf.flip();
            this.sendBlocking(buf, true);
        }
        finally {
            this.free(buf);
        }
    }

    void shutdownReads() throws IOException {
        this.channel.shutdownReads();
    }

    ProviderDescriptor getProviderDescriptor() {
        return this.providerDescriptor;
    }

    void terminate() {
        try {
            this.channel.close();
        }
        catch (IOException e) {
            log.trace("Channel terminate exception: %s", (Object)e);
        }
    }
}

