/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.IOException;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.remote.Loggers;
import org.jboss.remoting3.remote.PrimaryExternalizerFactory;
import org.jboss.xnio.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PrimaryObjectTable
implements ObjectTable {
    private static final Logger log = Loggers.main;
    private final Map<Object, ObjectTable.Writer> writerMap;
    private final List<Object> readerList;
    static final byte OBJ_ENDPOINT = 0;
    static final byte OBJ_CLIENT_CONNECTOR = 1;
    static final byte OBJ_INPUT_STREAM = 2;
    static final byte OBJ_OUTPUT_STREAM = 3;
    static final byte OBJ_READER = 4;
    static final byte OBJ_WRITER = 5;
    static final byte OBJ_OBJECT_SOURCE = 6;
    static final byte OBJ_OBJECT_SINK = 7;
    private static final ByteWriter[] CACHED_WRITERS = new ByteWriter[]{new ByteWriter(0), new ByteWriter(1), new ByteWriter(2), new ByteWriter(3), new ByteWriter(4), new ByteWriter(5), new ByteWriter(6), new ByteWriter(7)};

    PrimaryObjectTable(Endpoint endpoint, PrimaryExternalizerFactory externalizerFactory) {
        IdentityHashMap<Object, ObjectTable.Writer> map = new IdentityHashMap<Object, ObjectTable.Writer>();
        List<Object> list = Arrays.asList(new Object[8]);
        PrimaryObjectTable.add(map, list, 0, endpoint);
        PrimaryObjectTable.add(map, list, 1, (Object)PrimaryExternalizerFactory.RequestHandlerConnectorExternalizer.INSTANCE);
        PrimaryObjectTable.add(map, list, 2, externalizerFactory.inputStream);
        PrimaryObjectTable.add(map, list, 3, externalizerFactory.outputStream);
        PrimaryObjectTable.add(map, list, 4, externalizerFactory.reader);
        PrimaryObjectTable.add(map, list, 5, externalizerFactory.writer);
        PrimaryObjectTable.add(map, list, 6, externalizerFactory.objectSource);
        PrimaryObjectTable.add(map, list, 7, externalizerFactory.objectSink);
        this.readerList = list;
        this.writerMap = map;
    }

    private static void add(Map<Object, ObjectTable.Writer> map, List<Object> list, int idx, Object instance) {
        ByteWriter writer = CACHED_WRITERS[idx];
        map.put(instance, writer);
        list.set(idx, instance);
    }

    public ObjectTable.Writer getObjectWriter(Object object) throws IOException {
        return this.writerMap.get(object);
    }

    public Object readObject(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        int id = unmarshaller.readUnsignedByte();
        return this.readerList.get(id);
    }

    private static final class ByteWriter
    implements ObjectTable.Writer {
        private final byte b;

        private ByteWriter(int b) {
            this.b = (byte)b;
        }

        public void writeObject(Marshaller marshaller, Object object) throws IOException {
            marshaller.writeByte((int)this.b);
        }

        public int getByte() {
            return this.b & 0xFF;
        }
    }
}

