/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.remoting3.stream.ObjectSink;
import org.jboss.remoting3.stream.ObjectSource;
import org.jboss.xnio.OptionMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PrimaryClassTable
implements ClassTable {
    static final PrimaryClassTable INSTANCE = new PrimaryClassTable();
    private static final List<Class<?>> READ_TABLE;
    private static final Map<Class<?>, ClassTable.Writer> WRITE_TABLE;
    private static final int CLASS_MAX = 8;
    private static final int CLASS_INPUT_STREAM = 0;
    private static final int CLASS_OUTPUT_STREAM = 1;
    private static final int CLASS_READER = 2;
    private static final int CLASS_WRITER = 3;
    private static final int CLASS_OBJECT_SOURCE = 4;
    private static final int CLASS_OBJECT_SINK = 5;
    private static final int CLASS_OPTION_MAP = 6;

    private PrimaryClassTable() {
    }

    private static void add(Map<Class<?>, ClassTable.Writer> map, List<Class<?>> list, Class<?> clazz, int idx) {
        map.put(clazz, new ByteWriter(idx));
        list.set(idx, clazz);
    }

    public ClassTable.Writer getClassWriter(Class<?> clazz) throws IOException {
        return WRITE_TABLE.get(clazz);
    }

    public Class<?> readClass(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        return READ_TABLE.get(unmarshaller.readUnsignedByte());
    }

    static {
        IdentityHashMap map = new IdentityHashMap();
        List<Class<?>> list = Arrays.asList(new Class[8]);
        PrimaryClassTable.add(map, list, InputStream.class, 0);
        PrimaryClassTable.add(map, list, OutputStream.class, 1);
        PrimaryClassTable.add(map, list, Reader.class, 2);
        PrimaryClassTable.add(map, list, Writer.class, 3);
        PrimaryClassTable.add(map, list, ObjectSource.class, 4);
        PrimaryClassTable.add(map, list, ObjectSink.class, 5);
        PrimaryClassTable.add(map, list, OptionMap.class, 6);
        READ_TABLE = list;
        WRITE_TABLE = map;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ByteWriter
    implements ClassTable.Writer {
        private final byte b;

        public ByteWriter(int b) {
            this.b = (byte)b;
        }

        public void writeClass(Marshaller marshaller, Class<?> clazz) throws IOException {
            marshaller.writeByte((int)this.b);
        }
    }
}

